/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeUnit;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  numFields={EffortDescription.FISHING_OPERATION, EffortDescription.GEARS_NUMBER_PER_OPERATION, EffortDescription.CREW_SIZE, EffortDescription.UNIT_COST_OF_FISHING, EffortDescription.FIXED_CREW_SALARY, EffortDescription.CREW_SHARE_RATE, EffortDescription.CREW_FOOD_COST, EffortDescription.REPAIR_AND_MAINTENANCE_GEAR_COST, EffortDescription.OTHER_RUNNING_COST, EffortDescription.LANDING_COSTS}
)

public interface EffortDescription extends TopiaEntity {     String FISHING_OPERATION = "fishingOperation";
     String FISHING_OPERATION_DURATION = "fishingOperationDuration";
     String GEARS_NUMBER_PER_OPERATION = "gearsNumberPerOperation";
     String CREW_SIZE = "crewSize";
     String UNIT_COST_OF_FISHING = "unitCostOfFishing";
     String FIXED_CREW_SALARY = "fixedCrewSalary";
     String CREW_SHARE_RATE = "crewShareRate";
     String CREW_FOOD_COST = "crewFoodCost";
     String REPAIR_AND_MAINTENANCE_GEAR_COST = "repairAndMaintenanceGearCost";
     String OTHER_RUNNING_COST = "otherRunningCost";
     String LANDING_COSTS = "landingCosts";
     String SET_OF_VESSELS = "setOfVessels";
     String POSSIBLE_METIERS = "possibleMetiers";
    /**
     * setFishingOperation :
     * <p>Nombre d'op&eacute;ration de p&ecirc;che par jour</p>

     * @param fishingOperation La valeur de l'attribut fishingOperation à positionner.
     */

     void setFishingOperation(int fishingOperation);

    /**
     * getFishingOperation :
     * <p>Nombre d'op&eacute;ration de p&ecirc;che par jour</p>

     * @return int 
     */

     int getFishingOperation();

    /**
     * setFishingOperationDuration :
     * @param fishingOperationDuration La valeur de l'attribut fishingOperationDuration à positionner.
     */

     void setFishingOperationDuration(TimeUnit fishingOperationDuration);

    /**
     * getFishingOperationDuration :
     * @return TimeUnit 
     */

     TimeUnit getFishingOperationDuration();

    /**
     * setGearsNumberPerOperation :
     * @param gearsNumberPerOperation La valeur de l'attribut gearsNumberPerOperation à positionner.
     */

     void setGearsNumberPerOperation(int gearsNumberPerOperation);

    /**
     * getGearsNumberPerOperation :
     * @return int 
     */

     int getGearsNumberPerOperation();

    /**
     * setCrewSize :
     * <p>Taille de l'&eacute;quipage pour le m&eacute;tier. Ne peut-&ecirc;tre inf&eacute;rieur &agrave; VesselType.minCrewSize.</p>

     * @param crewSize La valeur de l'attribut crewSize à positionner.
     */

     void setCrewSize(int crewSize);

    /**
     * getCrewSize :
     * <p>Taille de l'&eacute;quipage pour le m&eacute;tier. Ne peut-&ecirc;tre inf&eacute;rieur &agrave; VesselType.minCrewSize.</p>

     * @return int 
     */

     int getCrewSize();

    /**
     * setUnitCostOfFishing :
     * <p>Co&ucirc;t de fonctionnement li&eacute; &agrave; une op&eacute;ration de p&ecirc;che: carburant, huile, app&acirc;t, glace (hors transport sur zone)</p>

     * @param unitCostOfFishing La valeur de l'attribut unitCostOfFishing à positionner.
     */

     void setUnitCostOfFishing(double unitCostOfFishing);

    /**
     * getUnitCostOfFishing :
     * <p>Co&ucirc;t de fonctionnement li&eacute; &agrave; une op&eacute;ration de p&ecirc;che: carburant, huile, app&acirc;t, glace (hors transport sur zone)</p>

     * @return double 
     */

     double getUnitCostOfFishing();

    /**
     * setFixedCrewSalary :
     * <p>Salaire fixe pour l'ensemble de l'&eacute;quipage pour un mois</p>

     * @param fixedCrewSalary La valeur de l'attribut fixedCrewSalary à positionner.
     */

     void setFixedCrewSalary(double fixedCrewSalary);

    /**
     * getFixedCrewSalary :
     * <p>Salaire fixe pour l'ensemble de l'&eacute;quipage pour un mois</p>

     * @return double 
     */

     double getFixedCrewSalary();

    /**
     * setCrewShareRate :
     * <p>Taux de part de l'&eacute;quipage</p>

     * @param crewShareRate La valeur de l'attribut crewShareRate à positionner.
     */

     void setCrewShareRate(double crewShareRate);

    /**
     * getCrewShareRate :
     * <p>Taux de part de l'&eacute;quipage</p>

     * @return double 
     */

     double getCrewShareRate();

    /**
     * setCrewFoodCost :
     * <p>Frais de vivres pour l'ensemble de l'&eacute;quipage par jour.</p>

     * @param crewFoodCost La valeur de l'attribut crewFoodCost à positionner.
     */

     void setCrewFoodCost(double crewFoodCost);

    /**
     * getCrewFoodCost :
     * <p>Frais de vivres pour l'ensemble de l'&eacute;quipage par jour.</p>

     * @return double 
     */

     double getCrewFoodCost();

    /**
     * setRepairAndMaintenanceGearCost :
     * <p>Co&ucirc;t de maintenance et de r&eacute;paration par jour d'utilisation</p>

     * @param repairAndMaintenanceGearCost La valeur de l'attribut repairAndMaintenanceGearCost à positionner.
     */

     void setRepairAndMaintenanceGearCost(double repairAndMaintenanceGearCost);

    /**
     * getRepairAndMaintenanceGearCost :
     * <p>Co&ucirc;t de maintenance et de r&eacute;paration par jour d'utilisation</p>

     * @return double 
     */

     double getRepairAndMaintenanceGearCost();

    /**
     * setOtherRunningCost :
     * <p>autres co&ucirc;ts par jour</p>

     * @param otherRunningCost La valeur de l'attribut otherRunningCost à positionner.
     */

     void setOtherRunningCost(double otherRunningCost);

    /**
     * getOtherRunningCost :
     * <p>autres co&ucirc;ts par jour</p>

     * @return double 
     */

     double getOtherRunningCost();

    /**
     * setLandingCosts :
     * @param landingCosts La valeur de l'attribut landingCosts à positionner.
     */

     void setLandingCosts(double landingCosts);

    /**
     * getLandingCosts :
     * @return double 
     */

     double getLandingCosts();

    /**
     * setSetOfVessels :
     * @param value La valeur de l'attribut setOfVessels à positionner.
     */

     void setSetOfVessels(SetOfVessels value);

    /**
     * getSetOfVessels :
     * Retourne la valeur de l'attribut setOfVessels.
     * @return SetOfVessels 
     */

     SetOfVessels getSetOfVessels();

    /**
     * setPossibleMetiers :
     * @param value La valeur de l'attribut possibleMetiers à positionner.
     */

     void setPossibleMetiers(Metier value);

    /**
     * getPossibleMetiers :
     * Retourne la valeur de l'attribut possibleMetiers.
     * @return Metier 
     */

     Metier getPossibleMetiers();

    /**
     * toString :
     * @return String 
     */

     String toString();


} //EffortDescription
