/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class CellDAOAbstract<E extends Cell> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Cell.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<Zone> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from zone main, cell_zone secondary " +
                    "where main.topiaid=secondary.zone" +
                    " and secondary.cell='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(Zone.class)).list();

            for (Zone item : list) {
                item.removeCell(entity);
            }
        }

                                        {
                                        List<Port> list = getContext()
                                                    .getDAO(Port.class)
                                                    .findAllByProperties(Port.CELL, entity);
                        //                            .findAllByProperties("cell", entity);
                                            for (Port item : list) {
                                                item.setCell(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Cell.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Cell.NAME, v);
        return result;
    }

    /**
     * findByLatitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut latitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLatitude(float v) throws TopiaException {
        E result = findByProperty(Cell.LATITUDE, v);
        return result;
    }

    /**
     * findAllByLatitude :
     * Retourne les éléments ayant comme valeur pour l'attribut latitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLatitude(float v) throws TopiaException {
        List<E> result = findAllByProperty(Cell.LATITUDE, v);
        return result;
    }

    /**
     * findByLongitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut longitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLongitude(float v) throws TopiaException {
        E result = findByProperty(Cell.LONGITUDE, v);
        return result;
    }

    /**
     * findAllByLongitude :
     * Retourne les éléments ayant comme valeur pour l'attribut longitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLongitude(float v) throws TopiaException {
        List<E> result = findAllByProperty(Cell.LONGITUDE, v);
        return result;
    }

    /**
     * findByLand :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut land le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLand(boolean v) throws TopiaException {
        E result = findByProperty(Cell.LAND, v);
        return result;
    }

    /**
     * findAllByLand :
     * Retourne les éléments ayant comme valeur pour l'attribut land le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLand(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Cell.LAND, v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Cell.COMMENT, v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Cell.COMMENT, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Zone.class) {
            ZoneDAO dao = (ZoneDAO)
                getContext().getDAO(Zone.class);
            tmp = dao.findAllContainsCell(entity);
//            tmp = dao.findAllByProperties(Zone.CELL, entity);
            result.addAll(tmp);
        }

        if (type == Port.class) {
            PortDAO dao = (PortDAO)
                getContext().getDAO(Port.class);
            tmp = dao.findAllByCell(entity);
//            tmp = dao.findAllByProperties(Port.CELL, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);
        
        List<? extends TopiaEntity> list;

        list = findUsages(Zone.class, entity);
        if (!list.isEmpty()) {
            result.put(Zone.class, list);
        }

        list = findUsages(Port.class, entity);
        if (!list.isEmpty()) {
            result.put(Port.class, list);
        }

        return result;
    }


} //CellDAOAbstract<E extends Cell>
