/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class ActiveRuleAbstract extends TopiaEntityAbstract implements ActiveRule {

    protected Date activeRuleDate;
    protected String name;
    protected String param;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(ActiveRule.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(ActiveRule.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, ACTIVE_RULE_DATE, Date.class, activeRuleDate);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, PARAM, String.class, param);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setActiveRuleDate :
     * @param value 
     */

    public void setActiveRuleDate(Date value) {
        Date _oldValue = this.activeRuleDate;
        fireOnPreWrite(ACTIVE_RULE_DATE, _oldValue, value);
        this.activeRuleDate = value;
        fireOnPostWrite(ACTIVE_RULE_DATE, _oldValue, value);
}

    /**
     * getActiveRuleDate :
     * @return Date 
     */

    public Date getActiveRuleDate() {
        fireOnPreRead(ACTIVE_RULE_DATE, activeRuleDate);
        Date result = this.activeRuleDate;
        fireOnPostRead(ACTIVE_RULE_DATE, activeRuleDate);
        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * setParam :
     * @param value 
     */

    public void setParam(String value) {
        String _oldValue = this.param;
        fireOnPreWrite(PARAM, _oldValue, value);
        this.param = value;
        fireOnPostWrite(PARAM, _oldValue, value);
}

    /**
     * getParam :
     * @return String 
     */

    public String getParam() {
        fireOnPreRead(PARAM, param);
        String result = this.param;
        fireOnPostRead(PARAM, param);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(ACTIVE_RULE_DATE, this.activeRuleDate).
            append(NAME, this.name).
            append(PARAM, this.param).
         toString();
        return result;
}


} //ActiveRuleAbstract
