/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish;

import fr.ifremer.isisfish.entities.ActiveRule;
import fr.ifremer.isisfish.entities.ActiveRuleDAO;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.CellDAO;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.EffortDescriptionDAO;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.EquationDAO;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.FisheryRegionDAO;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.GearDAO;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierDAO;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.MetierSeasonInfoDAO;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationDAO;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationGroupDAO;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoDAO;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.PortDAO;
import fr.ifremer.isisfish.entities.Result;
import fr.ifremer.isisfish.entities.ResultDAO;
import fr.ifremer.isisfish.entities.Season;
import fr.ifremer.isisfish.entities.SeasonDAO;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.SelectivityDAO;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.SetOfVesselsDAO;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.SpeciesDAO;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyDAO;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.StrategyMonthInfoDAO;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.entities.TargetSpeciesDAO;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.TripTypeDAO;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.entities.VesselTypeDAO;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.entities.ZoneDAO;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;


public class IsisFishDAOHelper {



    public enum IsisFishEntityEnum implements TopiaEntityEnum {

        ActiveRule(ActiveRule.class),
        Cell(Cell.class),
        EffortDescription(EffortDescription.class),
        Equation(Equation.class),
        FisheryRegion(FisheryRegion.class),
        Gear(Gear.class),
        Metier(Metier.class),
        MetierSeasonInfo(MetierSeasonInfo.class),
        Population(Population.class),
        PopulationGroup(PopulationGroup.class),
        PopulationSeasonInfo(PopulationSeasonInfo.class),
        Port(Port.class),
        Result(Result.class),
        Season(Season.class),
        Selectivity(Selectivity.class),
        SetOfVessels(SetOfVessels.class),
        Species(Species.class),
        Strategy(Strategy.class),
        StrategyMonthInfo(StrategyMonthInfo.class),
        TargetSpecies(TargetSpecies.class),
        TripType(TripType.class),
        VesselType(VesselType.class),
        Zone(Zone.class);
        /**
         * the contract of the entity
         */
        protected Class<? extends TopiaEntity> contract;
        /**
         * the fully qualified name of the implementation of the entity
         */
        protected String implementationFQN;
        /**
         * the implementation class of the entity (will be lazy computed at runtime)
         */
        protected Class<? extends TopiaEntity> implementation;
        /**
         * IsisFishEntityEnum :
             * @param contract 
     */

         IsisFishEntityEnum(Class<? extends TopiaEntity > contract)     {
        this.contract = contract;
        this.implementationFQN = contract.getName()+"Impl";
        }

        /**
         * getContract :
             * @return Class<? extends TopiaEntity> 
     */

        public Class<? extends TopiaEntity> getContract()     {
        return contract;
        }

        /**
         * getImplementationFQN :
             * @return String 
     */

        public String getImplementationFQN()     {
        return implementationFQN;
        }

        /**
         * setImplementationFQN :
             * @param implementationFQN 
     */

        public void setImplementationFQN(String implementationFQN)     {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
        }

        /**
         * accept :
             * @param klass 
         * @return boolean 
     */

        public boolean accept(Class<? extends TopiaEntity> klass)     {
         return IsisFishDAOHelper.getContractClass(klass) == contract;
         }

        /**
         * getImplementation :
             * @return Class<? extends TopiaEntity> 
     */

        public Class<? extends TopiaEntity> getImplementation()     {
         if (implementation == null) {
            try {
                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
                } catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find class " + implementationFQN);
                }
         }
         return implementation;
         }

        /**
         * valueOf :
             * @param entity 
         * @return IsisFishEntityEnum 
     */

        public static IsisFishEntityEnum valueOf(TopiaEntity entity)     {
         return valueOf(entity.getClass());
         }

        /**
         * valueOf :
             * @param klass 
         * @return IsisFishEntityEnum 
     */

        public static IsisFishEntityEnum valueOf(Class<?> klass)     {
         if (klass.isInterface()) {
            return IsisFishEntityEnum.valueOf(klass.getSimpleName());
         }
         for (IsisFishEntityEnum entityEnum : IsisFishEntityEnum.values()) {
             if (entityEnum.getContract().isAssignableFrom(klass)) {
                 //todo check it works for inheritance
                 return entityEnum;
             }
         }
         throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(IsisFishEntityEnum.values()));
         }


    } //IsisFishEntityEnum
        /**
         * IsisFishDAOHelper :
         */

        protected IsisFishDAOHelper()     {     }

        /**
         * getModelVersion :
             * @return String 
     */

        public static String getModelVersion()     {
        return "3.3";
        }

        /**
         * getModelName :
             * @return String 
     */

        public static String getModelName()     {
        return "IsisFish";
        }

        /**
         * getActiveRuleDAO :
             * @param context 
         * @return ActiveRuleDAO 
         * @throws TopiaException
     */

        public static ActiveRuleDAO getActiveRuleDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ActiveRuleDAO result = (ActiveRuleDAO) ci.getDAO(ActiveRule.class);
        return result;
        }

        /**
         * getCellDAO :
             * @param context 
         * @return CellDAO 
         * @throws TopiaException
     */

        public static CellDAO getCellDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CellDAO result = (CellDAO) ci.getDAO(Cell.class);
        return result;
        }

        /**
         * getEffortDescriptionDAO :
             * @param context 
         * @return EffortDescriptionDAO 
         * @throws TopiaException
     */

        public static EffortDescriptionDAO getEffortDescriptionDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        EffortDescriptionDAO result = (EffortDescriptionDAO) ci.getDAO(EffortDescription.class);
        return result;
        }

        /**
         * getEquationDAO :
             * @param context 
         * @return EquationDAO 
         * @throws TopiaException
     */

        public static EquationDAO getEquationDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        EquationDAO result = (EquationDAO) ci.getDAO(Equation.class);
        return result;
        }

        /**
         * getFisheryRegionDAO :
             * @param context 
         * @return FisheryRegionDAO 
         * @throws TopiaException
     */

        public static FisheryRegionDAO getFisheryRegionDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        FisheryRegionDAO result = (FisheryRegionDAO) ci.getDAO(FisheryRegion.class);
        return result;
        }

        /**
         * getGearDAO :
             * @param context 
         * @return GearDAO 
         * @throws TopiaException
     */

        public static GearDAO getGearDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        GearDAO result = (GearDAO) ci.getDAO(Gear.class);
        return result;
        }

        /**
         * getMetierDAO :
             * @param context 
         * @return MetierDAO 
         * @throws TopiaException
     */

        public static MetierDAO getMetierDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        MetierDAO result = (MetierDAO) ci.getDAO(Metier.class);
        return result;
        }

        /**
         * getMetierSeasonInfoDAO :
             * @param context 
         * @return MetierSeasonInfoDAO 
         * @throws TopiaException
     */

        public static MetierSeasonInfoDAO getMetierSeasonInfoDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        MetierSeasonInfoDAO result = (MetierSeasonInfoDAO) ci.getDAO(MetierSeasonInfo.class);
        return result;
        }

        /**
         * getPopulationDAO :
             * @param context 
         * @return PopulationDAO 
         * @throws TopiaException
     */

        public static PopulationDAO getPopulationDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PopulationDAO result = (PopulationDAO) ci.getDAO(Population.class);
        return result;
        }

        /**
         * getPopulationGroupDAO :
             * @param context 
         * @return PopulationGroupDAO 
         * @throws TopiaException
     */

        public static PopulationGroupDAO getPopulationGroupDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PopulationGroupDAO result = (PopulationGroupDAO) ci.getDAO(PopulationGroup.class);
        return result;
        }

        /**
         * getPopulationSeasonInfoDAO :
             * @param context 
         * @return PopulationSeasonInfoDAO 
         * @throws TopiaException
     */

        public static PopulationSeasonInfoDAO getPopulationSeasonInfoDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PopulationSeasonInfoDAO result = (PopulationSeasonInfoDAO) ci.getDAO(PopulationSeasonInfo.class);
        return result;
        }

        /**
         * getPortDAO :
             * @param context 
         * @return PortDAO 
         * @throws TopiaException
     */

        public static PortDAO getPortDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PortDAO result = (PortDAO) ci.getDAO(Port.class);
        return result;
        }

        /**
         * getResultDAO :
             * @param context 
         * @return ResultDAO 
         * @throws TopiaException
     */

        public static ResultDAO getResultDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ResultDAO result = (ResultDAO) ci.getDAO(Result.class);
        return result;
        }

        /**
         * getSeasonDAO :
             * @param context 
         * @return SeasonDAO 
         * @throws TopiaException
     */

        public static SeasonDAO getSeasonDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SeasonDAO result = (SeasonDAO) ci.getDAO(Season.class);
        return result;
        }

        /**
         * getSelectivityDAO :
             * @param context 
         * @return SelectivityDAO 
         * @throws TopiaException
     */

        public static SelectivityDAO getSelectivityDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SelectivityDAO result = (SelectivityDAO) ci.getDAO(Selectivity.class);
        return result;
        }

        /**
         * getSetOfVesselsDAO :
             * @param context 
         * @return SetOfVesselsDAO 
         * @throws TopiaException
     */

        public static SetOfVesselsDAO getSetOfVesselsDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SetOfVesselsDAO result = (SetOfVesselsDAO) ci.getDAO(SetOfVessels.class);
        return result;
        }

        /**
         * getSpeciesDAO :
             * @param context 
         * @return SpeciesDAO 
         * @throws TopiaException
     */

        public static SpeciesDAO getSpeciesDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SpeciesDAO result = (SpeciesDAO) ci.getDAO(Species.class);
        return result;
        }

        /**
         * getStrategyDAO :
             * @param context 
         * @return StrategyDAO 
         * @throws TopiaException
     */

        public static StrategyDAO getStrategyDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        StrategyDAO result = (StrategyDAO) ci.getDAO(Strategy.class);
        return result;
        }

        /**
         * getStrategyMonthInfoDAO :
             * @param context 
         * @return StrategyMonthInfoDAO 
         * @throws TopiaException
     */

        public static StrategyMonthInfoDAO getStrategyMonthInfoDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        StrategyMonthInfoDAO result = (StrategyMonthInfoDAO) ci.getDAO(StrategyMonthInfo.class);
        return result;
        }

        /**
         * getTargetSpeciesDAO :
             * @param context 
         * @return TargetSpeciesDAO 
         * @throws TopiaException
     */

        public static TargetSpeciesDAO getTargetSpeciesDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TargetSpeciesDAO result = (TargetSpeciesDAO) ci.getDAO(TargetSpecies.class);
        return result;
        }

        /**
         * getTripTypeDAO :
             * @param context 
         * @return TripTypeDAO 
         * @throws TopiaException
     */

        public static TripTypeDAO getTripTypeDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TripTypeDAO result = (TripTypeDAO) ci.getDAO(TripType.class);
        return result;
        }

        /**
         * getVesselTypeDAO :
             * @param context 
         * @return VesselTypeDAO 
         * @throws TopiaException
     */

        public static VesselTypeDAO getVesselTypeDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        VesselTypeDAO result = (VesselTypeDAO) ci.getDAO(VesselType.class);
        return result;
        }

        /**
         * getZoneDAO :
             * @param context 
         * @return ZoneDAO 
         * @throws TopiaException
     */

        public static ZoneDAO getZoneDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ZoneDAO result = (ZoneDAO) ci.getDAO(Zone.class);
        return result;
        }

        /**
         * getDAO :
             * @param context 
         * @param klass 
         * @return <T extends TopiaEntity, D extends TopiaDAO<? super T>> D 
         * @throws TopiaException
     */

        public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        IsisFishEntityEnum constant = IsisFishEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
        }

        /**
         * getDAO :
             * @param context 
         * @param entity 
         * @return <T extends TopiaEntity, D extends TopiaDAO<? super T>> D 
         * @throws TopiaException
     */

        public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        IsisFishEntityEnum constant = IsisFishEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
        }

        /**
         * getContractClass :
             * @param klass 
         * @return <T extends TopiaEntity> Class<T> 
     */

        public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass)     {
        IsisFishEntityEnum constant = IsisFishEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
        }

        /**
         * getImplementationClass :
             * @param klass 
         * @return <T extends TopiaEntity> Class<T> 
     */

        public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass)     {
        IsisFishEntityEnum constant = IsisFishEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
        }

        /**
         * getContractClasses :
             * @return Class<? extends TopiaEntity>[] 
     */

        public static Class<? extends TopiaEntity>[] getContractClasses()     {
        IsisFishEntityEnum[] values = IsisFishEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
        }

        /**
         * getImplementationClasses :
             * @return Class<? extends TopiaEntity>[] 
     */

        public static Class<? extends TopiaEntity>[] getImplementationClasses()     {
        IsisFishEntityEnum[] values = IsisFishEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
        }

        /**
         * getImplementationClassesAsString :
             * @return String 
     */

        public static String getImplementationClassesAsString()     {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
        }

        /**
         * getContracts :
             * @return IsisFishEntityEnum[] 
     */

        public static IsisFishEntityEnum[] getContracts()     {
        return IsisFishEntityEnum.values();
        }


    } //IsisFishDAOHelper
