/*
 * Decompiled with CFR 0.152.
 */
package sensitivityexports;

import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import scripts.ResultName;

public class SensitivitySpawningBiomassY2
implements SensitivityExport {
    private static Log log = LogFactory.getLog(SensitivitySpawningBiomassY2.class);
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_BIOMASS};
    @Doc(value="Population")
    public Population param_pop;

    public void export(SimulationStorage simulation, Writer out) throws Exception {
        TimeStep lastStep = simulation.getResultStorage().getLastStep();
        double biomass = 0.0;
        for (Population pop : simulation.getParameter().getPopulations()) {
            if (!pop.getName().equals(this.param_pop.getName())) continue;
            ResultStorage resultStorage = simulation.getResultStorage();
            MatrixND matlastdate = resultStorage.getMatrix(pop, ResultName.MATRIX_BIOMASS);
            MatrixIterator i = matlastdate.iterator();
            while (i.hasNext()) {
                i.next();
                Object[] sems = i.getSemanticsCoordinates();
                TimeStep step = (TimeStep)sems[0];
                PopulationGroup group = (PopulationGroup)sems[1];
                if (!step.equals((Object)lastStep)) continue;
                biomass += i.getValue() * group.getMaturityOgive();
            }
        }
        out.write(Double.toString(biomass));
    }

    public String getDescription() {
        return "Biomass of the genitors for the last time step. Biomass is the sum on the groups and zones";
    }

    public String getExportFilename() {
        return "SensitivityGenitorBiomassY2_" + this.param_pop.getName();
    }

    public String getExtensionFilename() {
        return ".csv";
    }

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }
}

