/*
 * Decompiled with CFR 0.152.
 */
package sensitivityanalysis;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.sensitivity.AbstractSensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.Scenario;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityException;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityScenarios;
import fr.ifremer.isisfish.util.Doc;
import java.io.File;
import java.util.List;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.types.RDataFrame;

public class OptimumLHS
extends AbstractSensitivityAnalysis {
    @Doc(value="Number of simulations (default=10)")
    public int param_simulationNumber = 10;
    @Doc(value="The maximum number of times the Columnwise Pairwise algorithm is applied to all the columns(default=2).")
    public int param_MaxSweeps = 2;
    @Doc(value="The optimal stopping criterion (between 0 and 1) (default=0.1).")
    public double param_eps = 0.1;
    @Doc(value="True to be able to modify the code sent to R")
    public boolean param_modifR = false;

    public boolean canManageCardinality() {
        return true;
    }

    public SensitivityScenarios compute(DesignPlan plan, File outputDirectory) throws SensitivityException {
        this.setIsisFactorsR(plan, outputDirectory);
        int factorNumber = plan.getFactors().size();
        List factors = plan.getFactors();
        SensitivityScenarios thisExperiment = new SensitivityScenarios();
        List thisExperimentScenarios = thisExperiment.getScenarios();
        this.checkAllFactorContinuous(factors);
        try {
            REngine engine = this.openEngine(outputDirectory);
            engine.voidEval("library(lhs)");
            String rInstruction = "isis.methodAnalyse<-optimumLHS(n=%s,k=%s,maxSweeps=%s,eps=%s)";
            String rCall = String.format(rInstruction, this.param_simulationNumber, factorNumber, this.param_MaxSweeps, this.param_eps);
            if (this.param_modifR) {
                rCall = this.editRInstruction(rCall);
            }
            engine.voidEval(rCall);
            engine.eval("expPlan<-as.data.frame(isis.methodAnalyse)");
            RDataFrame dataFrame = (RDataFrame)engine.eval("expPlan");
            dataFrame.setVariable("expPlan");
            int j = 0;
            while (j < this.param_simulationNumber) {
                Scenario experimentScenario = new Scenario();
                int i = 0;
                while (i < factorNumber) {
                    Factor factor = (Factor)plan.getFactors().get(i);
                    factor.setValueForIdentifier(dataFrame.get(i, j));
                    experimentScenario.addFactor(factor);
                    ++i;
                }
                thisExperimentScenarios.add(experimentScenario);
                thisExperiment.setScenarios(thisExperimentScenarios);
                ++j;
            }
            engine.voidEval(this.getIsisFactorDistribution(factors));
            engine.voidEval("call<-\"isis.methodAnalyse<-optimumLHS(n=" + this.param_simulationNumber + ",k=" + factorNumber + ",maxSweeps=" + this.param_MaxSweeps + ",eps=" + this.param_eps + ")\"");
            engine.voidEval("isis.methodExp<-list(\"isis.factors\"=isis.factors,\"isis.factor.distribution\"=isis.factor.distribution,\"call\"=call)");
            engine.voidEval("attr(isis.methodExp,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("isis.simule<-data.frame(isis.methodAnalyse)");
            engine.voidEval("attr(isis.simule,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("names(isis.simule)<-isis.factors[[1]]");
            String data = "data<-data.frame(";
            int j2 = 0;
            while (j2 < factors.size()) {
                Scenario scenario = (Scenario)thisExperimentScenarios.get(0);
                Factor factor = (Factor)scenario.getFactors().get(j2);
                String factorName = factor.getName().replaceAll(" ", "");
                String vector = String.valueOf(factorName) + "<-c(";
                int i = 0;
                while (i < this.param_simulationNumber) {
                    Scenario tempScenario = (Scenario)thisExperimentScenarios.get(i);
                    Factor tempFactor = (Factor)tempScenario.getFactors().get(j2);
                    Object value = tempFactor.getDisplayedValue();
                    vector = i < this.param_simulationNumber - 1 ? String.valueOf(vector) + value + "," : String.valueOf(vector) + value;
                    ++i;
                }
                vector = String.valueOf(vector) + ")";
                engine.voidEval(vector);
                data = j2 < factors.size() - 1 ? String.valueOf(data) + factorName + "=factor(" + factorName + ")," : String.valueOf(data) + factorName + "=factor(" + factorName + "))";
                ++j2;
            }
            engine.voidEval(data);
            rInstruction = "factornames<-c(";
            int i = 0;
            while (i < factorNumber) {
                rInstruction = i != factorNumber - 1 ? String.valueOf(rInstruction) + "\"" + ((Factor)factors.get(i)).getName() + "\"," : String.valueOf(rInstruction) + "\"" + ((Factor)factors.get(i)).getName() + "\"";
                ++i;
            }
            rInstruction = String.valueOf(rInstruction) + ")";
            engine.voidEval(rInstruction);
            this.closeEngine(engine, outputDirectory);
        }
        catch (Exception e) {
            throw new SensitivityException("Can't generate scenarios", (Throwable)e);
        }
        return thisExperiment;
    }

    public void analyzeResult(List<SimulationStorage> simulationStorages, File outputDirectory) throws SensitivityException {
        SimulationStorage storage = simulationStorages.get(0);
        String simulationName = outputDirectory.getName().replaceAll("-", "");
        try {
            REngine engine = this.openEngine(outputDirectory);
            engine.voidEval("factors<-data.frame(isis.methodAnalyse)");
            engine.voidEval("names(factors)<-isis.factor.distribution$NomFacteur");
            int factorNumber = (Integer)engine.eval("length(factors[1,])");
            this.param_simulationNumber = (Integer)engine.eval("length(factors[,1])");
            SimulationParameter param = storage.getParameter();
            int sensitivityNumber = param.getSensitivityExport().size();
            int k = 0;
            while (k < sensitivityNumber) {
                SensitivityExport sensitivityExport = (SensitivityExport)param.getSensitivityExport().get(k);
                String rInstruction = this.createImportInstruction(sensitivityExport, simulationStorages);
                engine.voidEval(rInstruction);
                engine.voidEval("isis.simule<-data.frame(isis.simule," + sensitivityExport.getExportFilename() + ")");
                ++k;
            }
            engine.voidEval("attr(isis.simule,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("attr(isis.simule,\"call\")<-isis.methodExp$call");
            k = 0;
            while (k < sensitivityNumber) {
                SensitivityExport export = (SensitivityExport)param.getSensitivityExport().get(k);
                String name = export.getExportFilename();
                String dataframe = "dataforaov<-data.frame(factors," + name + "=" + name + ")";
                engine.voidEval(dataframe);
                String aovCall = "aovresult<-aov(" + name + "~";
                int j = 0;
                while (j < factorNumber) {
                    String factorName = (String)engine.eval("names(factors)[" + (j + 1) + "]");
                    factorName = factorName.replaceAll(" ", ".");
                    aovCall = j < factorNumber - 1 ? String.valueOf(aovCall) + factorName + "+" : String.valueOf(aovCall) + factorName + ",data=dataforaov)";
                    ++j;
                }
                engine.voidEval(aovCall);
                engine.voidEval("SoS<-summary(aovresult)[[1]][1:dim(summary(aovresult)[[1]])[1],2]");
                engine.voidEval("names(SoS)<-dimnames(summary(aovresult)[[1]])[[1]][1:dim(summary(aovresult)[[1]])[1]]");
                engine.voidEval("IndSensibilite<-SoS/sum(SoS)");
                engine.voidEval("exportsensitivity<-data.frame(SoS[1:dim(summary(aovresult)[[1]])[1]],IndSensibilite[1:dim(summary(aovresult)[[1]])[1]])");
                engine.voidEval("names(exportsensitivity)<-c(\"Sum Of Squares\",\"Sensitivity indices\")");
                engine.voidEval("row.names(exportsensitivity)<-dimnames(summary(aovresult)[[1]])[1][[1]][1:dim(summary(aovresult)[[1]])[1]]");
                engine.voidEval("names(dataforaov)<-c(isis.factor.distribution$NomFacteur,\"Result\")");
                engine.setwd(outputDirectory);
                engine.voidEval("write.csv(dataforaov,\"" + name + "_Results.csv\")");
                engine.voidEval("write.csv(exportsensitivity,\"" + name + "_SensitivityIndices.csv\")");
                String exportMethodAnalyse = String.format("%s.isis.methodAnalyse", String.valueOf(simulationName) + "." + name);
                engine.voidEval(String.valueOf(exportMethodAnalyse) + "<-list(" + "\"isis.factors\"=isis.factors," + "\"isis.factor.distribution\"=isis.factor.distribution," + "\"isis.simule\"=isis.simule," + "call_method=\"" + aovCall + "\"" + ",\"analysis_result\"=list(aovresult,IndSensibilite))");
                engine.voidEval("attr(" + exportMethodAnalyse + "," + "\"nomModel\")<-\"isis-fish-externe-R\"");
                ++k;
            }
            this.closeEngine(engine, outputDirectory);
        }
        catch (Exception e) {
            throw new SensitivityException("Can't evaluate results", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Implementation of Random Latin Hypercube method method using R (needs 'lhs' package to work)";
    }
}

