/*
 * Decompiled with CFR 0.152.
 */
package exports;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.types.TimeStep;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import scripts.ResultName;

public class CapturesNombre
implements Export {
    private static Log log = LogFactory.getLog(CapturesNombre.class);
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_CATCH_PER_STRATEGY_MET_PER_ZONE_POP};

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getExportFilename() {
        return "CapturesNombre";
    }

    public String getExtensionFilename() {
        return ".csv";
    }

    public String getDescription() {
        return "Export les captures en nombre de la simulation. tableau pop;metier;id;zone;nombre";
    }

    public void export(SimulationStorage simulation, Writer out) throws Exception {
        TimeStep lastStep = simulation.getResultStorage().getLastStep();
        for (Population pop : simulation.getParameter().getPopulations()) {
            TimeStep step = new TimeStep(0);
            while (!step.after(lastStep)) {
                MatrixND mat = simulation.getResultStorage().getMatrix(step, pop, ResultName.MATRIX_CATCH_PER_STRATEGY_MET_PER_ZONE_POP);
                if (mat != null) {
                    mat = mat.sumOverDim(0);
                    MatrixIterator i = mat.iterator();
                    while (i.hasNext()) {
                        i.next();
                        Object[] sems = i.getSemanticsCoordinates();
                        Metier metier = (Metier)sems[1];
                        PopulationGroup group = (PopulationGroup)sems[2];
                        Zone zone = (Zone)sems[3];
                        double val = i.getValue();
                        out.write(String.valueOf(pop.getName()) + ";" + metier.getName() + ";" + group.getId() + ";" + zone.getName() + ";" + step.getStep() + ";" + val + "\n");
                    }
                }
                step = step.next();
            }
        }
    }
}

