/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.ImportType;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.AreaOfOperation;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.services.service.importdata.configurations.VoyageCommonsImportConfiguration;
import fr.ifremer.echobase.ui.actions.importData.AbstractConfigureImport;
import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigureCommonImport
extends AbstractConfigureImport<VoyageCommonsImportConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfigureCommonImport.class);
    protected Map<String, String> missions;
    protected Map<String, String> voyages;
    protected Map<String, String> areaOfOperations;
    protected Map<String, String> importTypes;

    public ConfigureCommonImport() {
        super(VoyageCommonsImportConfiguration.class);
    }

    protected VoyageCommonsImportConfiguration createModel() {
        return new VoyageCommonsImportConfiguration(this.getLocale());
    }

    protected void prepareInputAction(VoyageCommonsImportConfiguration model) {
        this.missions = this.userDbPersistenceService.loadSortAndDecorate(Mission.class);
        this.voyages = this.userDbPersistenceService.loadSortAndDecorate(Voyage.class);
        this.areaOfOperations = this.userDbPersistenceService.loadSortAndDecorate(AreaOfOperation.class);
        this.importTypes = this.decoratorService.decorateEnums((Enum[])ImportType.getCommonImportType());
        if (model.getImportType() == null) {
            model.setImportType(ImportType.COMMON_ALL);
        }
    }

    @InputConfig(methodName="input")
    public String modeAll() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeVoyage() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeTransit() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeTransect() throws Exception {
        return this.execute();
    }

    public Map<String, String> getMissions() {
        return this.missions;
    }

    public Map<String, String> getVoyages() {
        return this.voyages;
    }

    public Map<String, String> getAreaOfOperations() {
        return this.areaOfOperations;
    }

    public Map<String, String> getImportTypes() {
        return this.importTypes;
    }

    public VoyageCommonsImportConfiguration getModelVoyage() {
        return (VoyageCommonsImportConfiguration)this.getModel();
    }

    public void setModelVoyageVoyageFile(File file) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getVoyageFile().setFile(file);
    }

    public void setModelVoyageVoyageFileContentType(String contentType) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getVoyageFile().setContentType(contentType);
    }

    public void setModelVoyageVoyageFileFileName(String fileName) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getVoyageFile().setFileName(fileName);
    }

    public VoyageCommonsImportConfiguration getModelTransit() {
        return (VoyageCommonsImportConfiguration)this.getModel();
    }

    public void setModelTransitTransitFile(File file) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getTransitFile().setFile(file);
    }

    public void setModelTransitTransitFileContentType(String contentType) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getTransitFile().setContentType(contentType);
    }

    public void setModelTransitTransitFileFileName(String fileName) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getTransitFile().setFileName(fileName);
    }

    public VoyageCommonsImportConfiguration getModelTransect() {
        return (VoyageCommonsImportConfiguration)this.getModel();
    }

    public void setModelTransectTransectFile(File file) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getTransectFile().setFile(file);
    }

    public void setModelTransectTransectFileContentType(String contentType) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getTransectFile().setContentType(contentType);
    }

    public void setModelTransectTransectFileFileName(String fileName) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getTransectFile().setFileName(fileName);
    }

    public VoyageCommonsImportConfiguration getModelAll() {
        return (VoyageCommonsImportConfiguration)this.getModel();
    }

    public void setModelAllVoyageFile(File file) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getVoyageFile().setFile(file);
    }

    public void setModelAllVoyageFileContentType(String contentType) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getVoyageFile().setContentType(contentType);
    }

    public void setModelAllVoyageFileFileName(String fileName) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getVoyageFile().setFileName(fileName);
    }

    public void setModelAllTransitFile(File file) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getTransitFile().setFile(file);
    }

    public void setModelAllTransitFileContentType(String contentType) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getTransitFile().setContentType(contentType);
    }

    public void setModelAllTransitFileFileName(String fileName) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getTransitFile().setFileName(fileName);
    }

    public void setModelAllTransectFile(File file) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getTransectFile().setFile(file);
    }

    public void setModelAllTransectFileContentType(String contentType) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getTransectFile().setContentType(contentType);
    }

    public void setModelAllTransectFileFileName(String fileName) {
        ((VoyageCommonsImportConfiguration)this.getModel()).getTransectFile().setFileName(fileName);
    }
}

