/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.services.service.DbEditorService;
import fr.ifremer.echobase.services.service.exportdb.ExportService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import fr.ifremer.echobase.ui.actions.dbeditor.ImportTable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.metadata.TableMeta;

public class ExportTable
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ImportTable.class);
    protected EchoBaseEntityEnum entityType;
    protected String exportFileName;
    protected boolean exportAsSeen;
    protected transient InputStream inputStream;
    protected long contentLength;
    protected String contentType;
    protected transient DbEditorService dbEditorService;
    protected transient ExportService exportService;

    public void setEntityType(EchoBaseEntityEnum entityType) {
        this.entityType = entityType;
    }

    public String getExportFileName() {
        return this.exportFileName;
    }

    public void setExportFileName(String exportFileName) {
        this.exportFileName = exportFileName;
    }

    public void setExportAsSeen(boolean exportAsSeen) {
        this.exportAsSeen = exportAsSeen;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String execute() throws Exception {
        TableMeta table = this.dbEditorService.getTableMeta(this.entityType);
        String content = this.exportService.exportData(table, this.exportAsSeen);
        if (log.isDebugEnabled()) {
            log.debug((Object)("file to export " + content));
        }
        this.contentLength = content.length() * 2;
        this.contentType = "text/csv";
        this.inputStream = new ByteArrayInputStream(content.getBytes());
        return "success";
    }

    public void setDbEditorService(DbEditorService dbEditorService) {
        this.dbEditorService = dbEditorService;
    }

    public void setExportService(ExportService exportService) {
        this.exportService = exportService;
    }
}

