package fr.ifremer.echobase.ui.actions.workingDb;

/*
 * #%L
 * EchoBase :: UI
 * $Id: AddSpatial.java 872 2013-10-31 21:59:27Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.5/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/workingDb/AddSpatial.java $
 * %%
 * Copyright (C) 2011 - 2013 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.services.service.spatial.SpatialService;

/**
 * To add echobase spatial sutff to curerent working db.
 * <p/>
 * Created on 10/31/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 2.4
 */
public class AddSpatial extends AbstractWorkingDbAction {

    private static final long serialVersionUID = 1L;

    @Override
    public String execute() throws Exception {

        spatialService.addSpatialStructure();

        addFlashMessage(_("echobase.info.workingDbconfiguration.spatialStructureAdded"));
        return SUCCESS;
    }

    //------------------------------------------------------------------------//
    //-- Injected objects                                                     //
    //------------------------------------------------------------------------//

    protected transient SpatialService spatialService;

    public void setSpatialService(SpatialService spatialService) {
        this.spatialService = spatialService;
    }
}
