/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.ActionContext;
import fr.ifremer.echobase.ui.EchoBaseSession;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.web.filter.TopiaTransactionFilter;

public class EchoBaseWorkingDbTransactionFilter
extends TopiaTransactionFilter {
    private static final Log log = LogFactory.getLog(EchoBaseWorkingDbTransactionFilter.class);
    public static final String USER_TRANSACTION = "userTransaction";

    public static TopiaContext getTransaction(ActionContext context) {
        HttpServletRequest request = (HttpServletRequest)context.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        return (TopiaContext)request.getAttribute(USER_TRANSACTION);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.setRequestAttributeName(USER_TRANSACTION);
    }

    public TopiaContext beginTransaction(ServletRequest request) {
        HttpSession session = ((HttpServletRequest)request).getSession();
        Preconditions.checkNotNull((Object)session);
        EchoBaseSession userSession = EchoBaseSession.getEchoBaseSession((HttpSession)session);
        Preconditions.checkNotNull((Object)userSession);
        TopiaContext rootContext = userSession.getWorkingDbRootContext();
        Preconditions.checkNotNull((Object)rootContext);
        try {
            TopiaContext transaction = rootContext.beginTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starts a new working db transaction " + transaction));
            }
            return transaction;
        }
        catch (TopiaException eee) {
            throw new TopiaRuntimeException("Could not start transaction", (Throwable)eee);
        }
    }
}

