<%--
  #%L
  EchoBase :: UI
  
  $Id: configure.jsp 644 2012-09-11 12:48:41Z tchemit $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.2/echobase-ui/src/main/webapp/WEB-INF/jsp/exportDb/configure.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>

<title><s:text name="echobase.title.exportDb"/></title>

<script type="text/javascript">

  jQuery(document).ready(function () {

    // to change form when mode is changed
    $('[name="model.exportDbMode"]').change(function (event) {
      $('[class~="exportDbMode"]').hide();
      $('#' + this.value).show();
      $('#' + this.value + ' .errorMessage').hide();
    });

    // show incoming mode
    var incomingVal = $('[name="model.exportDbMode"][checked="checked"]').val();
    $('#' + incomingVal).show();
  });
</script>

<fieldset>
  <legend>
    <s:text name="echobase.legend.exportDb.configuration.selectExportDbMode"/>
  </legend>
  <s:radio id='mode' key='model.exportDbMode' list="modes" cssClass="cleanBoth"
           label='%{getText("echobase.common.exportDbMode")}'
           required="true" template="myradiomap"/>
</fieldset>

<s:form id="REFERENTIAL" namespace="/exportDb" method="POST"
        cssClass="hidden exportDbMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.exportDb.configuration.files"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="%{getDocumentation('importDb.html','export-referential')}"
           target="doc">
        <s:text name="echobase.action.show.exportDb.documentation"/>
      </s:a>
    </div>
    <br/>

    <s:hidden key="model.exportDbMode" value="REFERENTIAL" label=''/>
    <s:textfield key="model.fileName" required="true" size="100"
                 label="%{getText('echobase.label.exportDbFileName')} (*)"/>

    <div class="cleanBoth">
      (*) <s:text name="echobase.info.exportDb.archive"/>
    </div>
  </fieldset>
  <br/>
  <s:submit action="configureReferential"
            value='%{getText("echobase.action.export")}'/>

</s:form>


<s:form id="REFERENTIAL_AND_DATA" namespace="/exportDb" method="POST"
        cssClass="hidden exportDbMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.exportDb.configuration.files"/>
    </legend>

    <div class="cleanBoth help">
      <s:a
        href="%{getDocumentation('importDb.html','export-referential-and-data')}"
        target="doc">
        <s:text name="echobase.action.show.exportDb.documentation"/>
      </s:a>
    </div>
    <br/>

    <s:hidden key="model.exportDbMode" value="REFERENTIAL_AND_DATA" label=''/>
    <s:textfield key="model.fileName" required="true" size="100"
                 label="%{getText('echobase.label.exportDbFileName')} (*)"/>

    <s:checkboxlist list="voyages" key="model.voyageIds"
                    template="mycheckboxlist"
                    label="%{getText('echobase.label.voyageToSelect')}"/>

    <div class="cleanBoth">
      (*) <s:text name="echobase.info.exportDb.archive"/>
    </div>
  </fieldset>
  <br/>
  <s:submit action="configureReferentialAndData"
            value='%{getText("echobase.action.export")}'/>

</s:form>


<s:form id="DATA" namespace="/exportDb" method="POST"
        cssClass="hidden exportDbMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.exportDb.configuration.files"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="%{getDocumentation('importDb.html','export-data')}"
           target="doc">
        <s:text name="echobase.action.show.exportDb.documentation"/>
      </s:a>
    </div>
    <br/>
    <s:hidden key="model.exportDbMode" value="DATA" label=''/>
    <s:textfield key="model.fileName" required="true" size="100"
                 label="%{getText('echobase.label.exportDbFileName')} (*)"/>

    <s:checkboxlist list="voyages" key="model.voyageIds"
                    template="mycheckboxlist"
                    label="%{getText('echobase.label.voyageToSelect')}"/>

    <div class="cleanBoth">
      (*) <s:text name="echobase.info.exportDb.archive"/>
    </div>
  </fieldset>
  <br/>
  <s:submit action="configureData"
            value='%{getText("echobase.action.export")}'/>
</s:form>

<s:form id="ALL" namespace="/exportDb" method="POST"
        cssClass="hidden exportDbMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.exportDb.configuration.files"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="%{getDocumentation('importDb.html','export-all')}"
           target="doc">
        <s:text name="echobase.action.show.exportDb.documentation"/>
      </s:a>
    </div>
    <br/>

    <s:hidden key="model.exportDbMode" value="ALL" label=''/>
    <s:textfield key="model.fileName" required="true" size="100"
                 label="%{getText('echobase.label.exportDbFileName')} (*)"/>

    <div class="cleanBoth">
      (*) <s:text name="echobase.info.exportDb.archive"/>
    </div>
  </fieldset>
  <br/>
  <s:submit action="configureAll" value='%{getText("echobase.action.export")}'/>

</s:form>