/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importDb;

import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.services.AbstractEchobaseActionConfiguration;
import fr.ifremer.echobase.services.importdb.ImportDbConfiguration;
import fr.ifremer.echobase.services.importdb.ImportDbMode;
import fr.ifremer.echobase.services.importdb.ImportDbService;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import fr.ifremer.echobase.ui.actions.importDb.Import;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Import
extends AbstractWaitAndExecAction<ImportDbConfiguration, ImportDbService> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Import.class);

    public Import() {
        super(ImportDbConfiguration.class, ImportDbService.class);
    }

    protected String getSuccesMessage() {
        return this._("echobase.info.importDb.succeded", new Object[0]);
    }

    protected String getErrorMessage() {
        return this._("echobase.info.importDb.failed", new Object[0]);
    }

    protected String getResultMessage(ImportDbConfiguration model) {
        String message;
        ImportDbMode importDbMode = model.getImportDbMode();
        switch (1.$SwitchMap$fr$ifremer$echobase$services$importdb$ImportDbMode[model.getImportDbMode().ordinal()]) {
            case 1: {
                message = this._("echobase.importDb.referentialResult", new Object[]{model.getActionTime()});
                break;
            }
            case 2: {
                message = this._("echobase.importDb.dataResult", new Object[]{model.getActionTime()});
                break;
            }
            case 3: {
                message = this._("echobase.importDb.freeResult", new Object[]{model.getActionTime()});
                break;
            }
            default: {
                throw new IllegalStateException("Can't reach here...");
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Result: " + message));
        }
        return message;
    }

    public String getActionResumeTitle() {
        return this._("echobase.legend.importDb.resume", new Object[0]);
    }

    protected void startAction(ImportDbService service, ImportDbConfiguration model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start imports with file " + model.getInput().getFileName()));
        }
        EchoBaseUser user = this.getEchoBaseSession().getUser();
        service.doImport(model, user);
    }

    protected void closeAction(ImportDbConfiguration model) throws Exception {
        this.destroyModel((AbstractEchobaseActionConfiguration)model);
    }
}

