<%--
  #%L
  EchoBase :: UI
  
  $Id: dbeditor.jsp 59 2011-11-13 22:47:30Z tchemit $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.1/echobase-ui/src/main/webapp/WEB-INF/jsp/dbeditor/dbeditor.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<%@ taglib prefix="sjg" uri="/struts-jquery-grid-tags" %>

<s:url id="reloadUrl" action="dbeditor" namespace="/dbeditor"/>

<title><s:text name="echobase.title.dbEditor"/></title>

<script type="text/javascript">

  jQuery(document).ready(function () {

    $('[name="tableName"]').change(function(event) {
      var url = "${reloadUrl}?" + $.param({tableName:this.value});
      window.location = url;
    });
  });

  function formatEntityLabel(cellvalue, options, rowObject) {
    var columnName = options.colModel.name + "_lib";
    return rowObject[columnName];
  }
</script>

<div>
  <s:select key="tableName" label='%{getText("echobase.common.tableName")}'
            list="tableNames" headerKey="" headerValue=""/>
</div>
<br/>

<s:if test="tableName!=null and tableName != ''">
  <s:url id="loadUrl" action="getTableDatas" namespace="/dbeditor"
         escapeAmp="false">
    <s:param name="tableName" value="%{tableName}"/>
  </s:url>

  <s:url id="editUrl" action="editTableData" namespace="/dbeditor"
         escapeAmp="false">
    <s:param name="tableName" value="%{tableName}"/>
  </s:url>


  <sjg:grid id="datas" dataType="json" href="%{loadUrl}" gridModel="datas"
            caption="%{getText('echobase.common.tableDatas', tableNames[tableName])}"
            pager="true" pagerButtons="true" pagerInput="true" navigator="true"
            autowidth="true" rownumbers="false" viewrecords="true"
            navigatorEdit="true" navigatorSearch="true"
            navigatorDelete="false" navigatorAdd="false" resizable="true"
            editurl="%{editUrl}" rowList="10,15,20, 50" rowNum="10"
            navigatorSearchOptions="{multipleGroup:false,showQuery:true,multipleSearch:true,sopt:['eq','ne','cn','nc','bw','bn','ew','en','lt','le','gt','ge','nu','nn','in','ni']}">

    <sjg:gridColumn name="id" title="id" hidden="true" editable="true"/>

    <s:iterator value="columnMetas" var="meta" status="status">

      <s:if test="#meta.fK">

        <s:set name="urlName">getForeignEntitiesUrl_<s:property value="%{#meta.typeSimpleName}"/></s:set>
        <s:url id="urlName"
               action="getForeignEntities"
               namespace="/dbeditor"
               escapeAmp="false">
          <s:param name="entityType" value="%{#meta.typeSimpleName}"/>
        </s:url>
        <sjg:gridColumn name="%{#meta.name}"
                        title="%{getText(#meta.i18nKey)}"
                        edittype='select'
                        editoptions="{dataUrl : '%{urlName}'}"
                        formatter='formatEntityLabel'
                        sortable="true" editable="true"/>
      </s:if>
      <s:else>
        <sjg:gridColumn name="%{#meta.name}"
                        title="%{getText(#meta.i18nKey)}"
                        edittype='%{getEditType(#meta)}'
                        formatter='%{getFormatter(#meta)}'
                        sortable="true" editable="true"/>
      </s:else>


    </s:iterator>

  </sjg:grid>

</s:if>

