/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions;

import fr.ifremer.echobase.entities.Voyage;
import fr.ifremer.echobase.services.VoyageService;
import fr.ifremer.echobase.services.models.ImportModel;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportAction
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(ImportAction.class);
    protected ImportModel importModel;
    protected Map<String, String> voyages;

    public ImportModel getImportModel() {
        if (this.importModel == null) {
            this.importModel = new ImportModel();
        }
        return this.importModel;
    }

    public String getSelectedVoyageId() {
        String selectedVoyageId = this.getImportModel().getSelectedVoyageId();
        return selectedVoyageId;
    }

    public void setSelectedVoyageId(String selectedVoyageId) {
        VoyageService service = (VoyageService)this.newService(VoyageService.class);
        Voyage selectedVoyage = service.getVoyageById(selectedVoyageId);
        this.getImportModel().setSelectedVoyage(selectedVoyage);
    }

    public Map<String, String> getVoyages() {
        return this.voyages;
    }

    public String input() throws Exception {
        VoyageService service = (VoyageService)this.newService(VoyageService.class);
        List allVoyages = service.getVoyages();
        this.voyages = this.sortAndDecorate((Collection)allVoyages, null);
        return "input";
    }

    public String execute() throws Exception {
        log.info((Object)("Will import : " + this.importModel.toString()));
        return "success";
    }

    public void validate() {
        if (!this.importModel.validate()) {
            this.addActionError(this._("echobase.error.importArgument", new Object[0]));
        }
    }
}

