/*
 * #%L
 * $Id: MapDataAction.java 797 2011-03-24 15:45:33Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.3/coser-web/src/main/java/fr/ifremer/coser/web/actions/map/MapDataAction.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.map;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;

/**
 * Appelé par le navigateur pour récuperer le contenu de l'image.
 * 
 * @author chatellier
 * @version $Revision: 797 $
 * 
 * Last update : $Date: 2011-03-24 16:45:33 +0100 (jeu. 24 mars 2011) $
 * By : $Author: chatellier $
 */
public class MapDataAction extends CoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1663244944108703571L;

    protected String zone;

    protected String species;

    public String getZone() {
        return zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getSpecies() {
        return species;
    }
    
    public void setSpecies(String species) {
        this.species = species;
    }
    
    @Action(results= {@Result(type="stream", params={"contentType", "image/png", "inputName", "inputStream"})})
    public String execute() {
        return SUCCESS;
    }
    
    public InputStream getInputStream() {
        WebService webService = ServiceFactory.getWebService();

        InputStream input = null;
        try {
            // work with null species (get Repartition-stations map)
            File mapImage = webService.getMapFile(zone, species);
            input = new FileInputStream(mapImage);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get map file", ex);
        } catch (FileNotFoundException ex) {
            throw new CoserWebException("Can't get map file", ex);
        }
        
        return input;
    }
}
