/*
 * #%L
 * $Id: SurveyAction.java 668 2011-02-04 10:47:43Z chatellier $
 * $HeadURL: svn+ssh://chatellier@labs.libre-entreprise.org/svnroot/coser/tags/coser-1.0.1/coser-web/src/main/java/fr/ifremer/coser/web/actions/map/SurveyAction.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.map;

import java.util.Map;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;

/**
 * Affiche la liste des sous zones (zone).
 * 
 * @author chatellier
 * @version $Revision: 668 $
 * 
 * Last update : $Date: 2011-02-04 11:47:43 +0100 (ven., 04 févr. 2011) $
 * By : $Author: chatellier $
 */
public class SurveyAction extends CoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3385467755357775199L;

    protected String facade;

    protected Map<String, String> surveys;

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getFacade() {
        return facade;
    }

    public Map<String, String> getSurveys() {
        return surveys;
    }
    
    public String getFacadeDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getFacades().get(facade);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get species display name", ex);
        }
        return displayName;
    }

    @Override
    public String execute() {

        WebService webService = ServiceFactory.getWebService();
        try {
            
            // renvoie la liste des id subzone-survey et leurs label
            // associé
            surveys = webService.getSurveyForFacade(facade);

        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone map", ex);
        }

        return SUCCESS;
    }
}
