package fr.ifremer.coser.ui.control;

/*
 * #%L
 * Coser :: UI
 * %%
 * Copyright (C) 2010 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.coser.CoserConstants.Category;
import fr.ifremer.coser.bean.Control;
import fr.ifremer.coser.data.Catch;
import fr.ifremer.coser.data.Haul;
import fr.ifremer.coser.data.Length;
import fr.ifremer.coser.data.Strata;
import fr.ifremer.coser.ui.util.CoserProgressBar;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.TranslucentValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import static org.nuiton.i18n.I18n.t;

public class ControlView extends Table implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN_CATCH = "beanCatch";
    public static final String PROPERTY_BEAN_HAUL = "beanHaul";
    public static final String PROPERTY_BEAN_LENGTH = "beanLength";
    public static final String PROPERTY_BEAN_STRATA = "beanStrata";
    public static final String PROPERTY_CAN_VALID_CONTROL = "canValidControl";
    public static final String PROPERTY_CONTROL = "control";
    public static final String PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_CATCH = "controlDataTableSelectionModelCatch";
    public static final String PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_HAUL = "controlDataTableSelectionModelHaul";
    public static final String PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_LENGTH = "controlDataTableSelectionModelLength";
    public static final String PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_STRATA = "controlDataTableSelectionModelStrata";
    public static final String PROPERTY_GLOBAL_CONTROL_ERROR_SELECTION_MODEL = "globalControlErrorSelectionModel";
    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CONTROL_COMMENT_TEXT = "controlComment.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON4_ENABLED = "$JButton4.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    private static final Log log = LogFactory.getLog(ControlView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Catch beanCatch;
    protected Haul beanHaul;
    protected Length beanLength;
    protected Strata beanStrata;
    protected Boolean canValidControl;
    protected JComboBox categoryComboBox;
    protected ControlCategoryListModel categoryComboBoxModel;
    protected CoserProgressBar checkProgressBar;
    protected JButton compareNumberCatchLengthButton;
    protected Control control;
    protected JTextArea controlComment;
    protected JButton controlDataCancelButton;
    protected JButton controlDataDeleteButton;
    protected JTable controlDataTableCatch;
    protected JTable controlDataTableHaul;
    protected JTable controlDataTableLength;
    protected ListSelectionModel controlDataTableSelectionModelCatch;
    protected ListSelectionModel controlDataTableSelectionModelHaul;
    protected ListSelectionModel controlDataTableSelectionModelLength;
    protected ListSelectionModel controlDataTableSelectionModelStrata;
    protected JTable controlDataTableStrata;
    protected JButton controlDataValidButton;
    protected CardLayout controlTablesLayout;
    protected JPanel controlTablesPanel;
    protected JPanel editionPanel;
    protected JScrollPane editionScrollPane;
    protected SwingValidatorMessageTableModel errorsTableModel;
    protected GlobalControlErrorModel globalControlErrorModel;
    protected TreeSelectionModel globalControlErrorSelectionModel;
    protected JXTreeTable globalControlErrorTable;
    protected ControlHandler handler;
    protected JLabel localControlUsedLabel;
    protected JTable validationMessagesTable;
    @Validator( validatorId = "validatorCatch")
    protected SwingValidator<Catch> validatorCatch;
    @Validator( validatorId = "validatorHaul")
    protected SwingValidator<Haul> validatorHaul;
    protected List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorLength")
    protected SwingValidator<Length> validatorLength;
    @Validator( validatorId = "validatorStrata")
    protected SwingValidator<Strata> validatorStrata;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Component $Component0;
    private Document $Document0;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JButton $JButton3;
    private JButton $JButton4;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;
    private JScrollPane $JScrollPane3;
    private JScrollPane $JScrollPane4;
    private JScrollPane $JScrollPane5;
    private JScrollPane $JScrollPane6;
    private JSplitPane $JSplitPane0;
    private JSplitPane $JSplitPane1;
    private JSplitPane $JSplitPane2;
    private JSplitPane $JSplitPane3;
    private Separator $JToolBar$Separator0;
    private Separator $JToolBar$Separator1;
    private JToolBar $JToolBar0;
    private ControlView $Table0 = this;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            // bean validation
            jaxx.runtime.validator.swing.SwingValidatorUtil.installUI(validationMessagesTable,
                new jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer());
                
            // global validation
            SwingUtil.fixTableColumnWidth(globalControlErrorTable, 1, 25);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ControlView() {
        $initialize();
    }

    public ControlView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().checkData(this);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().displayLengthStructureGraph(this);
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().displayLogReport(this);
    }

    public void doActionPerformed__on__$JButton3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().saveControl(this);
    }

    public void doActionPerformed__on__$JButton4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().validControl(this);
    }

    public void doActionPerformed__on__categoryComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().categoryChanged(this, event);
    }

    public void doActionPerformed__on__compareNumberCatchLengthButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().displayCompareNumberCatchGraph(this);
    }

    public void doActionPerformed__on__controlDataCancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().cancelDataModification(this);
    }

    public void doActionPerformed__on__controlDataDeleteButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().deleteData(this);
    }

    public void doActionPerformed__on__controlDataValidButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().validDataModification(this);
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getControl().setComment(controlComment.getText());
    }

    public void doMouseClicked__on__controlDataTableCatch(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showDataTableContextMenu(this, event);
    }

    public void doMouseClicked__on__controlDataTableHaul(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showDataTableContextMenu(this, event);
    }

    public void doMouseClicked__on__controlDataTableLength(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showDataTableContextMenu(this, event);
    }

    public void doMouseClicked__on__controlDataTableStrata(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showDataTableContextMenu(this, event);
    }

    public void doMouseClicked__on__globalControlErrorTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().globalErrorTableMouseClicked(this, event);
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getControl().setComment(controlComment.getText());
    }

    public void doValueChanged__on__controlDataTableSelectionModelCatch(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().controlDataTableSelectionChanged(this);
    }

    public void doValueChanged__on__controlDataTableSelectionModelHaul(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().controlDataTableSelectionChanged(this);
    }

    public void doValueChanged__on__controlDataTableSelectionModelLength(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().controlDataTableSelectionChanged(this);
    }

    public void doValueChanged__on__controlDataTableSelectionModelStrata(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().controlDataTableSelectionChanged(this);
    }

    public void doValueChanged__on__globalControlErrorSelectionModel(TreeSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showSelectedError(this, event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Catch getBeanCatch() {
        return beanCatch;
    }

    public Haul getBeanHaul() {
        return beanHaul;
    }

    public Length getBeanLength() {
        return beanLength;
    }

    public Strata getBeanStrata() {
        return beanStrata;
    }

    public Boolean getCanValidControl() {
        return canValidControl;
    }

    public JComboBox getCategoryComboBox() {
        return categoryComboBox;
    }

    public ControlCategoryListModel getCategoryComboBoxModel() {
        return categoryComboBoxModel;
    }

    public CoserProgressBar getCheckProgressBar() {
        return checkProgressBar;
    }

    public JButton getCompareNumberCatchLengthButton() {
        return compareNumberCatchLengthButton;
    }

    public Control getControl() {
        return control;
    }

    public JTextArea getControlComment() {
        return controlComment;
    }

    public JButton getControlDataCancelButton() {
        return controlDataCancelButton;
    }

    public JButton getControlDataDeleteButton() {
        return controlDataDeleteButton;
    }

    public JTable getControlDataTableCatch() {
        return controlDataTableCatch;
    }

    public JTable getControlDataTableHaul() {
        return controlDataTableHaul;
    }

    public JTable getControlDataTableLength() {
        return controlDataTableLength;
    }

    public ListSelectionModel getControlDataTableSelectionModelCatch() {
        return controlDataTableSelectionModelCatch;
    }

    public ListSelectionModel getControlDataTableSelectionModelHaul() {
        return controlDataTableSelectionModelHaul;
    }

    public ListSelectionModel getControlDataTableSelectionModelLength() {
        return controlDataTableSelectionModelLength;
    }

    public ListSelectionModel getControlDataTableSelectionModelStrata() {
        return controlDataTableSelectionModelStrata;
    }

    public JTable getControlDataTableStrata() {
        return controlDataTableStrata;
    }

    public JButton getControlDataValidButton() {
        return controlDataValidButton;
    }

    public CardLayout getControlTablesLayout() {
        return controlTablesLayout;
    }

    public JPanel getControlTablesPanel() {
        return controlTablesPanel;
    }

    public JPanel getEditionPanel() {
        return editionPanel;
    }

    public JScrollPane getEditionScrollPane() {
        return editionScrollPane;
    }

    public SwingValidatorMessageTableModel getErrorsTableModel() {
        return errorsTableModel;
    }

    public GlobalControlErrorModel getGlobalControlErrorModel() {
        return globalControlErrorModel;
    }

    public TreeSelectionModel getGlobalControlErrorSelectionModel() {
        return globalControlErrorSelectionModel;
    }

    public JXTreeTable getGlobalControlErrorTable() {
        return globalControlErrorTable;
    }

    public ControlHandler getHandler() {
        return handler;
    }

    public JLabel getLocalControlUsedLabel() {
        return localControlUsedLabel;
    }

    public JTable getValidationMessagesTable() {
        return validationMessagesTable;
    }

    public SwingValidator<Catch> getValidatorCatch() {
        return validatorCatch;
    }

    public SwingValidator<Haul> getValidatorHaul() {
        return validatorHaul;
    }

    public SwingValidator<Length> getValidatorLength() {
        return validatorLength;
    }

    public SwingValidator<Strata> getValidatorStrata() {
        return validatorStrata;
    }

    public Boolean isCanValidControl() {
        return canValidControl !=null && canValidControl;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void setBeanCatch(Catch beanCatch) {
        Catch oldValue = this.beanCatch;
        this.beanCatch = beanCatch;
        firePropertyChange(PROPERTY_BEAN_CATCH, oldValue, beanCatch);
    }

    public void setBeanHaul(Haul beanHaul) {
        Haul oldValue = this.beanHaul;
        this.beanHaul = beanHaul;
        firePropertyChange(PROPERTY_BEAN_HAUL, oldValue, beanHaul);
    }

    public void setBeanLength(Length beanLength) {
        Length oldValue = this.beanLength;
        this.beanLength = beanLength;
        firePropertyChange(PROPERTY_BEAN_LENGTH, oldValue, beanLength);
    }

    public void setBeanStrata(Strata beanStrata) {
        Strata oldValue = this.beanStrata;
        this.beanStrata = beanStrata;
        firePropertyChange(PROPERTY_BEAN_STRATA, oldValue, beanStrata);
    }

    public void setCanValidControl(Boolean canValidControl) {
        Boolean oldValue = this.canValidControl;
        this.canValidControl = canValidControl;
        firePropertyChange(PROPERTY_CAN_VALID_CONTROL, oldValue, canValidControl);
    }

    public void setControl(Control control) {
        Control oldValue = this.control;
        this.control = control;
        firePropertyChange(PROPERTY_CONTROL, oldValue, control);
    }

    public void setControlDataTableSelectionModelCatch(ListSelectionModel controlDataTableSelectionModelCatch) {
        ListSelectionModel oldValue = this.controlDataTableSelectionModelCatch;
        this.controlDataTableSelectionModelCatch = controlDataTableSelectionModelCatch;
        firePropertyChange(PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_CATCH, oldValue, controlDataTableSelectionModelCatch);
    }

    public void setControlDataTableSelectionModelHaul(ListSelectionModel controlDataTableSelectionModelHaul) {
        ListSelectionModel oldValue = this.controlDataTableSelectionModelHaul;
        this.controlDataTableSelectionModelHaul = controlDataTableSelectionModelHaul;
        firePropertyChange(PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_HAUL, oldValue, controlDataTableSelectionModelHaul);
    }

    public void setControlDataTableSelectionModelLength(ListSelectionModel controlDataTableSelectionModelLength) {
        ListSelectionModel oldValue = this.controlDataTableSelectionModelLength;
        this.controlDataTableSelectionModelLength = controlDataTableSelectionModelLength;
        firePropertyChange(PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_LENGTH, oldValue, controlDataTableSelectionModelLength);
    }

    public void setControlDataTableSelectionModelStrata(ListSelectionModel controlDataTableSelectionModelStrata) {
        ListSelectionModel oldValue = this.controlDataTableSelectionModelStrata;
        this.controlDataTableSelectionModelStrata = controlDataTableSelectionModelStrata;
        firePropertyChange(PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_STRATA, oldValue, controlDataTableSelectionModelStrata);
    }

    public void setGlobalControlErrorSelectionModel(TreeSelectionModel globalControlErrorSelectionModel) {
        TreeSelectionModel oldValue = this.globalControlErrorSelectionModel;
        this.globalControlErrorSelectionModel = globalControlErrorSelectionModel;
        firePropertyChange(PROPERTY_GLOBAL_CONTROL_ERROR_SELECTION_MODEL, oldValue, globalControlErrorSelectionModel);
    }

    public void setHandler(ControlHandler handler) {
        ControlHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Component get$Component0() {
        return $Component0;
    }

    protected Document get$Document0() {
        return $Document0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JButton get$JButton3() {
        return $JButton3;
    }

    protected JButton get$JButton4() {
        return $JButton4;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected JScrollPane get$JScrollPane4() {
        return $JScrollPane4;
    }

    protected JScrollPane get$JScrollPane5() {
        return $JScrollPane5;
    }

    protected JScrollPane get$JScrollPane6() {
        return $JScrollPane6;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected JSplitPane get$JSplitPane1() {
        return $JSplitPane1;
    }

    protected JSplitPane get$JSplitPane2() {
        return $JSplitPane2;
    }

    protected JSplitPane get$JSplitPane3() {
        return $JSplitPane3;
    }

    protected Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected Separator get$JToolBar$Separator1() {
        return $JToolBar$Separator1;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToControlTablesPanel() {
        if (!allComponentsCreated) {
            return;
        }
        controlTablesPanel.add($JScrollPane0, Category.CATCH.toString());
        controlTablesPanel.add($JScrollPane1, Category.STRATA.toString());
        controlTablesPanel.add($JScrollPane2, Category.HAUL.toString());
        controlTablesPanel.add($JScrollPane3, Category.LENGTH.toString());
    }

    protected void addChildrenToEditionScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        editionScrollPane.getViewport().add($Table1);
    }

    protected void addChildrenToValidatorCatch() {
        if (!allComponentsCreated) {
            return;
        }
        validatorCatch.setErrorTableModel(errorsTableModel);
        validatorCatch.setUiClass(TranslucentValidationUI.class);
        validatorCatch.setBean(beanCatch);
    }

    protected void addChildrenToValidatorHaul() {
        if (!allComponentsCreated) {
            return;
        }
        validatorHaul.setErrorTableModel(errorsTableModel);
        validatorHaul.setUiClass(TranslucentValidationUI.class);
        validatorHaul.setBean(beanHaul);
    }

    protected void addChildrenToValidatorLength() {
        if (!allComponentsCreated) {
            return;
        }
        validatorLength.setErrorTableModel(errorsTableModel);
        validatorLength.setUiClass(TranslucentValidationUI.class);
        validatorLength.setBean(beanLength);
    }

    protected void addChildrenToValidatorStrata() {
        if (!allComponentsCreated) {
            return;
        }
        validatorStrata.setErrorTableModel(errorsTableModel);
        validatorStrata.setUiClass(TranslucentValidationUI.class);
        validatorStrata.setBean(beanStrata);
    }

    protected void createBeanCatch() {
        $objectMap.put("beanCatch", beanCatch = null);
    }

    protected void createBeanHaul() {
        $objectMap.put("beanHaul", beanHaul = null);
    }

    protected void createBeanLength() {
        $objectMap.put("beanLength", beanLength = null);
    }

    protected void createBeanStrata() {
        $objectMap.put("beanStrata", beanStrata = null);
    }

    protected void createCanValidControl() {
        $objectMap.put("canValidControl", canValidControl = false);
    }

    protected void createCategoryComboBox() {
        $objectMap.put("categoryComboBox", categoryComboBox = new JComboBox());
        
        categoryComboBox.setName("categoryComboBox");
        categoryComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__categoryComboBox"));
    }

    protected void createCategoryComboBoxModel() {
        $objectMap.put("categoryComboBoxModel", categoryComboBoxModel = new ControlCategoryListModel());
    }

    protected void createCheckProgressBar() {
        $objectMap.put("checkProgressBar", checkProgressBar = new CoserProgressBar());
        
        checkProgressBar.setName("checkProgressBar");
        checkProgressBar.setStringPainted(true);
    }

    protected void createCompareNumberCatchLengthButton() {
        $objectMap.put("compareNumberCatchLengthButton", compareNumberCatchLengthButton = new JButton());
        
        compareNumberCatchLengthButton.setName("compareNumberCatchLengthButton");
        compareNumberCatchLengthButton.setEnabled(false);
        compareNumberCatchLengthButton.setText(t("coser.ui.graph.compareNumberCatchLength"));
        compareNumberCatchLengthButton.setToolTipText(t("coser.ui.graph.compareNumberCatchLengthTip"));
        compareNumberCatchLengthButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__compareNumberCatchLengthButton"));
    }

    protected void createControl() {
        $objectMap.put("control", control = null);
    }

    protected void createControlComment() {
        $objectMap.put("controlComment", controlComment = new JTextArea());
        
        controlComment.setName("controlComment");
        controlComment.setColumns(15);
        controlComment.setLineWrap(true);
        controlComment.setWrapStyleWord(true);
        controlComment.setRows(3);
    }

    protected void createControlDataCancelButton() {
        $objectMap.put("controlDataCancelButton", controlDataCancelButton = new JButton());
        
        controlDataCancelButton.setName("controlDataCancelButton");
        controlDataCancelButton.setEnabled(false);
        controlDataCancelButton.setText(t("coser.ui.common.cancel"));
        controlDataCancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__controlDataCancelButton"));
    }

    protected void createControlDataDeleteButton() {
        $objectMap.put("controlDataDeleteButton", controlDataDeleteButton = new JButton());
        
        controlDataDeleteButton.setName("controlDataDeleteButton");
        controlDataDeleteButton.setEnabled(false);
        controlDataDeleteButton.setText(t("coser.ui.control.deleteLine"));
        controlDataDeleteButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__controlDataDeleteButton"));
    }

    protected void createControlDataTableCatch() {
        $objectMap.put("controlDataTableCatch", controlDataTableCatch = new JTable());
        
        controlDataTableCatch.setName("controlDataTableCatch");
        controlDataTableCatch.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__controlDataTableCatch"));
    }

    protected void createControlDataTableHaul() {
        $objectMap.put("controlDataTableHaul", controlDataTableHaul = new JTable());
        
        controlDataTableHaul.setName("controlDataTableHaul");
        controlDataTableHaul.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__controlDataTableHaul"));
    }

    protected void createControlDataTableLength() {
        $objectMap.put("controlDataTableLength", controlDataTableLength = new JTable());
        
        controlDataTableLength.setName("controlDataTableLength");
        controlDataTableLength.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__controlDataTableLength"));
    }

    protected void createControlDataTableSelectionModelCatch() {
        $objectMap.put("controlDataTableSelectionModelCatch", controlDataTableSelectionModelCatch = controlDataTableCatch.getSelectionModel());
        
        controlDataTableSelectionModelCatch.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__controlDataTableSelectionModelCatch"));
    }

    protected void createControlDataTableSelectionModelHaul() {
        $objectMap.put("controlDataTableSelectionModelHaul", controlDataTableSelectionModelHaul = controlDataTableHaul.getSelectionModel());
        
        controlDataTableSelectionModelHaul.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__controlDataTableSelectionModelHaul"));
    }

    protected void createControlDataTableSelectionModelLength() {
        $objectMap.put("controlDataTableSelectionModelLength", controlDataTableSelectionModelLength = controlDataTableLength.getSelectionModel());
        
        controlDataTableSelectionModelLength.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__controlDataTableSelectionModelLength"));
    }

    protected void createControlDataTableSelectionModelStrata() {
        $objectMap.put("controlDataTableSelectionModelStrata", controlDataTableSelectionModelStrata = controlDataTableStrata.getSelectionModel());
        
        controlDataTableSelectionModelStrata.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__controlDataTableSelectionModelStrata"));
    }

    protected void createControlDataTableStrata() {
        $objectMap.put("controlDataTableStrata", controlDataTableStrata = new JTable());
        
        controlDataTableStrata.setName("controlDataTableStrata");
        controlDataTableStrata.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__controlDataTableStrata"));
    }

    protected void createControlDataValidButton() {
        $objectMap.put("controlDataValidButton", controlDataValidButton = new JButton());
        
        controlDataValidButton.setName("controlDataValidButton");
        controlDataValidButton.setEnabled(false);
        controlDataValidButton.setText(t("coser.ui.common.valid"));
        controlDataValidButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__controlDataValidButton"));
    }

    protected void createControlTablesLayout() {
        $objectMap.put("controlTablesLayout", controlTablesLayout = new CardLayout());
    }

    protected void createControlTablesPanel() {
        $objectMap.put("controlTablesPanel", controlTablesPanel = new JPanel());
        
        controlTablesPanel.setName("controlTablesPanel");
        controlTablesPanel.setLayout(controlTablesLayout);
    }

    protected void createEditionPanel() {
        $objectMap.put("editionPanel", editionPanel = new JPanel());
        
        editionPanel.setName("editionPanel");
        editionPanel.setLayout(new GridBagLayout());
    }

    protected void createEditionScrollPane() {
        $objectMap.put("editionScrollPane", editionScrollPane = new JScrollPane());
        
        editionScrollPane.setName("editionScrollPane");
    }

    protected void createErrorsTableModel() {
        $objectMap.put("errorsTableModel", errorsTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createGlobalControlErrorModel() {
        $objectMap.put("globalControlErrorModel", globalControlErrorModel = new GlobalControlErrorModel());
    }

    protected void createGlobalControlErrorSelectionModel() {
        $objectMap.put("globalControlErrorSelectionModel", globalControlErrorSelectionModel = globalControlErrorTable.getTreeSelectionModel());
        
        globalControlErrorSelectionModel.addTreeSelectionListener(JAXXUtil.getEventListener(TreeSelectionListener.class, "valueChanged", this, "doValueChanged__on__globalControlErrorSelectionModel"));
    }

    protected void createGlobalControlErrorTable() {
        $objectMap.put("globalControlErrorTable", globalControlErrorTable = new JXTreeTable());
        
        globalControlErrorTable.setName("globalControlErrorTable");
        globalControlErrorTable.setRootVisible(false);
        globalControlErrorTable.setShowsRootHandles(true);
        globalControlErrorTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__globalControlErrorTable"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createLocalControlUsedLabel() {
        $objectMap.put("localControlUsedLabel", localControlUsedLabel = new JLabel());
        
        localControlUsedLabel.setName("localControlUsedLabel");
        localControlUsedLabel.setOpaque(true);
        localControlUsedLabel.setText(t("coser.ui.control.warninguselocalcontrols"));
        localControlUsedLabel.setVisible(false);
    }

    protected void createValidationMessagesTable() {
        $objectMap.put("validationMessagesTable", validationMessagesTable = new JTable());
        
        validationMessagesTable.setName("validationMessagesTable");
        validationMessagesTable.setAutoCreateRowSorter(true);
        validationMessagesTable.setRowSelectionAllowed(true);
    }

    protected void createValidatorCatch() {
        $objectMap.put("validatorCatch", validatorCatch = SwingValidator.newValidator(Catch.class, null));
    }

    protected void createValidatorHaul() {
        $objectMap.put("validatorHaul", validatorHaul = SwingValidator.newValidator(Haul.class, null));
    }

    protected void createValidatorLength() {
        $objectMap.put("validatorLength", validatorLength = SwingValidator.newValidator(Length.class, null));
    }

    protected void createValidatorStrata() {
        $objectMap.put("validatorStrata", validatorStrata = SwingValidator.newValidator(Strata.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JSplitPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(checkProgressBar, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(localControlUsedLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JToolBar0
        $JToolBar0.add($JLabel0);
        $JToolBar0.add(categoryComboBox);
        $JToolBar0.add($JToolBar$Separator0);
        $JToolBar0.add($JButton0);
        $JToolBar0.add(compareNumberCatchLengthButton);
        $JToolBar0.add($JButton1);
        $JToolBar0.add($JToolBar$Separator1);
        $JToolBar0.add($JButton2);
        $JToolBar0.add($Component0);
        $JToolBar0.add($JButton3);
        $JToolBar0.add($JButton4);
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add(controlTablesPanel, JSplitPane.LEFT);
        $JSplitPane0.add($JSplitPane1, JSplitPane.RIGHT);
        addChildrenToControlTablesPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(controlDataTableCatch);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(controlDataTableStrata);
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(controlDataTableHaul);
        // inline complete setup of $JScrollPane3
        $JScrollPane3.getViewport().add(controlDataTableLength);
        // inline complete setup of $JSplitPane1
        $JSplitPane1.add($JSplitPane2, JSplitPane.LEFT);
        $JSplitPane1.add($JSplitPane3, JSplitPane.RIGHT);
        // inline complete setup of $JSplitPane2
        $JSplitPane2.add(editionScrollPane, JSplitPane.LEFT);
        $JSplitPane2.add($JScrollPane4, JSplitPane.RIGHT);
        addChildrenToEditionScrollPane();
        // inline complete setup of $Table1
        $Table1.add(controlDataValidButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(controlDataCancelButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(controlDataDeleteButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(editionPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToValidatorCatch();
        addChildrenToValidatorHaul();
        addChildrenToValidatorStrata();
        addChildrenToValidatorLength();
        // inline complete setup of $JScrollPane4
        $JScrollPane4.getViewport().add(validationMessagesTable);
        // inline complete setup of $JSplitPane3
        $JSplitPane3.add($JScrollPane5, JSplitPane.LEFT);
        $JSplitPane3.add($JPanel0, JSplitPane.RIGHT);
        // inline complete setup of $JScrollPane5
        $JScrollPane5.getViewport().add(globalControlErrorTable);
        // inline complete setup of $JPanel0
        $JPanel0.add($JLabel1, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane6, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane6
        $JScrollPane6.getViewport().add(controlComment);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 24 property setters
        categoryComboBox.setModel(categoryComboBoxModel);
        categoryComboBox.setRenderer(new fr.ifremer.coser.ui.control.ControlCategoryListRenderer());
        $JButton0.setIcon(SwingUtil.createImageIcon("spellcheck.png"));
        compareNumberCatchLengthButton.setIcon(SwingUtil.createImageIcon("chart_curve.png"));
        $JButton1.setIcon(SwingUtil.createImageIcon("chart_bar.png"));
        $JButton2.setIcon(SwingUtil.createImageIcon("report.png"));
        $JButton3.setIcon(SwingUtil.createImageIcon("disk.png"));
        $JButton4.setIcon(SwingUtil.createImageIcon("accept.png"));
        $JSplitPane0.setOrientation(JSplitPane.VERTICAL_SPLIT);
        controlDataTableCatch.setModel(new ControlDuplicatedLineTableModel(new ControlDataTableModel(this, Category.CATCH)));
        controlDataTableStrata.setModel(new ControlDuplicatedLineTableModel(new ControlDataTableModel(this, Category.STRATA)));
        controlDataTableHaul.setModel(new ControlDuplicatedLineTableModel(new ControlDataTableModel(this, Category.HAUL)));
        controlDataTableLength.setModel(new ControlDuplicatedLineTableModel(new ControlDataTableModel(this, Category.LENGTH)));
        $JSplitPane1.setOrientation(JSplitPane.VERTICAL_SPLIT);
        validationMessagesTable.setModel(errorsTableModel);
        globalControlErrorTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        globalControlErrorTable.setTreeCellRenderer(new ControlErrorTreeRenderer());
        globalControlErrorTable.setTreeTableModel(globalControlErrorModel);
        localControlUsedLabel.setBackground(new Color(255, 255, 173));
        localControlUsedLabel.setBorder(BorderFactory.createLineBorder(new Color(226, 226, 81)));
        localControlUsedLabel.setIcon(SwingUtil.createImageIcon("warning.png"));
        // late initializer
        // register 4 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createControl();
        createCanValidControl();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("coser.ui.control.categorylabel"));
        createCategoryComboBoxModel();
        createCategoryComboBox();
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("coser.ui.control.checkData"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createCompareNumberCatchLengthButton();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("coser.ui.graph.lengthStructure"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JToolBar$Separator1
        $objectMap.put("$JToolBar$Separator1", $JToolBar$Separator1 = new Separator());
        
        $JToolBar$Separator1.setName("$JToolBar$Separator1");
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(t("coser.ui.control.controlreport"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $Component0
        $objectMap.put("$Component0", $Component0 = javax.swing.Box.createHorizontalGlue());
        
        $Component0.setName("$Component0");
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setText(t("coser.ui.control.save"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setText(t("coser.ui.control.validcontrol"));
        $JButton4.setToolTipText(t("coser.ui.control.validcontroltip"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setName("splitpaneDataDetails");
        $JSplitPane0.setResizeWeight(0.3);
        createControlTablesLayout();
        createControlTablesPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createControlDataTableCatch();
        createControlDataTableSelectionModelCatch();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createControlDataTableStrata();
        createControlDataTableSelectionModelStrata();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createControlDataTableHaul();
        createControlDataTableSelectionModelHaul();
        // inline creation of $JScrollPane3
        $objectMap.put("$JScrollPane3", $JScrollPane3 = new JScrollPane());
        
        $JScrollPane3.setName("$JScrollPane3");
        createControlDataTableLength();
        createControlDataTableSelectionModelLength();
        // inline creation of $JSplitPane1
        $objectMap.put("$JSplitPane1", $JSplitPane1 = new JSplitPane());
        
        $JSplitPane1.setName("$JSplitPane1");
        $JSplitPane1.setName("splitpaneDetail");
        $JSplitPane1.setResizeWeight(0.5);
        // inline creation of $JSplitPane2
        $objectMap.put("$JSplitPane2", $JSplitPane2 = new JSplitPane());
        
        $JSplitPane2.setName("$JSplitPane2");
        $JSplitPane2.setName("splitpaneDataDetailError");
        $JSplitPane2.setResizeWeight(0.5);
        createEditionScrollPane();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createControlDataValidButton();
        createControlDataCancelButton();
        createControlDataDeleteButton();
        createEditionPanel();
        createErrorsTableModel();
        createBeanCatch();
        createBeanHaul();
        createBeanStrata();
        createBeanLength();
        createValidatorCatch();
        createValidatorHaul();
        createValidatorStrata();
        createValidatorLength();
        // inline creation of $JScrollPane4
        $objectMap.put("$JScrollPane4", $JScrollPane4 = new JScrollPane());
        
        $JScrollPane4.setName("$JScrollPane4");
        createValidationMessagesTable();
        // inline creation of $JSplitPane3
        $objectMap.put("$JSplitPane3", $JSplitPane3 = new JSplitPane());
        
        $JSplitPane3.setName("$JSplitPane3");
        $JSplitPane3.setName("splitpaneGlobalErrorComment");
        $JSplitPane3.setResizeWeight(0.5);
        // inline creation of $JScrollPane5
        $objectMap.put("$JScrollPane5", $JScrollPane5 = new JScrollPane());
        
        $JScrollPane5.setName("$JScrollPane5");
        createGlobalControlErrorModel();
        createGlobalControlErrorTable();
        createGlobalControlErrorSelectionModel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("coser.ui.control.comment"));
        // inline creation of $JScrollPane6
        $objectMap.put("$JScrollPane6", $JScrollPane6 = new JScrollPane());
        
        $JScrollPane6.setName("$JScrollPane6");
        createControlComment();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = controlComment.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        createCheckProgressBar();
        createLocalControlUsedLabel();
        // inline creation of $Table0
        setName("$Table0");
        setName("controlView");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON4_ENABLED, true ,"canValidControl") {
        
            @Override
            public void processDataBinding() {
                $JButton4.setEnabled(isCanValidControl());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CONTROL_COMMENT_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("control", this);
                if (getControl() != null) {
                    getControl().addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getControl() != null) {
                    SwingUtil.setText(controlComment, getControl().getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("control", this);
                if (getControl() != null) {
                    getControl().removePropertyChangeListener("comment", this);
                }
            }
        });
    }

}