/*
 * #%L
 * Coser :: UI
 * %%
 * Copyright (C) 2010 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.coser;

import fr.ifremer.coser.ui.CoserFrame;
import jaxx.runtime.context.DefaultApplicationContext;

import javax.swing.SwingUtilities;

/**
 * Coser main class.
 * <p/>
 * Last update : $Date$
 * By : $Author$
 *
 * @author chatellier
 * @version $Revision$
 */
public class Coser {

//    private static final Log log = LogFactory.getLog(Coser.class);

//    protected static CoserConfig coserConfig;

    /**
     * Coser main method.
     *
     * @param args main args
     */
    public static void main(String... args) {

//        // init config
//        coserConfig = new CoserConfig();
//        try {
//            coserConfig.parse(args);
//        } catch (ArgumentsParserException ex) {
//            if (log.isErrorEnabled()) {
//                log.error("Cant' parse configuration", ex);
//            }
//        }
//
//        // OpenMap sysout
//        MapBean.suppressCopyright = true;
//
//        // catch wall application exception
//        launch(context);
//
//        // catch uncaught exceptions
//        Thread.setDefaultUncaughtExceptionHandler(new CoserExceptionHandler());
//        System.setProperty("sun.awt.exception.handler", CoserExceptionHandler.class.getName());

        // launch UI
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {

                CoserUIApplicationContext applicationContext = CoserUIApplicationContext.init();

                // define unique context global values
                DefaultApplicationContext context = new DefaultApplicationContext();
                context.setContextValue(applicationContext);
                //FIXME Remove this and use directly the application context
                context.setContextValue(applicationContext.getConfig());
                //FIXME Remove this and use directly the application context
                context.setContextValue(applicationContext.getSession());
                //FIXME Remove this and use directly the application context
                context.setContextValue(applicationContext.getProjectService());
                //FIXME Remove this and use directly the application context
                context.setContextValue(applicationContext.getCommandService());
                //FIXME Remove this and use directly the application context
                context.setContextValue(applicationContext.getControlService());
                //FIXME Remove this and use directly the application context
                context.setContextValue(applicationContext.getPublicationService());
                //FIXME Remove this and use directly the application context
                context.setContextValue(applicationContext.getClientResultService());

                // init frame with session reloading
                CoserFrame frame = new CoserFrame(context);
                frame.setLocationRelativeTo(null);
                applicationContext.getSession().add(frame);

                frame.setVisible(true);
            }
        });
    }
//    /**
//     * Display main UI.
//     *
//     * @param coserConfig coser configuration
//     */
//    public static void launch(final CoserConfig coserConfig) {
//
//        // to work in java webstart
//        try {
//            I18n.init(new DefaultI18nInitializer("coser-i18n"), coserConfig.getLocale());
//        } catch (RuntimeException ex) {
//            if (log.isErrorEnabled()) {
//                log.error("Could not load coser i18n bundle", ex);
//            }
//            // fallback for dev mode
//            I18n.init(new ClassPathI18nInitializer(), coserConfig.getLocale());
//        }
//
//        // launch UI
//        SwingUtilities.invokeLater(new Runnable() {
//            @Override
//            public void run() {
//
//                CoserConfig coserConfig = applicationContext.getConfig();
//
//                // ne to be done in Swing EDT (otherwize, don't work on javawebstart)
//                // declare new classloader
//                ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
//                CoserClassLoader coserClassLoader = new CoserClassLoader(currentClassLoader);
//                Thread.currentThread().setContextClassLoader(coserClassLoader);
//                // set coser xwork validation file directory in classloader
//                coserClassLoader.setValidatorsDirectory(coserConfig.getValidatorsDirectory());
//
//                // init LAF (from configuration)
//                try {
//                    String lafClassName = coserConfig.getLookAndFeel();
//                    for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
//                        if (laf.getClassName().equalsIgnoreCase(lafClassName)) {
//                            UIManager.setLookAndFeel(laf.getClassName());
//                        }
//                    }
//                } catch (Exception ex) {
//                    if (log.isErrorEnabled()) {
//                        log.error("Can't init look and feel", ex);
//                    }
//                }
//
//                // update font size (after laf)
//                coserConfig.updateSwingFont();
//
//                File coserConfigDirectory = new File(coserConfig.getUserConfigDirectory(), "coser");
//                try {
//                    FileUtils.forceMkdir(coserConfigDirectory);
//                } catch (IOException e) {
//                    throw new CoserTechnicalException("Could not create user data directory", e);
//                }
//                File mainFrameFile = new File(coserConfigDirectory, "session.xml");
//                SwingSession session = new SwingSession(mainFrameFile, true);
//
//                // define unique context global values
//                DefaultApplicationContext context = new DefaultApplicationContext();
//                context.setContextValue(coserConfig);
//                context.setContextValue(session);
//                context.setContextValue(new ProjectService(coserConfig));
//                context.setContextValue(new CommandService(coserConfig));
//                context.setContextValue(new ControlService(coserConfig));
//                context.setContextValue(new PublicationService(coserConfig));
////                context.setContextValue(new WebService(coserConfig));
//                context.setContextValue(new ClientResultService(coserConfig));
//                context.setContextValue(new DefaultCoserApplicationContext(coserConfig));
//
//                // init frame with session reloading
//                CoserFrame frame = new CoserFrame(context);
//                frame.setLocationRelativeTo(null);
//                session.add(frame);
//
//                frame.setVisible(true);
//            }
//        });
//    }
}
