/*
 * #%L
 * Coser :: UI
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.coser.ui.selection;

import fr.ifremer.coser.bean.Selection;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SelectionView extends JTabbedPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CREATION_STATE = "creationState";
    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTION = "selection";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SELECTION_DETAILS_TAB_CREATION_STATE = "selectionDetailsTab.creationState";
    public static final String BINDING_SELECTION_DETAILS_TAB_HANDLER = "selectionDetailsTab.handler";
    public static final String BINDING_SELECTION_DETAILS_TAB_SELECTION = "selectionDetailsTab.selection";
    public static final String BINDING_SELECTION_LISTS_VIEW_HANDLER = "selectionListsView.handler";
    public static final String BINDING_SELECTION_LISTS_VIEW_SELECTION = "selectionListsView.selection";
    public static final String BINDING_SELECTION_RESULT_VIEW_HANDLER = "selectionResultView.handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUO28TQRAeG+zghPBIRJRAEAFSgbROIgqk8AgkipLIPBQjhHDD2reONzrfLbtz5GgQP4GfAD0NEh0VoqCmoEH8BYQoaBGzZ99djI9glCv2TjPzffvN3My8/gYFo+HsNg9DpgMPZVuwjRsPHtypb4sGrgjT0FKhr6Hz5PKQr8GIk9gNwvlaxcLLXXh52W8r3xPeLvRiBYYNPnWFaQmBCKd7EQ1jytXEvRiqQMesiags1pc/vudfOM9f5QFCReqGKZWZf6HSTA5WIC8dhDG66Qkvu9zbIhlaelukd9Tall1uzG3eFo/hGQxVoKi4JjKEc4OnHHFE+FAhjM5u3OP1unDuck/MIVxsaiabWrSFZg3f0BlIZoRLxZe+x6rx130pdpSKeIoIpSQC4UwfQ13wXcgUNdrQgltTFTkKhOM2RWbTZjd93yVUGjvU4p7jCo3ABlS41gGkFONJ0IpALl1DiSMsDEjXxdi8LV8poR1LgivSYBSAMDcgawLp5UylbgoTuPh/pJsmaMp+0tIsJbzuNX36zSd7utLsUI+xrlf1A+atYSbDsRA7NJzqYaQJYukEpS2eq0FBB2RGmKz1D90muTrjNvnHuFnCyPtrYvzzu69vV+MZK9LdJzJDd60I6n2lfUXtI+3VRzsDFqB0y7e4WqzFDRztj+kMYdWum8TRfZ1GtXC2xk2LKApDX95/mHj06QDkV2HY9bmzym38OpSwpakKvuuE6vpSpOjwziE6j1lt/UNw5IrDkc/UpefQT7kWUi2mM2qRCKqXPv4cr75ZiuuRI31Tfw1Pa1J4CEXpudIT0dbpLpTMLTOijAgcP10cWaskZ98TqtskF6KTZSUcT7INmA8D+1qIdNuvSwPTpCtnX0TWfHkPhqmBGK7um2EvDdPE8Bvz8I9bGQcAAA==";
    private static final Log log = LogFactory.getLog(SelectionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean creationState;
    protected SelectionHandler handler;
    protected Selection selection;
    protected SelectionDetailsView selectionDetailsTab;
    protected SelectionListsView selectionListsView;
    protected SelectionRsufiView selectionResultView;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SelectionView $JTabbedPane0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
                addChangeListener(new ChangeListener() {
                    public void stateChanged(ChangeEvent event) {
                        if (getHandler() != null) {
                            getHandler().selectionTabChanged(SelectionView.this, event);
                        }
                    }
                });
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectionView() {
        $initialize();
    }

    public SelectionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionView(int param0) {
        super(param0);
        $initialize();
    }

    public SelectionView(JAXXContext parentContext, int param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionView(int param0, int param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionView(JAXXContext parentContext, int param1, int param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getCreationState() {
        return creationState;
    }

    public SelectionHandler getHandler() {
        return handler;
    }

    public Selection getSelection() {
        return selection;
    }

    public SelectionDetailsView getSelectionDetailsTab() {
        return selectionDetailsTab;
    }

    public SelectionListsView getSelectionListsView() {
        return selectionListsView;
    }

    public SelectionRsufiView getSelectionResultView() {
        return selectionResultView;
    }

    public Boolean isCreationState() {
        return creationState !=null && creationState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCreationState(Boolean creationState) {
        Boolean oldValue = this.creationState;
        this.creationState = creationState;
        firePropertyChange(PROPERTY_CREATION_STATE, oldValue, creationState);
    }

    public void setHandler(SelectionHandler handler) {
        SelectionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelection(Selection selection) {
        Selection oldValue = this.selection;
        this.selection = selection;
        firePropertyChange(PROPERTY_SELECTION, oldValue, selection);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createCreationState() {
        $objectMap.put("creationState", creationState = false);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createSelection() {
        $objectMap.put("selection", selection = null);
    }

    protected void createSelectionDetailsTab() {
        $objectMap.put("selectionDetailsTab", selectionDetailsTab = new SelectionDetailsView(this));
        
        selectionDetailsTab.setName("selectionDetailsTab");
    }

    protected void createSelectionListsView() {
        $objectMap.put("selectionListsView", selectionListsView = new SelectionListsView(this));
        
        selectionListsView.setName("selectionListsView");
    }

    protected void createSelectionResultView() {
        $objectMap.put("selectionResultView", selectionResultView = new SelectionRsufiView(this));
        
        selectionResultView.setName("selectionResultView");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JTabbedPane0
        add(selectionDetailsTab);
        add(selectionListsView);
        add(selectionResultView);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 0));
        $JTabbedPane0.setTitleAt(0, _("coser.ui.selection.tab.details"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 1));
        $JTabbedPane0.setTitleAt(1, _("coser.ui.selection.tab.lists"));
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 2));
        $JTabbedPane0.setTitleAt(2, _("coser.ui.selection.tab.rsufi"));
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JTabbedPane0", $JTabbedPane0);
        createSelection();
        createCreationState();
        createHandler();
        createSelectionDetailsTab();
        createSelectionListsView();
        createSelectionResultView();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("coser.ui.selection.tab.details"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_("coser.ui.selection.tab.lists"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(_("coser.ui.selection.tab.rsufi"));
        // inline creation of $JTabbedPane0
        setName("$JTabbedPane0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTION_DETAILS_TAB_CREATION_STATE, true ,"creationState") {
        
            @Override
            public void processDataBinding() {
                selectionDetailsTab.setCreationState(isCreationState());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTION_DETAILS_TAB_HANDLER, true ,"handler") {
        
            @Override
            public void processDataBinding() {
                selectionDetailsTab.setHandler(getHandler());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTION_DETAILS_TAB_SELECTION, true ,"selection") {
        
            @Override
            public void processDataBinding() {
                selectionDetailsTab.setSelection(getSelection());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTION_LISTS_VIEW_HANDLER, true ,"handler") {
        
            @Override
            public void processDataBinding() {
                selectionListsView.setHandler(getHandler());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTION_LISTS_VIEW_SELECTION, true ,"selection") {
        
            @Override
            public void processDataBinding() {
                selectionListsView.setSelection(getSelection());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTION_RESULT_VIEW_HANDLER, true ,"handler") {
        
            @Override
            public void processDataBinding() {
                selectionResultView.setHandler(getHandler());
            }
        });
    }

}