/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.control;

import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.control.ControlError;
import fr.ifremer.coser.ui.control.ControlTableModel;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ControlDuplicatedLineTableModel
extends ControlTableModel {
    private static final long serialVersionUID = 8138379018849263395L;
    private static final Log log = LogFactory.getLog(ControlDuplicatedLineTableModel.class);
    protected ControlTableModel dataTableModel;
    protected List<ControlError> controlErrors;
    protected int[] linesIndex = null;
    protected int[] reverseLinesIndex = null;

    @Override
    public CoserConstants.Category getCategory() {
        return this.dataTableModel.getCategory();
    }

    public ControlDuplicatedLineTableModel(ControlTableModel dataTableModel) {
        this.dataTableModel = dataTableModel;
    }

    public void setControlErrors(List<ControlError> controlErrors) {
        this.controlErrors = controlErrors;
        this.computeLineIndices();
        this.fireTableDataChanged();
    }

    protected void computeLineIndices() {
        long timeBefore = System.currentTimeMillis();
        int dataCount = this.getRowCount();
        List<ControlError> localControlErrors = this.getCurrentModelErrors();
        this.linesIndex = new int[dataCount];
        int i = 0;
        int j = 0;
        HashSet<Integer> alreadyDone = new HashSet<Integer>();
        Iterator<ControlError> itControlErrors = localControlErrors.iterator();
        int nextErrorFirstLine = -1;
        ControlError controlError = null;
        if (itControlErrors.hasNext()) {
            controlError = itControlErrors.next();
            nextErrorFirstLine = this.dataTableModel.getRealIndexOfLine((String)controlError.getLineNumbers().get(0));
        }
        while (i < dataCount) {
            while (alreadyDone.contains(j)) {
                ++j;
            }
            this.linesIndex[i++] = j;
            if (j == nextErrorFirstLine) {
                for (int errorIndex = 1; errorIndex < controlError.getLineNumbers().size(); ++errorIndex) {
                    int delegateIndex = this.dataTableModel.getRealIndexOfLine((String)controlError.getLineNumbers().get(errorIndex));
                    this.linesIndex[i++] = delegateIndex;
                    alreadyDone.add(delegateIndex);
                }
                itControlErrors.remove();
                if (itControlErrors.hasNext()) {
                    controlError = itControlErrors.next();
                    nextErrorFirstLine = this.dataTableModel.getRealIndexOfLine((String)controlError.getLineNumbers().get(0));
                }
            }
            ++j;
        }
        this.reverseLinesIndex = new int[dataCount];
        for (int reversei = 0; reversei < dataCount; ++reversei) {
            this.reverseLinesIndex[this.linesIndex[reversei]] = reversei;
        }
        if (log.isDebugEnabled()) {
            long timeAfter = System.currentTimeMillis();
            log.debug((Object)("Build new order array took " + (timeAfter - timeBefore) + " ms"));
        }
    }

    protected List<ControlError> getCurrentModelErrors() {
        CoserConstants.Category category = this.getCategory();
        LinkedList<ControlError> resultControlErrors = new LinkedList<ControlError>();
        for (ControlError controlError : this.controlErrors) {
            if (CollectionUtils.size((Object)controlError.getLineNumbers()) < 2 || !category.equals((Object)controlError.getCategory())) continue;
            resultControlErrors.add(controlError);
        }
        return resultControlErrors;
    }

    @Override
    public int getRowCount() {
        return this.dataTableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.dataTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.dataTableModel.getColumnName(column);
    }

    protected int getModifiedRowIndex(int rowIndex) {
        int dupliRowIndex = rowIndex;
        if (this.linesIndex != null) {
            dupliRowIndex = this.linesIndex[rowIndex];
        }
        return dupliRowIndex;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.dataTableModel.getValueAt(this.getModifiedRowIndex(rowIndex), columnIndex);
    }

    @Override
    public String[] getDataAt(int rowIndex) {
        return this.dataTableModel.getDataAt(this.getModifiedRowIndex(rowIndex));
    }

    @Override
    public int getRealIndexOfLine(String lineNumber) {
        int rowIndex = this.dataTableModel.getRealIndexOfLine(lineNumber);
        if (rowIndex >= 0 && this.reverseLinesIndex != null) {
            rowIndex = this.reverseLinesIndex[rowIndex];
        }
        return rowIndex;
    }

    protected void deleteLine(int lineIndex) {
        int dataCount = this.getRowCount();
        int currentVal = this.linesIndex[lineIndex];
        for (int bIndex = 0; bIndex < lineIndex; ++bIndex) {
            if (this.linesIndex[bIndex] <= currentVal) continue;
            this.linesIndex[bIndex] = this.linesIndex[bIndex] - 1;
        }
        for (int aIndex = lineIndex + 1; aIndex <= dataCount; ++aIndex) {
            this.linesIndex[aIndex - 1] = this.linesIndex[aIndex] > currentVal ? this.linesIndex[aIndex] - 1 : this.linesIndex[aIndex];
        }
        for (int reversei = 0; reversei < dataCount; ++reversei) {
            this.reverseLinesIndex[this.linesIndex[reversei]] = reversei;
        }
    }

    @Override
    public int findColumn(String columnName) {
        return this.dataTableModel.findColumn(columnName);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.dataTableModel.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.dataTableModel.isCellEditable(this.getModifiedRowIndex(rowIndex), columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.dataTableModel.setValueAt(aValue, this.getModifiedRowIndex(rowIndex), columnIndex);
    }

    @Override
    public void fireTableDataChanged() {
        this.dataTableModel.fireTableDataChanged();
    }

    @Override
    public void fireTableStructureChanged() {
        this.dataTableModel.fireTableStructureChanged();
    }

    @Override
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.dataTableModel.fireTableRowsUpdated(firstRow, lastRow);
    }

    @Override
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.dataTableModel.fireTableRowsUpdated(firstRow, lastRow);
    }

    @Override
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.dataTableModel.fireTableRowsDeleted(firstRow, lastRow);
        for (int lineIndex = firstRow; lineIndex <= lastRow; ++lineIndex) {
            this.deleteLine(lineIndex);
        }
    }

    @Override
    public void fireTableCellUpdated(int row, int column) {
        this.dataTableModel.fireTableCellUpdated(row, column);
    }

    @Override
    public void fireTableChanged(TableModelEvent e) {
        this.dataTableModel.fireTableChanged(e);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.dataTableModel.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.dataTableModel.removeTableModelListener(l);
    }

    @Override
    public TableModelListener[] getTableModelListeners() {
        return this.dataTableModel.getTableModelListeners();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.dataTableModel.getListeners(listenerType);
    }
}

