/*
 * #%L
 * Coser :: UI
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.coser.ui.selection;

import fr.ifremer.coser.ui.selection.*;
import fr.ifremer.coser.ui.selection.model.*;
import fr.ifremer.coser.ui.util.*;
import fr.ifremer.coser.ui.widgets.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class SelectionDetailsView extends jaxx.runtime.swing.Table implements JAXXObject, jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CREATION_STATE = "creationState";
    public static final String PROPERTY_FILTERED_SPECIES_LIST_SELECTION_MODEL = "filteredSpeciesListSelectionModel";
    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_SPECIES_LIST_SELECTION_MODEL = "selectedSpeciesListSelectionModel";
    public static final String PROPERTY_SELECTION = "selection";
    public static final String PROPERTY_SPECIES_VALIDATED = "speciesValidated";
    public static final String PROPERTY_STRATA_MAP_TOOL_BAR = "strataMapToolBar";
    public static final String PROPERTY_STRATA_VALIDATED = "strataValidated";
    public static final String PROPERTY_YEARS_LIST_SELECTION_MODEL = "yearsListSelectionModel";
    public static final String PROPERTY_YEARS_VALIDATED = "yearsValidated";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DETAILS_DESCRIPTION_TEXT = "detailsDescription.text";
    public static final String BINDING_DETAILS_SELECTION_NAME_FIELD_ENABLED = "detailsSelectionNameField.enabled";
    public static final String BINDING_DETAILS_SELECTION_NAME_FIELD_TEXT = "detailsSelectionNameField.text";
    public static final String BINDING_FILTERED_SPECIES_LIST_ENABLED = "filteredSpeciesList.enabled";
    public static final String BINDING_FILTERED_SPECIES_LIST_SELECTION_MODEL = "filteredSpeciesList.selectionModel";
    public static final String BINDING_SELECTED_SPECIES_LIST_ENABLED = "selectedSpeciesList.enabled";
    public static final String BINDING_SELECTED_SPECIES_LIST_SELECTION_MODEL = "selectedSpeciesList.selectionModel";
    public static final String BINDING_STRATA_LIST_SELECTION_MODEL = "strataList.selectionModel";
    public static final String BINDING_TYPE_SPECIES_LABEL_TEXT = "typeSpeciesLabel.text";
    public static final String BINDING_TYPE_SPECIES_LIST_ENABLED = "typeSpeciesList.enabled";
    public static final String BINDING_TYPE_SPECIES_LIST_SELECTION_MODEL = "typeSpeciesList.selectionModel";
    public static final String BINDING_VALID_DATES_BUTTON_ENABLED = "validDatesButton.enabled";
    public static final String BINDING_VALID_SPECIES_BUTTON_ENABLED = "validSpeciesButton.enabled";
    public static final String BINDING_VALID_STRATA_BUTTON_ENABLED = "validStrataButton.enabled";
    public static final String BINDING_YEARS_LIST_SELECTION_MODEL = "yearsList.selectionModel";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON4_ENABLED = "$JButton4.enabled";
    private static final String BINDING_$JBUTTON5_ENABLED = "$JButton5.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$DOCUMENT2 = "$Document2";
    private static final Log log = LogFactory.getLog(fr.ifremer.coser.ui.selection.SelectionDetailsView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Boolean creationState;
    protected fr.ifremer.coser.ui.widgets.AccordionPane detailAccordionPane;
    protected javax.swing.JPanel detailDecisionPanel;
    protected java.awt.CardLayout detailDecisionPanelLayout;
    protected javax.swing.JTextArea detailsComment;
    @ValidatorField( validatorId = "validatorSelection",  propertyName = "description",  editorName = "detailsDescription")
    protected javax.swing.JTextArea detailsDescription;
    @ValidatorField( validatorId = "validatorSelection",  propertyName = "name",  editorName = "detailsSelectionNameField")
    protected javax.swing.JTextField detailsSelectionNameField;
    protected jaxx.runtime.validator.swing.SwingValidatorMessageTableModel errorsTableModel;
    protected javax.swing.JLabel filteredSpeciesLabel;
    protected javax.swing.JList filteredSpeciesList;
    protected fr.ifremer.coser.ui.selection.model.SpeciesListModel filteredSpeciesListModel;
    protected javax.swing.ListSelectionModel filteredSpeciesListSelectionModel;
    protected fr.ifremer.coser.ui.selection.SelectionHandler handler;
    protected org.nuiton.math.matrix.gui.MatrixPanelEditor matrixPanelEditor;
    protected javax.swing.JButton saveSelectionButton;
    protected javax.swing.JLabel selectedSpeciesLabel;
    protected javax.swing.JList selectedSpeciesList;
    protected fr.ifremer.coser.ui.selection.model.SpeciesListModel selectedSpeciesListModel;
    protected javax.swing.ListSelectionModel selectedSpeciesListSelectionModel;
    protected fr.ifremer.coser.bean.Selection selection;
    protected javax.swing.JPanel speciesGraphPanel;
    protected java.lang.Boolean speciesValidated;
    protected javax.swing.JLabel strataLabel;
    protected javax.swing.JList strataList;
    protected fr.ifremer.coser.ui.selection.model.StrataListModel strataListModel;
    protected fr.ifremer.coser.ui.maps.CoserMap strataMap;
    protected com.bbn.openmap.gui.ToolPanel strataMapToolBar;
    protected java.lang.Boolean strataValidated;
    protected javax.swing.JLabel typeSpeciesLabel;
    protected javax.swing.JList typeSpeciesList;
    protected fr.ifremer.coser.ui.selection.model.SpeciesTypesListModel typeSpeciesModel;
    protected javax.swing.JButton validDatesButton;
    protected javax.swing.JButton validFilterButton;
    protected javax.swing.JButton validSpeciesButton;
    protected javax.swing.JButton validStrataButton;
    protected java.util.List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorSelection")
    protected jaxx.runtime.validator.swing.SwingValidator< fr.ifremer.coser.bean.Selection > validatorSelection;
    protected javax.swing.JList yearsList;
    protected fr.ifremer.coser.ui.selection.model.YearListModel yearsListModel;
    protected javax.swing.ListSelectionModel yearsListSelectionModel;
    protected java.lang.Boolean yearsValidated;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SelectionDetailsView $Table0 = this;
    private javax.swing.JToolBar $JToolBar0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JToolBar.Separator $JToolBar$Separator0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JSplitPane $JSplitPane0;
    private fr.ifremer.coser.ui.widgets.AccordionPaneSubPanel $AccordionPaneSubPanel0;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.text.Document $Document0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.text.Document $Document1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JScrollPane $JScrollPane1;
    private javax.swing.text.Document $Document2;
    private fr.ifremer.coser.ui.widgets.AccordionPaneSubPanel $AccordionPaneSubPanel1;
    private jaxx.runtime.swing.Table $Table2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JScrollPane $JScrollPane2;
    private fr.ifremer.coser.ui.widgets.AccordionPaneSubPanel $AccordionPaneSubPanel2;
    private jaxx.runtime.swing.Table $Table3;
    private javax.swing.JScrollPane $JScrollPane3;
    private javax.swing.JButton $JButton2;
    private javax.swing.JButton $JButton3;
    private fr.ifremer.coser.ui.widgets.AccordionPaneSubPanel $AccordionPaneSubPanel3;
    private jaxx.runtime.swing.Table $Table4;
    private javax.swing.JScrollPane $JScrollPane4;
    private jaxx.runtime.swing.Table $Table5;
    private javax.swing.JScrollPane $JScrollPane5;
    private jaxx.runtime.swing.Table $Table6;
    private javax.swing.JButton $JButton4;
    private javax.swing.JButton $JButton5;
    private javax.swing.JScrollPane $JScrollPane6;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JScrollPane $JScrollPane7;
    private jaxx.runtime.swing.Table $Table7;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane8;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
            
            void $afterCompleteSetup() {
                // modification (species -> selection model)
                filteredSpeciesListModel.addListDataListener((CoserListSelectionModel)filteredSpeciesList.getSelectionModel());
                selectedSpeciesListModel.addListDataListener((CoserListSelectionModel)selectedSpeciesList.getSelectionModel());
            }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectionDetailsView() {
        $initialize();
    }

    public SelectionDetailsView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        getHandler().addSelectedFilteredSpecies(this);
    }

    public void doActionPerformed__on__$JButton5(java.awt.event.ActionEvent event) {
        getHandler().removeSelectedSpecies(this);
    }

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().displayLogReport(this);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().reloadControlData(this);
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        getDetailDecisionPanelLayout().show(getDetailDecisionPanel(), "ZONEMAP");
    }

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        getDetailDecisionPanelLayout().show(getDetailDecisionPanel(), "SPECIESDATA");getHandler().showSamplingEffort(this);
    }

    public void doActionPerformed__on__saveSelectionButton(java.awt.event.ActionEvent event) {
        getHandler().saveSelection(this);
    }

    public void doActionPerformed__on__validDatesButton(java.awt.event.ActionEvent event) {
        getHandler().validSelectionYearsData(this);setYearsValidated(true);
    }

    public void doActionPerformed__on__validFilterButton(java.awt.event.ActionEvent event) {
        getHandler().updateSelectionSpecies(this);validFilterButton.setEnabled(false);
    }

    public void doActionPerformed__on__validSpeciesButton(java.awt.event.ActionEvent event) {
        getHandler().validSelectionSpeciesData(this);setSpeciesValidated(true);saveSelectionButton.setEnabled(true);
    }

    public void doActionPerformed__on__validStrataButton(java.awt.event.ActionEvent event) {
        getHandler().validSelectionStrataData(this);setStrataValidated(true);
    }

    public void doContentsChanged__on__filteredSpeciesListModel(javax.swing.event.ListDataEvent event) {
        filteredSpeciesLabel.setText(_("coser.ui.selection.details.filteredSpecies", filteredSpeciesList.getSelectedIndices().length, filteredSpeciesList.getModel().getSize()));
    }

    public void doContentsChanged__on__selectedSpeciesListModel(javax.swing.event.ListDataEvent event) {
        setSpeciesValidated(false);selectedSpeciesLabel.setText(_("coser.ui.selection.details.selectedSpecies", selectedSpeciesList.getSelectedIndices().length, selectedSpeciesList.getModel().getSize()));
    }

    public void doContentsChanged__on__strataListModel(javax.swing.event.ListDataEvent event) {
        strataLabel.setText(_("coser.ui.selection.details.strata", strataList.getSelectedIndices().length, strataList.getModel().getSize()));
    }

    public void doContentsChanged__on__typeSpeciesModel(javax.swing.event.ListDataEvent event) {
        typeSpeciesLabel.setText(_("coser.ui.selection.details.type", typeSpeciesList.getSelectedIndices().length, typeSpeciesList.getModel().getSize()));
    }

    public void doRemoveUpdate__on__$Document2(javax.swing.event.DocumentEvent event) {
        getSelection().setComment(detailsComment.getText());
    }

    public void doInsertUpdate__on__$Document1(javax.swing.event.DocumentEvent event) {
        getSelection().setDescription(detailsDescription.getText());
    }

    public void doInsertUpdate__on__$Document2(javax.swing.event.DocumentEvent event) {
        getSelection().setComment(detailsComment.getText());
    }

    public void doInsertUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        getSelection().setName(detailsSelectionNameField.getText());
    }

    public void doMouseClicked__on__filteredSpeciesList(java.awt.event.MouseEvent event) {
        getHandler().showFilteredSpeciesContextMenu(this, event);
    }

    public void doMouseClicked__on__selectedSpeciesList(java.awt.event.MouseEvent event) {
        getHandler().showSelectedSpeciesContextMenu(this, event);
    }

    public void doMouseClicked__on__strataList(java.awt.event.MouseEvent event) {
        getHandler().showStrataContextMenu(this, event);
    }

    public void doMouseClicked__on__yearsList(java.awt.event.MouseEvent event) {
        getHandler().showYearsContextMenu(this, event);
    }

    public void doRemoveUpdate__on__$Document1(javax.swing.event.DocumentEvent event) {
        getSelection().setDescription(detailsDescription.getText());
    }

    public void doRemoveUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        getSelection().setName(detailsSelectionNameField.getText());
    }

    public void doTableChanged__on__errorsTableModel(javax.swing.event.TableModelEvent event) {
        saveSelectionButton.setEnabled(getErrorsTableModel().getRowCount() == 0 && isSpeciesValidated());
    }

    public void doValueChanged__on__filteredSpeciesList(javax.swing.event.ListSelectionEvent event) {
        filteredSpeciesLabel.setText(_("coser.ui.selection.details.filteredSpecies", filteredSpeciesList.getSelectedIndices().length, filteredSpeciesList.getModel().getSize()));
    }

    public void doValueChanged__on__selectedSpeciesList(javax.swing.event.ListSelectionEvent event) {
        selectedSpeciesLabel.setText(_("coser.ui.selection.details.selectedSpecies", selectedSpeciesList.getSelectedIndices().length, selectedSpeciesList.getModel().getSize()));
    }

    public void doValueChanged__on__strataList(javax.swing.event.ListSelectionEvent event) {
        setStrataValidated(false); strataLabel.setText(_("coser.ui.selection.details.strata", strataList.getSelectedIndices().length, strataList.getModel().getSize()));
    }

    public void doValueChanged__on__typeSpeciesList(javax.swing.event.ListSelectionEvent event) {
        validFilterButton.setEnabled(true); typeSpeciesLabel.setText(_("coser.ui.selection.details.type", typeSpeciesList.getSelectedIndices().length, typeSpeciesList.getModel().getSize()));
    }

    public void doValueChanged__on__yearsList(javax.swing.event.ListSelectionEvent event) {
        setYearsValidated(false);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getCreationState() {
        return creationState;
    }

    public fr.ifremer.coser.ui.widgets.AccordionPane getDetailAccordionPane() {
        return detailAccordionPane;
    }

    public javax.swing.JPanel getDetailDecisionPanel() {
        return detailDecisionPanel;
    }

    public java.awt.CardLayout getDetailDecisionPanelLayout() {
        return detailDecisionPanelLayout;
    }

    public javax.swing.JTextArea getDetailsComment() {
        return detailsComment;
    }

    public javax.swing.JTextArea getDetailsDescription() {
        return detailsDescription;
    }

    public javax.swing.JTextField getDetailsSelectionNameField() {
        return detailsSelectionNameField;
    }

    public jaxx.runtime.validator.swing.SwingValidatorMessageTableModel getErrorsTableModel() {
        return errorsTableModel;
    }

    public javax.swing.JLabel getFilteredSpeciesLabel() {
        return filteredSpeciesLabel;
    }

    public javax.swing.JList getFilteredSpeciesList() {
        return filteredSpeciesList;
    }

    public fr.ifremer.coser.ui.selection.model.SpeciesListModel getFilteredSpeciesListModel() {
        return filteredSpeciesListModel;
    }

    public javax.swing.ListSelectionModel getFilteredSpeciesListSelectionModel() {
        return filteredSpeciesListSelectionModel;
    }

    public fr.ifremer.coser.ui.selection.SelectionHandler getHandler() {
        return handler;
    }

    public org.nuiton.math.matrix.gui.MatrixPanelEditor getMatrixPanelEditor() {
        return matrixPanelEditor;
    }

    public javax.swing.JButton getSaveSelectionButton() {
        return saveSelectionButton;
    }

    public javax.swing.JLabel getSelectedSpeciesLabel() {
        return selectedSpeciesLabel;
    }

    public javax.swing.JList getSelectedSpeciesList() {
        return selectedSpeciesList;
    }

    public fr.ifremer.coser.ui.selection.model.SpeciesListModel getSelectedSpeciesListModel() {
        return selectedSpeciesListModel;
    }

    public javax.swing.ListSelectionModel getSelectedSpeciesListSelectionModel() {
        return selectedSpeciesListSelectionModel;
    }

    public fr.ifremer.coser.bean.Selection getSelection() {
        return selection;
    }

    public javax.swing.JPanel getSpeciesGraphPanel() {
        return speciesGraphPanel;
    }

    public java.lang.Boolean getSpeciesValidated() {
        return speciesValidated;
    }

    public javax.swing.JLabel getStrataLabel() {
        return strataLabel;
    }

    public javax.swing.JList getStrataList() {
        return strataList;
    }

    public fr.ifremer.coser.ui.selection.model.StrataListModel getStrataListModel() {
        return strataListModel;
    }

    public fr.ifremer.coser.ui.maps.CoserMap getStrataMap() {
        return strataMap;
    }

    public com.bbn.openmap.gui.ToolPanel getStrataMapToolBar() {
        return strataMapToolBar;
    }

    public java.lang.Boolean getStrataValidated() {
        return strataValidated;
    }

    public javax.swing.JLabel getTypeSpeciesLabel() {
        return typeSpeciesLabel;
    }

    public javax.swing.JList getTypeSpeciesList() {
        return typeSpeciesList;
    }

    public fr.ifremer.coser.ui.selection.model.SpeciesTypesListModel getTypeSpeciesModel() {
        return typeSpeciesModel;
    }

    public javax.swing.JButton getValidDatesButton() {
        return validDatesButton;
    }

    public javax.swing.JButton getValidFilterButton() {
        return validFilterButton;
    }

    public javax.swing.JButton getValidSpeciesButton() {
        return validSpeciesButton;
    }

    public javax.swing.JButton getValidStrataButton() {
        return validStrataButton;
    }

    public jaxx.runtime.validator.swing.SwingValidator< fr.ifremer.coser.bean.Selection > getValidatorSelection() {
        return validatorSelection;
    }

    public javax.swing.JList getYearsList() {
        return yearsList;
    }

    public fr.ifremer.coser.ui.selection.model.YearListModel getYearsListModel() {
        return yearsListModel;
    }

    public javax.swing.ListSelectionModel getYearsListSelectionModel() {
        return yearsListSelectionModel;
    }

    public java.lang.Boolean getYearsValidated() {
        return yearsValidated;
    }

    public java.lang.Boolean isCreationState() {
        return creationState !=null && creationState;
    }

    public java.lang.Boolean isSpeciesValidated() {
        return speciesValidated !=null && speciesValidated;
    }

    public java.lang.Boolean isStrataValidated() {
        return strataValidated !=null && strataValidated;
    }

    public java.lang.Boolean isYearsValidated() {
        return yearsValidated !=null && yearsValidated;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document0;
        this.$Document0 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, newValue);
    }

    public void set$Document1(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document1;
        this.$Document1 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, newValue);
    }

    public void set$Document2(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document2;
        this.$Document2 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT2, oldValue, newValue);
    }

    public void setCreationState(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.creationState;
        this.creationState = newValue;
        firePropertyChange(PROPERTY_CREATION_STATE, oldValue, newValue);
    }

    public void setFilteredSpeciesListSelectionModel(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.filteredSpeciesListSelectionModel;
        this.filteredSpeciesListSelectionModel = newValue;
        firePropertyChange(PROPERTY_FILTERED_SPECIES_LIST_SELECTION_MODEL, oldValue, newValue);
    }

    public void setHandler(fr.ifremer.coser.ui.selection.SelectionHandler newValue) {
        fr.ifremer.coser.ui.selection.SelectionHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    public void setSelectedSpeciesListSelectionModel(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.selectedSpeciesListSelectionModel;
        this.selectedSpeciesListSelectionModel = newValue;
        firePropertyChange(PROPERTY_SELECTED_SPECIES_LIST_SELECTION_MODEL, oldValue, newValue);
    }

    public void setSelection(fr.ifremer.coser.bean.Selection newValue) {
        fr.ifremer.coser.bean.Selection oldValue = this.selection;
        this.selection = newValue;
        firePropertyChange(PROPERTY_SELECTION, oldValue, newValue);
    }

    public void setSpeciesValidated(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.speciesValidated;
        this.speciesValidated = newValue;
        firePropertyChange(PROPERTY_SPECIES_VALIDATED, oldValue, newValue);
    }

    public void setStrataMapToolBar(com.bbn.openmap.gui.ToolPanel newValue) {
        com.bbn.openmap.gui.ToolPanel oldValue = this.strataMapToolBar;
        this.strataMapToolBar = newValue;
        firePropertyChange(PROPERTY_STRATA_MAP_TOOL_BAR, oldValue, newValue);
    }

    public void setStrataValidated(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.strataValidated;
        this.strataValidated = newValue;
        firePropertyChange(PROPERTY_STRATA_VALIDATED, oldValue, newValue);
    }

    public void setYearsListSelectionModel(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.yearsListSelectionModel;
        this.yearsListSelectionModel = newValue;
        firePropertyChange(PROPERTY_YEARS_LIST_SELECTION_MODEL, oldValue, newValue);
    }

    public void setYearsValidated(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.yearsValidated;
        this.yearsValidated = newValue;
        firePropertyChange(PROPERTY_YEARS_VALIDATED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.installFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JToolBar.Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected fr.ifremer.coser.ui.widgets.AccordionPaneSubPanel get$AccordionPaneSubPanel0() {
        return $AccordionPaneSubPanel0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.text.Document get$Document0() {
        return $Document0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.text.Document get$Document1() {
        return $Document1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected javax.swing.text.Document get$Document2() {
        return $Document2;
    }

    protected fr.ifremer.coser.ui.widgets.AccordionPaneSubPanel get$AccordionPaneSubPanel1() {
        return $AccordionPaneSubPanel1;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected fr.ifremer.coser.ui.widgets.AccordionPaneSubPanel get$AccordionPaneSubPanel2() {
        return $AccordionPaneSubPanel2;
    }

    protected jaxx.runtime.swing.Table get$Table3() {
        return $Table3;
    }

    protected javax.swing.JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected fr.ifremer.coser.ui.widgets.AccordionPaneSubPanel get$AccordionPaneSubPanel3() {
        return $AccordionPaneSubPanel3;
    }

    protected jaxx.runtime.swing.Table get$Table4() {
        return $Table4;
    }

    protected javax.swing.JScrollPane get$JScrollPane4() {
        return $JScrollPane4;
    }

    protected jaxx.runtime.swing.Table get$Table5() {
        return $Table5;
    }

    protected javax.swing.JScrollPane get$JScrollPane5() {
        return $JScrollPane5;
    }

    protected jaxx.runtime.swing.Table get$Table6() {
        return $Table6;
    }

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    protected javax.swing.JButton get$JButton5() {
        return $JButton5;
    }

    protected javax.swing.JScrollPane get$JScrollPane6() {
        return $JScrollPane6;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JScrollPane get$JScrollPane7() {
        return $JScrollPane7;
    }

    protected jaxx.runtime.swing.Table get$Table7() {
        return $Table7;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane8() {
        return $JScrollPane8;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDetailAccordionPane() {
        if (!allComponentsCreated) {
            return;
        }
        detailAccordionPane.add($AccordionPaneSubPanel0);
        detailAccordionPane.add($AccordionPaneSubPanel1);
        detailAccordionPane.add($AccordionPaneSubPanel2);
        detailAccordionPane.add($AccordionPaneSubPanel3);
    }

    protected void addChildrenToDetailDecisionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        detailDecisionPanel.add($JScrollPane7, "SPECIESDATA");
        detailDecisionPanel.add($JPanel0, "ZONEMAP");
        detailDecisionPanel.add($JScrollPane8, "SPECIESGRAPH");
    }

    protected void addChildrenToValidatorSelection() {
        if (!allComponentsCreated) {
            return;
        }
        validatorSelection.setErrorTableModel(errorsTableModel);
        validatorSelection.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validatorSelection.setBean(selection);
    }

    protected void createCreationState() {
        $objectMap.put("creationState", creationState = false);
    }

    protected void createDetailAccordionPane() {
        $objectMap.put("detailAccordionPane", detailAccordionPane = new fr.ifremer.coser.ui.widgets.AccordionPane());
        
        detailAccordionPane.setName("detailAccordionPane");
    }

    protected void createDetailDecisionPanel() {
        $objectMap.put("detailDecisionPanel", detailDecisionPanel = new javax.swing.JPanel());
        
        detailDecisionPanel.setName("detailDecisionPanel");
        detailDecisionPanel.setLayout(detailDecisionPanelLayout);
    }

    protected void createDetailDecisionPanelLayout() {
        $objectMap.put("detailDecisionPanelLayout", detailDecisionPanelLayout = new java.awt.CardLayout());
    }

    protected void createDetailsComment() {
        $objectMap.put("detailsComment", detailsComment = new javax.swing.JTextArea());
        
        detailsComment.setName("detailsComment");
        detailsComment.setColumns(15);
        detailsComment.setLineWrap(true);
        detailsComment.setWrapStyleWord(true);
        detailsComment.setRows(3);
    }

    protected void createDetailsDescription() {
        $objectMap.put("detailsDescription", detailsDescription = new javax.swing.JTextArea());
        
        detailsDescription.setName("detailsDescription");
        detailsDescription.setColumns(15);
        detailsDescription.setLineWrap(true);
        detailsDescription.setWrapStyleWord(true);
        detailsDescription.setRows(3);
    }

    protected void createDetailsSelectionNameField() {
        $objectMap.put("detailsSelectionNameField", detailsSelectionNameField = new javax.swing.JTextField());
        
        detailsSelectionNameField.setName("detailsSelectionNameField");
        detailsSelectionNameField.setColumns(15);
    }

    protected void createErrorsTableModel() {
        $objectMap.put("errorsTableModel", errorsTableModel = new jaxx.runtime.validator.swing.SwingValidatorMessageTableModel());
        
        errorsTableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorsTableModel"));
    }

    protected void createFilteredSpeciesLabel() {
        $objectMap.put("filteredSpeciesLabel", filteredSpeciesLabel = new javax.swing.JLabel());
        
        filteredSpeciesLabel.setName("filteredSpeciesLabel");
    }

    protected void createFilteredSpeciesList() {
        $objectMap.put("filteredSpeciesList", filteredSpeciesList = new javax.swing.JList());
        
        filteredSpeciesList.setName("filteredSpeciesList");
        filteredSpeciesList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__filteredSpeciesList"));
        filteredSpeciesList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__filteredSpeciesList"));
    }

    protected void createFilteredSpeciesListModel() {
        $objectMap.put("filteredSpeciesListModel", filteredSpeciesListModel = new fr.ifremer.coser.ui.selection.model.SpeciesListModel());
        
        filteredSpeciesListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__filteredSpeciesListModel"));
    }

    protected void createFilteredSpeciesListSelectionModel() {
        $objectMap.put("filteredSpeciesListSelectionModel", filteredSpeciesListSelectionModel = filteredSpeciesList.getSelectionModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createMatrixPanelEditor() {
        $objectMap.put("matrixPanelEditor", matrixPanelEditor = new org.nuiton.math.matrix.gui.MatrixPanelEditor());
        
        matrixPanelEditor.setName("matrixPanelEditor");
    }

    protected void createSaveSelectionButton() {
        $objectMap.put("saveSelectionButton", saveSelectionButton = new javax.swing.JButton());
        
        saveSelectionButton.setName("saveSelectionButton");
        saveSelectionButton.setText(_("coser.ui.selection.details.saveSelection"));
        saveSelectionButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveSelectionButton"));
    }

    protected void createSelectedSpeciesLabel() {
        $objectMap.put("selectedSpeciesLabel", selectedSpeciesLabel = new javax.swing.JLabel());
        
        selectedSpeciesLabel.setName("selectedSpeciesLabel");
    }

    protected void createSelectedSpeciesList() {
        $objectMap.put("selectedSpeciesList", selectedSpeciesList = new javax.swing.JList());
        
        selectedSpeciesList.setName("selectedSpeciesList");
        selectedSpeciesList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__selectedSpeciesList"));
        selectedSpeciesList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectedSpeciesList"));
    }

    protected void createSelectedSpeciesListModel() {
        $objectMap.put("selectedSpeciesListModel", selectedSpeciesListModel = new fr.ifremer.coser.ui.selection.model.SpeciesListModel());
        
        selectedSpeciesListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__selectedSpeciesListModel"));
    }

    protected void createSelectedSpeciesListSelectionModel() {
        $objectMap.put("selectedSpeciesListSelectionModel", selectedSpeciesListSelectionModel = selectedSpeciesList.getSelectionModel());
    }

    protected void createSelection() {
        $objectMap.put("selection", selection = null);
    }

    protected void createSpeciesGraphPanel() {
        $objectMap.put("speciesGraphPanel", speciesGraphPanel = new javax.swing.JPanel());
        
        speciesGraphPanel.setName("speciesGraphPanel");
        speciesGraphPanel.setLayout(new GridBagLayout());
    }

    protected void createSpeciesValidated() {
        $objectMap.put("speciesValidated", speciesValidated = false);
    }

    protected void createStrataLabel() {
        $objectMap.put("strataLabel", strataLabel = new javax.swing.JLabel());
        
        strataLabel.setName("strataLabel");
    }

    protected void createStrataList() {
        $objectMap.put("strataList", strataList = new javax.swing.JList());
        
        strataList.setName("strataList");
        strataList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__strataList"));
        strataList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__strataList"));
    }

    protected void createStrataListModel() {
        $objectMap.put("strataListModel", strataListModel = new fr.ifremer.coser.ui.selection.model.StrataListModel());
        
        strataListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__strataListModel"));
    }

    protected void createStrataMap() {
        $objectMap.put("strataMap", strataMap = new fr.ifremer.coser.ui.maps.CoserMap());
        
        strataMap.setName("strataMap");
    }

    protected void createStrataMapToolBar() {
        $objectMap.put("strataMapToolBar", strataMapToolBar = new com.bbn.openmap.gui.ToolPanel());
        
        strataMapToolBar.setName("strataMapToolBar");
    }

    protected void createStrataValidated() {
        $objectMap.put("strataValidated", strataValidated = false);
    }

    protected void createTypeSpeciesLabel() {
        $objectMap.put("typeSpeciesLabel", typeSpeciesLabel = new javax.swing.JLabel());
        
        typeSpeciesLabel.setName("typeSpeciesLabel");
    }

    protected void createTypeSpeciesList() {
        $objectMap.put("typeSpeciesList", typeSpeciesList = new javax.swing.JList());
        
        typeSpeciesList.setName("typeSpeciesList");
        typeSpeciesList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__typeSpeciesList"));
    }

    protected void createTypeSpeciesModel() {
        $objectMap.put("typeSpeciesModel", typeSpeciesModel = new fr.ifremer.coser.ui.selection.model.SpeciesTypesListModel(this));
        
        typeSpeciesModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__typeSpeciesModel"));
    }

    protected void createValidDatesButton() {
        $objectMap.put("validDatesButton", validDatesButton = new javax.swing.JButton());
        
        validDatesButton.setName("validDatesButton");
        validDatesButton.setText(_("coser.ui.selection.details.validYears"));
        validDatesButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validDatesButton"));
    }

    protected void createValidFilterButton() {
        $objectMap.put("validFilterButton", validFilterButton = new javax.swing.JButton());
        
        validFilterButton.setName("validFilterButton");
        validFilterButton.setEnabled(false);
        validFilterButton.setText(_("coser.ui.selection.details.validFilter"));
        validFilterButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validFilterButton"));
    }

    protected void createValidSpeciesButton() {
        $objectMap.put("validSpeciesButton", validSpeciesButton = new javax.swing.JButton());
        
        validSpeciesButton.setName("validSpeciesButton");
        validSpeciesButton.setText(_("coser.ui.selection.details.validSpecies"));
        validSpeciesButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validSpeciesButton"));
    }

    protected void createValidStrataButton() {
        $objectMap.put("validStrataButton", validStrataButton = new javax.swing.JButton());
        
        validStrataButton.setName("validStrataButton");
        validStrataButton.setText(_("coser.ui.selection.details.validStrata"));
        validStrataButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validStrataButton"));
    }

    protected void createValidatorSelection() {
        $objectMap.put("validatorSelection", validatorSelection = SwingValidatorUtil.newValidator(fr.ifremer.coser.bean.Selection.class, null));
    }

    protected void createYearsList() {
        $objectMap.put("yearsList", yearsList = new javax.swing.JList());
        
        yearsList.setName("yearsList");
        yearsList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__yearsList"));
        yearsList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__yearsList"));
    }

    protected void createYearsListModel() {
        $objectMap.put("yearsListModel", yearsListModel = new fr.ifremer.coser.ui.selection.model.YearListModel());
    }

    protected void createYearsListSelectionModel() {
        $objectMap.put("yearsListSelectionModel", yearsListSelectionModel = yearsList.getSelectionModel());
    }

    protected void createYearsValidated() {
        $objectMap.put("yearsValidated", yearsValidated = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JSplitPane0, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToValidatorSelection();
        // inline complete setup of $JToolBar0
        $JToolBar0.add(saveSelectionButton);
        $JToolBar0.add($JButton0);
        $JToolBar0.add($JToolBar$Separator0);
        $JToolBar0.add($JButton1);
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add(detailAccordionPane, JSplitPane.LEFT);
        $JSplitPane0.add(detailDecisionPanel, JSplitPane.RIGHT);
        addChildrenToDetailAccordionPane();
        // inline complete setup of $AccordionPaneSubPanel0
        $AccordionPaneSubPanel0.add($Table1);
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(detailsSelectionNameField), new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane1, new GridBagConstraints(1, 2, 3, 1, 0.0, 1.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(detailsDescription));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(detailsComment);
        // inline complete setup of $AccordionPaneSubPanel1
        $AccordionPaneSubPanel1.add($Table2);
        // inline complete setup of $Table2
        $Table2.add($JLabel3, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(validDatesButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 15, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(yearsList);
        // inline complete setup of $AccordionPaneSubPanel2
        $AccordionPaneSubPanel2.add($Table3);
        // inline complete setup of $Table3
        $Table3.add(strataLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JScrollPane3, new GridBagConstraints(0, 1, 1, 2, 1.0, 2.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JButton2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JButton3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(validStrataButton, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 15, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane3
        $JScrollPane3.getViewport().add(strataList);
        // inline complete setup of $AccordionPaneSubPanel3
        $AccordionPaneSubPanel3.add($Table4);
        // inline complete setup of $Table4
        $Table4.add(typeSpeciesLabel, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JScrollPane4, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(validFilterButton, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 15, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($Table5, new GridBagConstraints(0, 2, 4, 1, 0.0, 3.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(validSpeciesButton, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane4
        $JScrollPane4.getViewport().add(typeSpeciesList);
        // inline complete setup of $Table5
        $Table5.add(filteredSpeciesLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(selectedSpeciesLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JScrollPane5, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($Table6, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JScrollPane6, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JLabel4, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane5
        $JScrollPane5.getViewport().add(filteredSpeciesList);
        // inline complete setup of $Table6
        $Table6.add($JButton4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JButton5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane6
        $JScrollPane6.getViewport().add(selectedSpeciesList);
        addChildrenToDetailDecisionPanel();
        // inline complete setup of $JScrollPane7
        $JScrollPane7.getViewport().add($Table7);
        // inline complete setup of $Table7
        $Table7.add($JLabel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(matrixPanelEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(strataMapToolBar, BorderLayout.NORTH);
        $JPanel0.add(strataMap, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane8
        $JScrollPane8.getViewport().add(speciesGraphPanel);
        
        // apply 17 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 20 property setters
        saveSelectionButton.setIcon(jaxx.runtime.SwingUtil.createImageIcon("disk.png"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.createImageIcon("report.png"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.createImageIcon("arrow_rotate_clockwise.png"));
        detailAccordionPane.setMinimumSize(new Dimension(100, 0));
        yearsList.setModel(yearsListModel);
        strataLabel.setText(_("coser.ui.selection.details.strata", 0, 0));
        strataList.setModel(strataListModel);
        $JButton2.setIcon(jaxx.runtime.SwingUtil.createImageIcon("map.png"));
        $JButton3.setIcon(jaxx.runtime.SwingUtil.createImageIcon("table.png"));
        typeSpeciesList.setCellRenderer(new SpeciesTypesRenderer());
        typeSpeciesList.setModel(typeSpeciesModel);
        filteredSpeciesLabel.setText(_("coser.ui.selection.details.filteredSpecies", 0, 0));
        selectedSpeciesLabel.setText(_("coser.ui.selection.details.selectedSpecies", 0, 0));
        filteredSpeciesList.setModel(filteredSpeciesListModel);
        $JButton4.setIcon(jaxx.runtime.SwingUtil.createImageIcon("arrow_right.png"));
        $JButton5.setIcon(jaxx.runtime.SwingUtil.createImageIcon("arrow_left.png"));
        selectedSpeciesList.setModel(selectedSpeciesListModel);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.initUI(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createHandler();
        createCreationState();
        createYearsValidated();
        createStrataValidated();
        createSpeciesValidated();
        createSelection();
        createErrorsTableModel();
        createValidatorSelection();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new javax.swing.JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        createSaveSelectionButton();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("coser.ui.selection.selectionreport"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new javax.swing.JToolBar.Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("coser.ui.selection.reloadcontroldata"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new javax.swing.JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        createDetailAccordionPane();
        // inline creation of $AccordionPaneSubPanel0
        $objectMap.put("$AccordionPaneSubPanel0", $AccordionPaneSubPanel0 = new fr.ifremer.coser.ui.widgets.AccordionPaneSubPanel());
        
        $AccordionPaneSubPanel0.setName("$AccordionPaneSubPanel0");
        $AccordionPaneSubPanel0.setTitle(_("coser.ui.selection.detail.mainAccordion"));
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("coser.ui.selection.details.name"));
        createDetailsSelectionNameField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = detailsSelectionNameField.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("coser.ui.selection.details.description"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createDetailsDescription();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = detailsDescription.getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("coser.ui.selection.details.comment"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createDetailsComment();
        // inline creation of $Document2
        $objectMap.put("$Document2", $Document2 = detailsComment.getDocument());
        
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document2"));
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document2"));
        // inline creation of $AccordionPaneSubPanel1
        $objectMap.put("$AccordionPaneSubPanel1", $AccordionPaneSubPanel1 = new fr.ifremer.coser.ui.widgets.AccordionPaneSubPanel());
        
        $AccordionPaneSubPanel1.setName("$AccordionPaneSubPanel1");
        $AccordionPaneSubPanel1.setTitle(_("coser.ui.selection.detail.yearAccordion"));
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("coser.ui.selection.details.years"));
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new javax.swing.JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createYearsListModel();
        createYearsList();
        createYearsListSelectionModel();
        createValidDatesButton();
        // inline creation of $AccordionPaneSubPanel2
        $objectMap.put("$AccordionPaneSubPanel2", $AccordionPaneSubPanel2 = new fr.ifremer.coser.ui.widgets.AccordionPaneSubPanel());
        
        $AccordionPaneSubPanel2.setName("$AccordionPaneSubPanel2");
        $AccordionPaneSubPanel2.setTitle(_("coser.ui.selection.detail.strataAccordion"));
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new jaxx.runtime.swing.Table());
        
        $Table3.setName("$Table3");
        createStrataLabel();
        // inline creation of $JScrollPane3
        $objectMap.put("$JScrollPane3", $JScrollPane3 = new javax.swing.JScrollPane());
        
        $JScrollPane3.setName("$JScrollPane3");
        createStrataListModel();
        createStrataList();
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setToolTipText(_("coser.ui.selection.details.showMapTip"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setToolTipText(_("coser.ui.selection.details.showSpreciesTip"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        createValidStrataButton();
        // inline creation of $AccordionPaneSubPanel3
        $objectMap.put("$AccordionPaneSubPanel3", $AccordionPaneSubPanel3 = new fr.ifremer.coser.ui.widgets.AccordionPaneSubPanel());
        
        $AccordionPaneSubPanel3.setName("$AccordionPaneSubPanel3");
        $AccordionPaneSubPanel3.setTitle(_("coser.ui.selection.detail.speciesAccordion"));
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new jaxx.runtime.swing.Table());
        
        $Table4.setName("$Table4");
        createTypeSpeciesLabel();
        // inline creation of $JScrollPane4
        $objectMap.put("$JScrollPane4", $JScrollPane4 = new javax.swing.JScrollPane());
        
        $JScrollPane4.setName("$JScrollPane4");
        createTypeSpeciesModel();
        createTypeSpeciesList();
        createValidFilterButton();
        // inline creation of $Table5
        $objectMap.put("$Table5", $Table5 = new jaxx.runtime.swing.Table());
        
        $Table5.setName("$Table5");
        createFilteredSpeciesLabel();
        createSelectedSpeciesLabel();
        // inline creation of $JScrollPane5
        $objectMap.put("$JScrollPane5", $JScrollPane5 = new javax.swing.JScrollPane());
        
        $JScrollPane5.setName("$JScrollPane5");
        createFilteredSpeciesListModel();
        createFilteredSpeciesList();
        createFilteredSpeciesListSelectionModel();
        // inline creation of $Table6
        $objectMap.put("$Table6", $Table6 = new jaxx.runtime.swing.Table());
        
        $Table6.setName("$Table6");
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new javax.swing.JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setToolTipText(_("coser.ui.selection.details.addToSelectedListTip"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JButton5
        $objectMap.put("$JButton5", $JButton5 = new javax.swing.JButton());
        
        $JButton5.setName("$JButton5");
        $JButton5.setToolTipText(_("coser.ui.selection.details.removeFromSelectedListTip"));
        $JButton5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton5"));
        // inline creation of $JScrollPane6
        $objectMap.put("$JScrollPane6", $JScrollPane6 = new javax.swing.JScrollPane());
        
        $JScrollPane6.setName("$JScrollPane6");
        createSelectedSpeciesListModel();
        createSelectedSpeciesList();
        createSelectedSpeciesListSelectionModel();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        
        $JLabel4.setName("$JLabel4");
        if ($JLabel4.getFont() != null) {
            $JLabel4.setFont($JLabel4.getFont().deriveFont($JLabel4.getFont().getStyle() | Font.ITALIC));
        }
        $JLabel4.setText(_("coser.ui.selection.details.speciescontextmenu"));
        createValidSpeciesButton();
        createDetailDecisionPanelLayout();
        createDetailDecisionPanel();
        // inline creation of $JScrollPane7
        $objectMap.put("$JScrollPane7", $JScrollPane7 = new javax.swing.JScrollPane());
        
        $JScrollPane7.setName("$JScrollPane7");
        // inline creation of $Table7
        $objectMap.put("$Table7", $Table7 = new jaxx.runtime.swing.Table());
        
        $Table7.setName("$Table7");
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("coser.ui.selection.details.speciesDataDescription"));
        createMatrixPanelEditor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createStrataMapToolBar();
        createStrataMap();
        // inline creation of $JScrollPane8
        $objectMap.put("$JScrollPane8", $JScrollPane8 = new javax.swing.JScrollPane());
        
        $JScrollPane8.setName("$JScrollPane8");
        createSpeciesGraphPanel();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 17 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 17 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DETAILS_SELECTION_NAME_FIELD_ENABLED, true ,"creationState") {
        
            @Override
            public void processDataBinding() {
                detailsSelectionNameField.setEnabled(isCreationState());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DETAILS_SELECTION_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    jaxx.runtime.SwingUtil.setText(detailsSelectionNameField, getSelection().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DETAILS_DESCRIPTION_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("description", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    jaxx.runtime.SwingUtil.setText(detailsDescription, getSelection().getDescription());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("description", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_YEARS_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (yearsList != null) {
                    yearsList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (yearsList != null) {
                    yearsList.setSelectionModel(new CoserListSelectionModel(yearsList.getSelectionModel(), yearsListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (yearsList != null) {
                    yearsList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALID_DATES_BUTTON_ENABLED, true ,"yearsValidated") {
        
            @Override
            public void processDataBinding() {
                validDatesButton.setEnabled(!isYearsValidated());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STRATA_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (strataList != null) {
                    strataList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (strataList != null) {
                    strataList.setSelectionModel(new CoserListSelectionModel(strataList.getSelectionModel(), strataListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (strataList != null) {
                    strataList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALID_STRATA_BUTTON_ENABLED, true ,"yearsValidated" ,"strataValidated") {
        
            @Override
            public void processDataBinding() {
                validStrataButton.setEnabled(isYearsValidated() && !isStrataValidated());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TYPE_SPECIES_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (typeSpeciesList != null) {
                    $bindingSources.put("typeSpeciesList.getSelectionModel()", typeSpeciesList.getSelectionModel());
                    typeSpeciesList.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    typeSpeciesList.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_TYPE_SPECIES_LABEL_TEXT));
                }
                if (typeSpeciesList != null) {
                    typeSpeciesList.addPropertyChangeListener("model", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (typeSpeciesList != null && typeSpeciesList.getModel() != null && typeSpeciesList.getSelectedIndices() != null) {
                    typeSpeciesLabel.setText(_("coser.ui.selection.details.type", typeSpeciesList.getSelectedIndices().length, typeSpeciesList.getModel().getSize()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (typeSpeciesList != null) {
                    javax.swing.ListSelectionModel $target = ((javax.swing.ListSelectionModel) $bindingSources.remove("typeSpeciesList.getSelectionModel()"));
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    typeSpeciesList.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_TYPE_SPECIES_LABEL_TEXT));
                }
                if (typeSpeciesList != null) {
                    typeSpeciesList.removePropertyChangeListener("model", this);
                }
            }
        
            public void $pr$u0(javax.swing.event.ListSelectionEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TYPE_SPECIES_LIST_ENABLED, true ,"yearsValidated" ,"strataValidated") {
        
            @Override
            public void processDataBinding() {
                typeSpeciesList.setEnabled(isYearsValidated() && isStrataValidated());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TYPE_SPECIES_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (typeSpeciesList != null) {
                    typeSpeciesList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (typeSpeciesList != null) {
                    typeSpeciesList.setSelectionModel(new CoserListSelectionModel(typeSpeciesList.getSelectionModel(), typeSpeciesModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (typeSpeciesList != null) {
                    typeSpeciesList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FILTERED_SPECIES_LIST_ENABLED, true ,"yearsValidated" ,"strataValidated") {
        
            @Override
            public void processDataBinding() {
                filteredSpeciesList.setEnabled(isYearsValidated() && isStrataValidated());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTERED_SPECIES_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (filteredSpeciesList != null) {
                    filteredSpeciesList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (filteredSpeciesList != null) {
                    filteredSpeciesList.setSelectionModel(new CoserListSelectionModel(filteredSpeciesList.getSelectionModel(), filteredSpeciesListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (filteredSpeciesList != null) {
                    filteredSpeciesList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON4_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getFilteredSpeciesList() != null) {
                    $bindingSources.put("getFilteredSpeciesList().getSelectionModel()", getFilteredSpeciesList().getSelectionModel());
                    getFilteredSpeciesList().getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    getFilteredSpeciesList().addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_$JBUTTON4_ENABLED));
                }
                addPropertyChangeListener("yearsValidated", this);
                addPropertyChangeListener("strataValidated", this);
            }
        
            @Override
            public void processDataBinding() {
                if (getFilteredSpeciesList() != null) {
                    $JButton4.setEnabled(getFilteredSpeciesList().getSelectedIndex() != -1 && isYearsValidated() && isStrataValidated());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getFilteredSpeciesList() != null) {
                    javax.swing.ListSelectionModel $target = ((javax.swing.ListSelectionModel) $bindingSources.remove("getFilteredSpeciesList().getSelectionModel()"));
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    }
                    getFilteredSpeciesList().removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_$JBUTTON4_ENABLED));
                }
                removePropertyChangeListener("yearsValidated", this);
                removePropertyChangeListener("strataValidated", this);
            }
        
            public void $pr$u1(javax.swing.event.ListSelectionEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON5_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getSelectedSpeciesList() != null) {
                    $bindingSources.put("getSelectedSpeciesList().getSelectionModel()", getSelectedSpeciesList().getSelectionModel());
                    getSelectedSpeciesList().getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u2"));
                    getSelectedSpeciesList().addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_$JBUTTON5_ENABLED));
                }
                addPropertyChangeListener("yearsValidated", this);
                addPropertyChangeListener("strataValidated", this);
            }
        
            @Override
            public void processDataBinding() {
                if (getSelectedSpeciesList() != null) {
                    $JButton5.setEnabled(getSelectedSpeciesList().getSelectedIndex() != -1 && isYearsValidated() && isStrataValidated());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getSelectedSpeciesList() != null) {
                    javax.swing.ListSelectionModel $target = ((javax.swing.ListSelectionModel) $bindingSources.remove("getSelectedSpeciesList().getSelectionModel()"));
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u2"));
                    }
                    getSelectedSpeciesList().removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_$JBUTTON5_ENABLED));
                }
                removePropertyChangeListener("yearsValidated", this);
                removePropertyChangeListener("strataValidated", this);
            }
        
            public void $pr$u2(javax.swing.event.ListSelectionEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTED_SPECIES_LIST_ENABLED, true ,"yearsValidated" ,"strataValidated") {
        
            @Override
            public void processDataBinding() {
                selectedSpeciesList.setEnabled(isYearsValidated() && isStrataValidated());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_SPECIES_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (selectedSpeciesList != null) {
                    selectedSpeciesList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (selectedSpeciesList != null) {
                    selectedSpeciesList.setSelectionModel(new CoserListSelectionModel(selectedSpeciesList.getSelectionModel(), selectedSpeciesListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (selectedSpeciesList != null) {
                    selectedSpeciesList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALID_SPECIES_BUTTON_ENABLED, true ,"yearsValidated" ,"strataValidated" ,"speciesValidated") {
        
            @Override
            public void processDataBinding() {
                validSpeciesButton.setEnabled(isYearsValidated() && isStrataValidated() && !isSpeciesValidated());
            }
        });
    }

}