/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.itextpdf.text.DocumentException;
import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.CoserUtils;
import fr.ifremer.coser.bean.IndicatorMap;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.bean.RSufiResult;
import fr.ifremer.coser.bean.RSufiResultPath;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.bean.ZoneMap;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.DataStorages;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.w3c.dom.Document;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class Reports {
    private static final Log log = LogFactory.getLog(Reports.class);
    protected Configuration freemarkerConfiguration = new Configuration();

    public Reports() {
        this.freemarkerConfiguration.setEncoding(Locale.getDefault(), "UTF-8");
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(Reports.class, "/ftl");
        this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)templateLoader);
        this.freemarkerConfiguration.setObjectWrapper((ObjectWrapper)new BeansWrapper());
    }

    public static String getDechargeFilename(Locale locale) {
        Preconditions.checkNotNull((Object)locale);
        String filename = I18n.l((Locale)locale, (String)"coser.business.dataDisclaimer.filename", (Object[])new Object[0]);
        return filename;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File generateMetaFilePDF(RSufiResultPath path, File resultDirectory, Locale locale, IndicatorMap indicatorLocalizedMap) {
        Project project = path.getProject();
        Selection selection = path.getSelection();
        RSufiResult rsufiResult = path.getRsufiResult();
        File result = null;
        HashMap refTaxSpeciesNumSys = Maps.newHashMap();
        HashMap refTaxSpeciesName = Maps.newHashMap();
        Iterator<String[]> itReftax = project.getRefTaxSpecies().iterator(true);
        while (itReftax.hasNext()) {
            String[] tuple = itReftax.next();
            String speciesCode = tuple[3];
            Integer iNumSys = Integer.valueOf(tuple[1]);
            refTaxSpeciesNumSys.put(speciesCode, iNumSys);
            String speciesSciName = StringEscapeUtils.escapeXml((String)tuple[4]);
            String speciesAuthor = StringEscapeUtils.escapeXml((String)tuple[5]);
            refTaxSpeciesName.put(speciesCode, "<span style='font-style:italic'>" + speciesSciName + "</span> " + speciesAuthor);
        }
        HashMap specyTypes = Maps.newHashMap();
        Iterator<String[]> itTypeSpecies = project.getTypeEspeces().iterator(true);
        while (itTypeSpecies.hasNext()) {
            String[] tuple = itTypeSpecies.next();
            String specyTypeCode = tuple[4];
            Integer iMinNumSys = Integer.valueOf(tuple[2]);
            Integer iMaxNumSys = Integer.valueOf(tuple[3]);
            specyTypes.put(specyTypeCode, new Integer[]{iMinNumSys, iMaxNumSys});
        }
        File estComIndFile = new File(resultDirectory, rsufiResult.getEstComIndName());
        HashMap indicatorMap = Maps.newHashMap();
        HashMap speciesMap = Maps.newHashMap();
        DataStorage dataStorage = DataStorages.load(estComIndFile, '\t');
        Iterator<String[]> estComIndIterator = dataStorage.iterator(true);
        while (estComIndIterator.hasNext()) {
            String indicatorName;
            String[] tuple = estComIndIterator.next();
            String indicatorCode = tuple[1];
            String listIdCode = tuple[2];
            String listNumber = listIdCode.substring(1);
            SortedSet indicatorList = (SortedSet)indicatorMap.get(listNumber);
            if (indicatorList == null) {
                indicatorList = Sets.newTreeSet();
                indicatorMap.put(listNumber, indicatorList);
            }
            if ((indicatorName = indicatorLocalizedMap.getIndicatorValue(locale, indicatorCode)) == null) continue;
            indicatorList.add(indicatorName);
        }
        for (String listNumber : indicatorMap.keySet()) {
            List<String> selectionSpeciesList = null;
            if ("1".equals(listNumber)) {
                selectionSpeciesList = selection.getSelectedSpecies();
            } else if ("2".equals(listNumber)) {
                selectionSpeciesList = selection.getSelectedSpeciesOccDens();
            } else if ("3".equals(listNumber)) {
                selectionSpeciesList = selection.getSelectedSpeciesSizeAllYear();
            } else if ("4".equals(listNumber)) {
                selectionSpeciesList = selection.getSelectedSpeciesMaturity();
            }
            if (selectionSpeciesList != null) {
                TreeSet speciesList = Sets.newTreeSet();
                for (String speciesCode : selectionSpeciesList) {
                    String speciesName = (String)refTaxSpeciesName.get(speciesCode);
                    Integer speciesNumSys = (Integer)refTaxSpeciesNumSys.get(speciesCode);
                    for (Map.Entry speciesTypeEntry : specyTypes.entrySet()) {
                        String speciesTypeCode = (String)speciesTypeEntry.getKey();
                        Integer[] bound = (Integer[])speciesTypeEntry.getValue();
                        if (speciesNumSys < bound[0] || speciesNumSys > bound[1]) continue;
                        speciesName = "(" + speciesTypeCode + ") " + speciesName;
                        break;
                    }
                    speciesList.add(speciesName);
                }
                speciesMap.put(listNumber, speciesList);
                continue;
            }
            if (!log.isWarnEnabled()) continue;
            log.warn((Object)("Can't get species list for list id " + listNumber));
        }
        FileOutputStream os = null;
        try {
            Template mapTemplate = this.freemarkerConfiguration.getTemplate("metainfo.ftl", locale);
            HashMap root = Maps.newHashMap();
            root.put("indicatorsMap", indicatorMap);
            root.put("speciesMap", speciesMap);
            StringWriter out = new StringWriter();
            mapTemplate.process((Object)root, (Writer)out);
            ((Writer)out).flush();
            Document document = CoserUtils.parseDocument(((Object)out).toString());
            result = File.createTempFile("coser-metainfo-", ".pdf");
            result.deleteOnExit();
            os = new FileOutputStream(result);
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocument(document, null);
            renderer.layout();
            renderer.createPDF((OutputStream)os);
            ((OutputStream)os).close();
        }
        catch (IOException ex) {
            try {
                throw new CoserTechnicalException("Can't generate meta info file", ex);
                catch (TemplateException ex2) {
                    throw new CoserTechnicalException("Can't generate meta info file", ex2);
                }
                catch (DocumentException ex3) {
                    throw new CoserTechnicalException("Can't generate meta info file", ex3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateDechargePDF(File disclamerPdf, Locale locale, Date updateDate, String surveyName) {
        Preconditions.checkNotNull((Object)disclamerPdf);
        Preconditions.checkNotNull((Object)locale);
        Preconditions.checkNotNull((Object)updateDate);
        FileOutputStream os = null;
        try {
            Template mapTemplate = this.freemarkerConfiguration.getTemplate("decharge.ftl", locale);
            HashMap root = Maps.newHashMap();
            root.put("updateDate", updateDate);
            root.put("surveyName", surveyName == null ? "" : surveyName);
            StringWriter out = new StringWriter();
            mapTemplate.process((Object)root, (Writer)out);
            ((Writer)out).flush();
            Document document = CoserUtils.parseDocument(((Object)out).toString());
            os = new FileOutputStream(disclamerPdf);
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocument(document, null);
            renderer.layout();
            renderer.createPDF((OutputStream)os);
            ((OutputStream)os).close();
        }
        catch (IOException ex) {
            try {
                throw new CoserTechnicalException("Can't generate decharge file", ex);
                catch (TemplateException ex2) {
                    throw new CoserTechnicalException("Can't generate decharge file", ex2);
                }
                catch (DocumentException ex3) {
                    throw new CoserTechnicalException("Can't generate decharge file", ex3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateExtractPDF(File directory, List<String> zones, MultiKeyMap<String, File> pdfMaps, MultiKeyMap<String, Pair<File, String>> pdfCharts, ZoneMap zoneMap, Locale locale) {
        Iterator<String> i$ = zones.iterator();
        block5: while (i$.hasNext()) {
            String zone = i$.next();
            ArrayList toDelete = Lists.newArrayList();
            FileOutputStream os = null;
            try {
                String zoneId;
                StringBuilder htmlContent = new StringBuilder();
                htmlContent.append("<html><head>");
                htmlContent.append("<title>").append(I18n.l((Locale)locale, (String)"coser.business.extract.extracttitle", (Object[])new Object[0])).append("</title>");
                htmlContent.append("<meta http-equiv='Content-Type' content='text/html; charset=utf-8' />");
                htmlContent.append("</head><body>");
                if (MapUtils.isNotEmpty(pdfMaps)) {
                    for (Map.Entry mapEntry : pdfMaps.entrySet()) {
                        zoneId = (String)((MultiKey)mapEntry.getKey()).getKey(0);
                        if (!zoneId.equals(zone)) continue;
                        String speciesName = (String)((MultiKey)mapEntry.getKey()).getKey(1);
                        File file = (File)mapEntry.getValue();
                        String zoneName = zoneMap.getZoneFullName(zoneId);
                        htmlContent.append("<div style='page-break-after: always'>");
                        htmlContent.append("<p>").append(zoneName).append(" - ").append(speciesName).append("</p>");
                        htmlContent.append("<img src='file://").append(file.getAbsolutePath()).append("' />");
                        htmlContent.append("</div>");
                    }
                }
                if (MapUtils.isNotEmpty(pdfCharts)) {
                    for (Map.Entry chartFileAndData : pdfCharts.entrySet()) {
                        zoneId = (String)((MultiKey)chartFileAndData.getKey()).getKey(0);
                        if (!zoneId.equals(zone)) continue;
                        File chartFile = (File)((Pair)chartFileAndData.getValue()).getLeft();
                        String content = (String)((Pair)chartFileAndData.getValue()).getRight();
                        htmlContent.append("<div style='page-break-after: always'>");
                        htmlContent.append("<img src='file://");
                        htmlContent.append(chartFile.getAbsolutePath());
                        htmlContent.append("' />");
                        htmlContent.append("<br />");
                        htmlContent.append(I18n.l((Locale)locale, (String)"coser.business.extract.extractdata", (Object[])new Object[0])).append(" :");
                        htmlContent.append("<pre>").append(content).append("</pre>");
                        htmlContent.append("</div>");
                        toDelete.add(chartFile);
                    }
                }
                htmlContent.append("</body></html>");
                String content = htmlContent.toString();
                content = content.replaceAll("&", "&amp;");
                Document document = CoserUtils.parseDocument(content);
                String zoneDisplay = zoneMap.getZoneFullName(zone);
                zoneDisplay = StringUtils.stripAccents((String)zoneDisplay);
                zoneDisplay = zoneDisplay.replaceAll("[^\\w- ]", "_");
                File pdfFile = new File(directory, zoneDisplay + ".pdf");
                os = new FileOutputStream(pdfFile);
                ITextRenderer renderer = new ITextRenderer();
                renderer.setDocument(document, null);
                renderer.layout();
                renderer.createPDF((OutputStream)os);
                ((OutputStream)os).close();
            }
            catch (IOException ex) {
                try {
                    throw new CoserTechnicalException("Can't generate log pdf", ex);
                    catch (DocumentException ex2) {
                        throw new CoserTechnicalException("Can't generate log pdf", ex2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    Iterator i$2 = toDelete.iterator();
                    while (true) {
                        if (!i$2.hasNext()) {
                            throw throwable;
                        }
                        File file = (File)i$2.next();
                        FileUtils.deleteQuietly((File)file);
                    }
                }
            }
            IOUtils.closeQuietly((OutputStream)os);
            Iterator i$3 = toDelete.iterator();
            while (true) {
                if (!i$3.hasNext()) continue block5;
                File file = (File)i$3.next();
                FileUtils.deleteQuietly((File)file);
            }
            break;
        }
        return;
    }
}

