/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.repository.legacy.command;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import fr.ifremer.coser.result.repository.legacy.LegacyPredicates;
import fr.ifremer.coser.result.repository.legacy.command.AbstractLegacyCommand;
import fr.ifremer.coser.result.request.GetPopulationIndicatorResultGraphRequest;
import fr.ifremer.coser.result.result.FileResult;
import java.io.File;
import org.jfree.chart.JFreeChart;

public class GetPopulationIndicatorResultGraphCommand
extends AbstractLegacyCommand<GetPopulationIndicatorResultGraphRequest> {
    @Override
    public boolean accept(GetPopulationIndicatorResultGraphRequest request) {
        boolean result;
        boolean bl = result = this.repository.isIndicatorsResult() && this.repository.matchFacade(request) && this.repository.matchZone(request);
        if (result) {
            Predicate predicate = Predicates.and(LegacyPredicates.populationSpeciesPredicate(request.getSpecies()), LegacyPredicates.populationIndicatorPredicate(request.getIndicator()));
            result = this.repository.matchPopulation((Predicate<String[]>)predicate);
        }
        return result;
    }

    public FileResult execute(GetPopulationIndicatorResultGraphRequest request) {
        JFreeChart chart = this.generatePopulationChart(request.getZone(), request.getSpecies(), request.getIndicator());
        File file = this.getCharts().generateChartFile("coser-chart-population-indicator-", chart, 800, 400);
        FileResult result = this.newFileResult(file);
        return result;
    }
}

