/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.repository.legacy.command;

import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.result.repository.legacy.command.AbstractLegacyCommand;
import fr.ifremer.coser.result.request.ExtractRawDataRequest;
import fr.ifremer.coser.result.result.FileResult;
import fr.ifremer.coser.result.util.Reports;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ZipUtil;

public class ExtractRawDataCommand
extends AbstractLegacyCommand<ExtractRawDataRequest> {
    @Override
    public boolean accept(ExtractRawDataRequest request) {
        return this.repository.isDataResult() && this.repository.matchFacade(request) && this.repository.matchZone(request);
    }

    public FileResult execute(ExtractRawDataRequest request) {
        File resultZip;
        Locale locale = this.getLocale();
        this.loadSelectionData();
        try {
            File tempDir = FileUtil.createTempDirectory((String)"coser-source-", (String)"-tmp");
            File archiveDir = this.extractRSUfiData(tempDir);
            String filename = Reports.getDechargeFilename(locale);
            File dechargePDF = new File(archiveDir, filename);
            Date lastDataUpdateDate = this.getConfig().getLastDataUpdateDate();
            this.getReports().generateDechargePDF(dechargePDF, locale, lastDataUpdateDate, this.repository.getSurveyName());
            File reftaxFile = new File(this.repository.getBasedir(), CoserConstants.Category.REFTAX_SPECIES.getStorageFileName());
            FileUtils.copyFileToDirectory((File)reftaxFile, (File)archiveDir);
            resultZip = File.createTempFile("coser-source-", ".zip");
            resultZip.deleteOnExit();
            ZipUtil.compress((File)resultZip, (File)archiveDir);
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Can't create zip file", e);
        }
        FileResult result = this.newFileResult(resultZip);
        return result;
    }
}

