/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.repository.legacy;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.bean.RSufiResult;
import fr.ifremer.coser.bean.RSufiResultPath;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.result.ResultRepositoryInitializationException;
import fr.ifremer.coser.result.ResultType;
import fr.ifremer.coser.result.repository.ResultRepositoryProvider;
import fr.ifremer.coser.result.repository.legacy.LegacyResultRepository;
import fr.ifremer.coser.result.repository.legacy.LegacyResultRepositoryType;
import fr.ifremer.coser.services.ProjectService;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LegacyResultRepositoryProvider
implements ResultRepositoryProvider<LegacyResultRepository> {
    private static final Log log = LogFactory.getLog(LegacyResultRepositoryProvider.class);
    protected final File basedir;
    protected final CoserBusinessConfig config;
    protected final ResultType resultType;

    public LegacyResultRepositoryProvider(CoserBusinessConfig config, File basedir, ResultType resultType) {
        Preconditions.checkNotNull((Object)((Object)config));
        Preconditions.checkNotNull((Object)basedir);
        this.config = config;
        this.resultType = resultType;
        this.basedir = basedir;
    }

    @Override
    public LegacyResultRepositoryType getRepositoryType() {
        return LegacyResultRepositoryType.INSTANCE;
    }

    @Override
    public Set<LegacyResultRepository> loadRepositories() {
        Set<LegacyResultRepository> result;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Scan for projects from basedir: %s", this.basedir));
        }
        try {
            result = this.findAllProjectWithResult();
        }
        catch (CoserBusinessException e) {
            throw new ResultRepositoryInitializationException(this, "Could not find projects", e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Found %s result repository(ies) from basedir: %s", result.size(), this.basedir));
        }
        return result;
    }

    protected Set<LegacyResultRepository> findAllProjectWithResult() throws CoserBusinessException {
        ProjectService projectService = new ProjectService(this.config);
        HashSet result = Sets.newHashSet();
        File[] projects = this.basedir.listFiles();
        if (projects != null) {
            for (File existingProject : projects) {
                if (!existingProject.isDirectory()) continue;
                String projectName = existingProject.getName();
                Project p = projectService.openProject(projectName, this.basedir);
                File selectionsDirectory = new File(existingProject, "selections");
                File[] selections = selectionsDirectory.listFiles();
                if (selections == null) continue;
                for (File existingSelection : selections) {
                    if (!existingSelection.isDirectory()) continue;
                    String selectionName = existingSelection.getName();
                    Selection s = new Selection(selectionName);
                    File rsufisDirectory = new File(existingSelection, "results");
                    File[] rSufiResults = rsufisDirectory.listFiles();
                    if (rSufiResults == null) continue;
                    for (File rSufiResult : rSufiResults) {
                        RSufiResult r;
                        boolean candidate;
                        if (!rSufiResult.isDirectory() || !(candidate = (r = projectService.getRSufiResult(rSufiResult)).isPubliableResult())) continue;
                        RSufiResultPath path = new RSufiResultPath(p, s, r);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Detected result: " + result));
                        }
                        String surveyName = projectService.getProjectSurveyName(rSufiResult, r);
                        LegacyResultRepository repository = new LegacyResultRepository(existingProject, path, surveyName);
                        this.sanityRepository(repository);
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Detected result: %s - %s", path.getProject().getName(), path.getRsufiResult().getName()));
                        }
                        result.add(repository);
                    }
                }
            }
        }
        return result;
    }

    protected void sanityRepository(LegacyResultRepository repository) {
        if (this.resultType != null) {
            boolean needSave = false;
            RSufiResult rsufiResult = repository.getPath().getRsufiResult();
            if (this.resultType == ResultType.MAP && repository.isIndicatorsResult()) {
                needSave = true;
                rsufiResult.setIndicatorsResult(false);
                if (log.isInfoEnabled()) {
                    log.info((Object)"Will sanity repository to only map result");
                }
            }
            if (this.resultType == ResultType.INDICATOR) {
                if (repository.isMapsResult()) {
                    needSave = true;
                    rsufiResult.setMapsResult(false);
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Will sanity repository to only indicator result");
                    }
                }
                if (needSave) {
                    rsufiResult.save(repository.getResultDirectory());
                }
            }
        }
    }
}

