/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.repository.echobase;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.coser.bean.EchoBaseProject;
import fr.ifremer.coser.bean.SpeciesMap;
import fr.ifremer.coser.result.ResultType;
import fr.ifremer.coser.result.repository.ResultRepository;
import fr.ifremer.coser.result.repository.echobase.EchoBaseResultRepositoryType;
import fr.ifremer.coser.result.request.CoserRequestExtractTypeListAware;
import fr.ifremer.coser.result.request.CoserRequestFacadeAware;
import fr.ifremer.coser.result.request.CoserRequestRepositoryResultTypeAware;
import fr.ifremer.coser.result.request.CoserRequestRepositoryTypeAware;
import fr.ifremer.coser.result.request.CoserRequestZoneAware;
import fr.ifremer.coser.result.request.CoserRequestZoneListAware;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.DataStorages;
import fr.ifremer.coser.util.DataType;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EchoBaseResultRepository
implements ResultRepository {
    private static final Log log = LogFactory.getLog(EchoBaseResultRepository.class);
    protected final EchoBaseProject project;
    protected final Function<File, String> mapFileToSpeciesCode;
    protected final Function<String, String> speciesCodeToMapFile;
    protected final FilenameFilter mapSpeciesFilenameFilter;
    protected SpeciesMap speciesMap;
    protected final String id;

    public EchoBaseResultRepository(EchoBaseProject project) {
        Preconditions.checkNotNull((Object)project);
        this.project = project;
        String surveyName = project.getSurveyName();
        this.mapFileToSpeciesCode = EchoBaseProject.newMapFileToSpeciesCode(surveyName);
        this.speciesCodeToMapFile = EchoBaseProject.newSpeciesCodeToMapFileName(surveyName);
        this.mapSpeciesFilenameFilter = EchoBaseProject.newMapSpeciesFilenameFilter(surveyName);
        this.id = "echobase::" + project.getBasedir();
        if (log.isInfoEnabled()) {
            log.info((Object)("New result repository: " + this.id));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public EchoBaseResultRepositoryType getResultRepositoryType() {
        return EchoBaseResultRepositoryType.INSTANCE;
    }

    @Override
    public File getBasedir() {
        return this.project.getBasedir();
    }

    @Override
    public String getProjectName() {
        return this.project.getName();
    }

    @Override
    public String getSurveyName() {
        return this.project.getSurveyName();
    }

    @Override
    public String getZone() {
        return this.project.getZoneName();
    }

    @Override
    public boolean isMapsResult() {
        return true;
    }

    @Override
    public boolean isIndicatorsResult() {
        return true;
    }

    @Override
    public boolean isDataResult() {
        return true;
    }

    @Override
    public boolean isPubliableResult() {
        return this.project.isPubliableResult();
    }

    public EchoBaseProject getProject() {
        return this.project;
    }

    public boolean matchFacade(CoserRequestFacadeAware request) {
        return this.getProject().getFacadeName().equals(request.getFacade());
    }

    public boolean matchZone(CoserRequestZoneAware request) {
        return this.getZone().equals(request.getZone());
    }

    public boolean matchZone(CoserRequestZoneListAware request) {
        List<String> zoneList = request.getZoneList();
        boolean result = zoneList.contains(this.getZone());
        return result;
    }

    public boolean matchRepositoryType(CoserRequestRepositoryTypeAware request) {
        boolean result = request.getRepositoryType().equals("echobase");
        return result;
    }

    public boolean matchResultType(CoserRequestRepositoryResultTypeAware request) {
        ResultType resultType = request.getResultType();
        boolean result = ResultType.MAP_AND_INDICATOR == resultType;
        return result;
    }

    public boolean matchExtractTypeList(CoserRequestExtractTypeListAware request) {
        boolean result = false;
        List<DataType> extractTypeList = request.getExtractTypeList();
        if (extractTypeList.contains((Object)DataType.MAP)) {
            result = this.isMapsResult();
        }
        if (!result && (extractTypeList.contains((Object)DataType.POPULATION) || extractTypeList.contains((Object)DataType.COMMUNITY))) {
            result = this.isIndicatorsResult();
        }
        if (!result && extractTypeList.contains((Object)DataType.SOURCE)) {
            result = this.isDataResult();
        }
        return result;
    }

    public boolean matchCommunity(Predicate<String[]> predicate) {
        Preconditions.checkNotNull(predicate);
        DataStorage storage = this.getCommunityIndicatorStorage();
        boolean result = DataStorages.match(storage, predicate, true);
        return result;
    }

    public boolean matchPopulation(Predicate<String[]> predicate) {
        Preconditions.checkNotNull(predicate);
        DataStorage storage = this.getPopulationIndicatorStorage();
        boolean result = DataStorages.match(storage, predicate, true);
        return result;
    }

    public File getMapSpeciesFile(String species) {
        String fileName = (String)this.speciesCodeToMapFile.apply((Object)species);
        File file = fileName == null ? null : new File(this.project.getMapsDirectory(), fileName);
        return file;
    }

    public Map<String, String> getMapSpecies() {
        HashSet speciesList = Sets.newHashSet();
        Object[] files = this.project.getMapsDirectory().listFiles(this.mapSpeciesFilenameFilter);
        if (files != null) {
            List transform = Lists.transform((List)Lists.newArrayList((Object[])files), this.mapFileToSpeciesCode);
            speciesList.addAll(transform);
        }
        Map<String, String> result = this.getSpeciesMap().getSpeciesSubMap(speciesList);
        return result;
    }

    public SpeciesMap getSpeciesMap() {
        if (this.speciesMap == null) {
            File file = this.project.getSpeciesDefinitionFile();
            this.speciesMap = new SpeciesMap(file);
        }
        return this.speciesMap;
    }

    public DataStorage getPopulationIndicatorStorage() {
        File file = this.project.getPopulationIndicatorsFile();
        DataStorage result = DataStorages.load(file);
        return result;
    }

    public DataStorage getCommunityIndicatorStorage() {
        File file = this.project.getCommunityIndicatorsFile();
        DataStorage result = DataStorages.load(file);
        return result;
    }
}

