/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.result.CoserRequest;
import fr.ifremer.coser.result.ResultType;
import fr.ifremer.coser.result.request.CopyRepositoryRequest;
import fr.ifremer.coser.result.request.CoserRequestExtractTypeListAware;
import fr.ifremer.coser.result.request.CoserRequestFacadeAware;
import fr.ifremer.coser.result.request.CoserRequestIndicatorAware;
import fr.ifremer.coser.result.request.CoserRequestRepositoryResultTypeAware;
import fr.ifremer.coser.result.request.CoserRequestRepositoryTypeAware;
import fr.ifremer.coser.result.request.CoserRequestSpeciesAware;
import fr.ifremer.coser.result.request.CoserRequestZoneAware;
import fr.ifremer.coser.result.request.CoserRequestZoneListAware;
import fr.ifremer.coser.result.request.ExtractRawDataAndResultsRequest;
import fr.ifremer.coser.util.DataType;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class CoserRequestBuilder<R extends CoserRequest> {
    protected static final String PARAMETER_RESULT_TYPE = "resultType";
    protected static final String PARAMETER_REPOSITORY_TYPE = "resultRepositoryType";
    protected static final String PARAMETER_INDICATOR = "indicator";
    protected static final String PARAMETER_ZONE_LIST = "zoneList";
    protected static final String PARAMETER_SPECIES = "species";
    protected static final String PARAMETER_ZONE = "zone";
    protected static final String PARAMETER_FACADE = "facade";
    protected static final String PARAMETER_SPECIES_LIST = "speciesList";
    protected static final String PARAMETER_POPULATION_INDICATOR_LIST = "populationIndicatorList";
    protected static final String PARAMETER_COMMUNITY_INDICATOR_LIST = "communityIndicatorList";
    protected static final String PARAMETER_EXTRACT_TYPE_LIST = "extractTypeList";
    protected static final String PARAMETER_TARGET_DIRECTORY = "targetDirectory";
    protected final Locale locale;
    protected final Class<R> requestType;
    protected final Map<String, Object> parameters;

    public static <R extends CoserRequest> CoserRequestBuilder<R> newBuilder(Locale locale, Class<R> requestType) {
        return new CoserRequestBuilder<R>(locale, requestType);
    }

    protected CoserRequestBuilder(Locale locale, Class<R> requestType) {
        Preconditions.checkNotNull((Object)locale);
        Preconditions.checkNotNull(requestType);
        this.locale = locale;
        this.requestType = requestType;
        this.parameters = Maps.newTreeMap();
    }

    public CoserRequestBuilder<R> addFacade(String facade) {
        this.parameters.put(PARAMETER_FACADE, facade);
        return this;
    }

    public CoserRequestBuilder<R> addZone(String zone) {
        this.parameters.put(PARAMETER_ZONE, zone);
        return this;
    }

    public CoserRequestBuilder<R> addSpecies(String species) {
        this.parameters.put(PARAMETER_SPECIES, species);
        return this;
    }

    public CoserRequestBuilder<R> addIndicator(String indicator) {
        this.parameters.put(PARAMETER_INDICATOR, indicator);
        return this;
    }

    public CoserRequestBuilder<R> addExtractTypeList(List<DataType> extractTypeList) {
        this.parameters.put(PARAMETER_EXTRACT_TYPE_LIST, extractTypeList);
        return this;
    }

    public CoserRequestBuilder<R> addZoneList(List<String> zoneList) {
        this.parameters.put(PARAMETER_ZONE_LIST, zoneList);
        return this;
    }

    public CoserRequestBuilder<R> addSpeciesList(List<String> speciesList) {
        this.parameters.put(PARAMETER_SPECIES_LIST, speciesList);
        return this;
    }

    public CoserRequestBuilder<R> addPopulationIndicatorList(List<String> populationIndicatorList) {
        this.parameters.put(PARAMETER_POPULATION_INDICATOR_LIST, populationIndicatorList);
        return this;
    }

    public CoserRequestBuilder<R> addCommunityIndicatorList(List<String> communityIndicatorList) {
        this.parameters.put(PARAMETER_COMMUNITY_INDICATOR_LIST, communityIndicatorList);
        return this;
    }

    public CoserRequestBuilder<R> addRepositoryType(String repositoryType) {
        this.parameters.put(PARAMETER_REPOSITORY_TYPE, repositoryType);
        return this;
    }

    public CoserRequestBuilder<R> addResultType(ResultType resultType) {
        this.parameters.put(PARAMETER_RESULT_TYPE, (Object)resultType);
        return this;
    }

    public CoserRequestBuilder<R> addTargetDirectory(File targetDirectory) {
        this.parameters.put(PARAMETER_TARGET_DIRECTORY, targetDirectory);
        return this;
    }

    public R toRequest() {
        try {
            CoserRequest request = (CoserRequest)this.requestType.newInstance();
            this.flushCoserRequestFacadeAware(request);
            this.flushCoserRequestZoneAware(request);
            this.flushCoserRequestZoneListAware(request);
            this.flushCoserRequestSpeciesAware(request);
            this.flushCoserRequestIndicatorAware(request);
            this.flushCoserRequestRepositoryTypeAware(request);
            this.flushCoserRequestRepositoryResultTypeAware(request);
            this.flushCoserRequestExtractTypeListAware(request);
            this.flushExtractRawDataAndResultsRequest(request);
            this.flushCopyRepositoryRequest(request);
            return (R)request;
        }
        catch (InstantiationException e) {
            throw new CoserTechnicalException(e);
        }
        catch (IllegalAccessException e) {
            throw new CoserTechnicalException(e);
        }
    }

    protected void flushCopyRepositoryRequest(R request) {
        if (request instanceof CopyRepositoryRequest) {
            CopyRepositoryRequest r = (CopyRepositoryRequest)request;
            File targetDirectory = (File)this.getParam(PARAMETER_TARGET_DIRECTORY);
            if (targetDirectory != null) {
                r.setTargetDirectory(targetDirectory);
            }
        }
    }

    protected void flushExtractRawDataAndResultsRequest(R request) {
        if (request instanceof ExtractRawDataAndResultsRequest) {
            List<String> speciesList;
            List<String> communityIndicatorList;
            ExtractRawDataAndResultsRequest r = (ExtractRawDataAndResultsRequest)request;
            List<String> populationIndicatorList = this.getListParam(PARAMETER_POPULATION_INDICATOR_LIST);
            if (CollectionUtils.isNotEmpty(populationIndicatorList)) {
                r.setPopulationIndicatorList(populationIndicatorList);
            }
            if (CollectionUtils.isNotEmpty(communityIndicatorList = this.getListParam(PARAMETER_COMMUNITY_INDICATOR_LIST))) {
                r.setCommunityIndicatorList(communityIndicatorList);
            }
            if (CollectionUtils.isNotEmpty(speciesList = this.getListParam(PARAMETER_SPECIES_LIST))) {
                r.setSpeciesList(speciesList);
            }
        }
    }

    protected void flushCoserRequestFacadeAware(R request) {
        String facade;
        if (request instanceof CoserRequestFacadeAware && (facade = (String)this.getParam(PARAMETER_FACADE)) != null) {
            ((CoserRequestFacadeAware)request).setFacade(facade);
        }
    }

    protected void flushCoserRequestZoneAware(R request) {
        String zone;
        if (request instanceof CoserRequestZoneAware && (zone = (String)this.getParam(PARAMETER_ZONE)) != null) {
            ((CoserRequestZoneAware)request).setZone(zone);
        }
    }

    protected void flushCoserRequestSpeciesAware(R request) {
        String species;
        if (request instanceof CoserRequestSpeciesAware && (species = (String)this.getParam(PARAMETER_SPECIES)) != null) {
            ((CoserRequestSpeciesAware)request).setSpecies(species);
        }
    }

    protected void flushCoserRequestZoneListAware(R request) {
        List<String> zoneList;
        if (request instanceof CoserRequestZoneListAware && CollectionUtils.isNotEmpty(zoneList = this.getListParam(PARAMETER_ZONE_LIST))) {
            ((CoserRequestZoneListAware)request).setZoneList(zoneList);
        }
    }

    protected void flushCoserRequestExtractTypeListAware(R request) {
        List<DataType> zoneList;
        if (request instanceof CoserRequestExtractTypeListAware && CollectionUtils.isNotEmpty(zoneList = this.getListParam(PARAMETER_EXTRACT_TYPE_LIST))) {
            ((CoserRequestExtractTypeListAware)request).setExtractTypeList(zoneList);
        }
    }

    protected void flushCoserRequestIndicatorAware(R request) {
        String indicator;
        if (request instanceof CoserRequestIndicatorAware && (indicator = (String)this.getParam(PARAMETER_INDICATOR)) != null) {
            ((CoserRequestIndicatorAware)request).setIndicator(indicator);
        }
    }

    protected void flushCoserRequestRepositoryTypeAware(R request) {
        String repositoryType;
        if (request instanceof CoserRequestRepositoryTypeAware && (repositoryType = (String)this.getParam(PARAMETER_REPOSITORY_TYPE)) != null) {
            ((CoserRequestRepositoryTypeAware)request).setRepositoryType(repositoryType);
        }
    }

    protected void flushCoserRequestRepositoryResultTypeAware(R request) {
        ResultType resultType;
        if (request instanceof CoserRequestRepositoryResultTypeAware && (resultType = (ResultType)((Object)this.getParam(PARAMETER_RESULT_TYPE))) != null) {
            ((CoserRequestRepositoryResultTypeAware)request).setResultType(resultType);
        }
    }

    protected <O> O getParam(String parameterName) {
        Object o = this.parameters.get(parameterName);
        return (O)o;
    }

    protected <O> List<O> getListParam(String parameterName) {
        Object o = this.parameters.get(parameterName);
        return (List)o;
    }
}

