/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.command;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserUtils;
import fr.ifremer.coser.bean.AbstractDataContainer;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.command.Command;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class MergeSpeciesCommand
extends Command {
    private static final Log log = LogFactory.getLog(MergeSpeciesCommand.class);
    protected String newSpecyName;
    protected String[] speciesNames;

    public String getNewSpecyName() {
        return this.newSpecyName;
    }

    public void setNewSpecyName(String newSpecyName) {
        this.newSpecyName = newSpecyName;
    }

    public String[] getSpeciesNames() {
        return this.speciesNames;
    }

    public void setSpeciesNames(String[] speciesNames) {
        this.speciesNames = speciesNames;
    }

    @Override
    public void doCommand(Project project, AbstractDataContainer container) throws CoserBusinessException {
        project = this.mergeCatch(project, container, this.newSpecyName, this.speciesNames);
        project = this.mergeLength(project, container, this.newSpecyName, this.speciesNames);
    }

    @Override
    public void undoCommand(Project project, AbstractDataContainer container) throws CoserBusinessException {
        throw new UnsupportedOperationException("Merge operation can't be undone");
    }

    protected Project mergeLength(Project project, AbstractDataContainer container, String newSpecyName, String ... speciesNames) {
        HashMap<String, Integer> firstLineForKey = new HashMap<String, Integer>();
        Iterator<String[]> itTuple = container.getLength().iterator(true);
        int lineIndex = 1;
        while (itTuple.hasNext()) {
            String[] tuple = itTuple.next();
            String species = tuple[4];
            boolean specyFound = false;
            for (String specy : speciesNames) {
                if (!specy.equals(species)) continue;
                specyFound = true;
            }
            if (specyFound) {
                StringBuilder sb = new StringBuilder();
                for (int tupleIndex = 0; tupleIndex < tuple.length; ++tupleIndex) {
                    if (tupleIndex != 1 && tupleIndex != 2 && tupleIndex != 3 && tupleIndex != 5 && tupleIndex != 6 && tupleIndex != 7 && tupleIndex != 10) continue;
                    sb.append(tuple[tupleIndex]).append(';');
                }
                String key = sb.toString();
                Integer firstLineFound = (Integer)firstLineForKey.get(key);
                if (firstLineFound == null) {
                    tuple[4] = newSpecyName;
                    container.getLength().set(lineIndex, tuple);
                    firstLineForKey.put(key, lineIndex);
                    ++lineIndex;
                    continue;
                }
                String[] previousTuple = container.getLength().get(firstLineFound);
                String[] mergedTuple = this.mergeLengths(previousTuple, tuple);
                itTuple.remove();
                container.getLength().set(firstLineFound, mergedTuple);
                continue;
            }
            ++lineIndex;
        }
        return project;
    }

    protected String[] mergeLengths(String[] tuple1, String[] tuple2) {
        block6: {
            try {
                if (this.isNotAvailableData(tuple1[8]) || this.isNotAvailableData(tuple2[8])) {
                    tuple1[8] = "NA";
                } else {
                    double nombre1 = Double.parseDouble(tuple1[8]);
                    double nombre2 = Double.parseDouble(tuple2[8]);
                    tuple1[8] = String.valueOf(nombre1 + nombre2);
                }
                if (this.isNotAvailableData(tuple1[9]) || this.isNotAvailableData(tuple2[9])) {
                    tuple1[9] = "NA";
                } else {
                    double poids1 = Double.parseDouble(tuple1[9]);
                    double poids2 = Double.parseDouble(tuple2[9]);
                    tuple1[9] = String.valueOf(poids1 + poids2);
                }
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) break block6;
                log.warn((Object)"Can't convert data as double for merge", (Throwable)ex);
            }
        }
        return tuple1;
    }

    protected boolean isNotAvailableData(String data) {
        boolean result = false;
        if (StringUtils.isEmpty((CharSequence)data) || data.equals("NA")) {
            result = true;
        }
        return result;
    }

    protected Project mergeCatch(Project project, AbstractDataContainer container, String newSpecyName, String ... speciesNames) {
        HashMap<String, Integer> firstLineForKey = new HashMap<String, Integer>();
        Iterator<String[]> itTuple = container.getCatch().iterator(true);
        int lineIndex = 1;
        while (itTuple.hasNext()) {
            String[] tuple = itTuple.next();
            String species = tuple[4];
            boolean specyFound = false;
            for (String specy : speciesNames) {
                if (!specy.equals(species)) continue;
                specyFound = true;
            }
            if (specyFound) {
                StringBuilder sb = new StringBuilder();
                for (int tupleIndex = 0; tupleIndex < tuple.length; ++tupleIndex) {
                    if (tupleIndex != 1 && tupleIndex != 2 && tupleIndex != 3) continue;
                    sb.append(tuple[tupleIndex]).append(';');
                }
                String key = sb.toString();
                Integer firstLineFound = (Integer)firstLineForKey.get(key);
                if (firstLineFound == null) {
                    tuple[4] = newSpecyName;
                    container.getCatch().set(lineIndex, tuple);
                    firstLineForKey.put(key, lineIndex);
                    ++lineIndex;
                    continue;
                }
                String[] previousTuple = container.getCatch().get(firstLineFound);
                String[] mergeTuple = this.mergeCatches(previousTuple, tuple);
                itTuple.remove();
                container.getCatch().set(firstLineFound, mergeTuple);
                continue;
            }
            ++lineIndex;
        }
        return project;
    }

    protected String[] mergeCatches(String[] tuple1, String[] tuple2) {
        block2: {
            try {
                double nombre1 = Double.parseDouble(tuple1[5]);
                double nombre2 = Double.parseDouble(tuple2[5]);
                double poids1 = Double.parseDouble(tuple1[6]);
                double poids2 = Double.parseDouble(tuple2[6]);
                tuple1[5] = String.valueOf(nombre1 + nombre2);
                tuple1[6] = String.valueOf(poids1 + poids2);
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Can't convert data as double for merge", (Throwable)ex);
            }
        }
        return tuple1;
    }

    @Override
    public String toStringRepresentation() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("newSpecyName=" + this.newSpecyName);
        args.add("speciesNames=" + CoserUtils.convertBracketString(Arrays.asList(this.speciesNames)));
        return CoserUtils.convertBracketString(args);
    }

    @Override
    public void fromStringRepresentation(String representation) {
        List<String> args = CoserUtils.convertBracketToList(representation);
        for (String arg : args) {
            int indexOfEqual = arg.indexOf(61);
            String argAttribute = arg.substring(0, indexOfEqual);
            String value = arg.substring(indexOfEqual + 1);
            if (argAttribute.equals("newSpecyName")) {
                this.newSpecyName = value;
                continue;
            }
            if (!argAttribute.equals("speciesNames")) continue;
            List<String> speciesNamesList = CoserUtils.convertBracketToList(value);
            this.speciesNames = speciesNamesList.toArray(new String[speciesNamesList.size()]);
        }
    }

    @Override
    public String getLogString(Project project, AbstractDataContainer container) {
        StringBuilder speciesAsString = new StringBuilder(256);
        String separator = "";
        for (String speciesName : this.speciesNames) {
            speciesAsString.append(separator);
            speciesAsString.append(project.getDisplaySpeciesText(speciesName));
            separator = ", ";
        }
        String log = null;
        log = this.speciesNames.length == 1 ? I18n.t((String)"coser.business.command.mergespecies.rename.log", (Object[])new Object[]{project.getDisplaySpeciesText(this.newSpecyName), speciesAsString.toString()}) : I18n.t((String)"coser.business.command.mergespecies.log", (Object[])new Object[]{project.getDisplaySpeciesText(this.newSpecyName), speciesAsString.toString()});
        return log;
    }

    @Override
    public String getDescription(Project project, AbstractDataContainer container) {
        StringBuilder speciesAsString = new StringBuilder(256);
        String separator = "";
        for (String speciesName : this.speciesNames) {
            speciesAsString.append(separator);
            speciesAsString.append(project.getDisplaySpeciesText(speciesName));
            separator = ", ";
        }
        String desc = null;
        desc = this.speciesNames.length == 1 ? I18n.t((String)"coser.business.command.mergespecies.rename.desc", (Object[])new Object[]{project.getDisplaySpeciesText(this.newSpecyName), this.speciesNames.length, speciesAsString.toString()}) : I18n.t((String)"coser.business.command.mergespecies.desc", (Object[])new Object[]{project.getDisplaySpeciesText(this.newSpecyName), this.speciesNames.length, speciesAsString.toString()});
        if (StringUtils.isNotBlank((CharSequence)this.comment)) {
            desc = desc + " (" + this.comment + ")";
        }
        return desc;
    }

    public String toString() {
        return "Merge species to " + this.newSpecyName;
    }
}

