/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser;

import com.google.common.collect.Sets;
import fr.ifremer.coser.CoserApplicationContext;
import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.bean.IndicatorMap;
import fr.ifremer.coser.bean.ZoneMap;
import fr.ifremer.coser.result.CoserCommandFactory;
import fr.ifremer.coser.result.CoserMainRepositoryProvider;
import fr.ifremer.coser.result.repository.ResultRepositoryProvider;
import fr.ifremer.coser.result.repository.ResultRepositoryType;
import fr.ifremer.coser.result.util.Charts;
import fr.ifremer.coser.result.util.Extracts;
import fr.ifremer.coser.result.util.Reports;
import java.util.ServiceLoader;
import java.util.Set;
import org.nuiton.config.ArgumentsParserException;

public class DefaultCoserApplicationContext
implements CoserApplicationContext {
    protected CoserBusinessConfig config;
    protected Set<ResultRepositoryType> repositoryTypes;
    protected CoserMainRepositoryProvider repositoryProvider;
    protected CoserCommandFactory commandFactory;
    protected IndicatorMap indicatorsMap;
    protected ZoneMap zonesMap;
    protected Reports reports;
    protected Charts charts;
    private Extracts extracts;

    public DefaultCoserApplicationContext(CoserBusinessConfig config) {
        this.config = config;
        try {
            config.parse(new String[0]);
        }
        catch (ArgumentsParserException ex) {
            throw new CoserTechnicalException("Can't read configuration", ex);
        }
    }

    @Override
    public CoserBusinessConfig getConfig() {
        return this.config;
    }

    @Override
    public Set<ResultRepositoryType> getRepositoryTypes() {
        if (this.repositoryTypes == null) {
            ServiceLoader<ResultRepositoryType> loader = ServiceLoader.load(ResultRepositoryType.class);
            this.repositoryTypes = Sets.newHashSet(loader);
        }
        return this.repositoryTypes;
    }

    @Override
    public IndicatorMap getIndicatorMap() {
        if (this.indicatorsMap == null) {
            this.indicatorsMap = new IndicatorMap(this.config.getWebIndicatorsFile());
        }
        return this.indicatorsMap;
    }

    @Override
    public ZoneMap getZoneMap() {
        if (this.zonesMap == null) {
            this.zonesMap = new ZoneMap(this.config.getWebZonesFile());
        }
        return this.zonesMap;
    }

    @Override
    public Reports getReports() {
        if (this.reports == null) {
            this.reports = new Reports();
        }
        return this.reports;
    }

    @Override
    public Charts getCharts() {
        if (this.charts == null) {
            this.charts = new Charts();
        }
        return this.charts;
    }

    @Override
    public Extracts getExtracts() {
        if (this.extracts == null) {
            this.extracts = new Extracts();
        }
        return this.extracts;
    }

    @Override
    public CoserMainRepositoryProvider getRepositoryProvider() {
        if (this.repositoryProvider == null) {
            Set<ResultRepositoryProvider<?>> repositoryProviders = CoserMainRepositoryProvider.createDefaultRepositoryProviders(this.config);
            this.repositoryProvider = new CoserMainRepositoryProvider(repositoryProviders);
        }
        return this.repositoryProvider;
    }

    @Override
    public CoserCommandFactory getCommandFactory() {
        if (this.commandFactory == null) {
            this.commandFactory = new CoserCommandFactory(this.getRepositoryTypes());
        }
        return this.commandFactory;
    }
}

