/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import jregex.MatchResult;
import jregex.Matcher;
import jregex.Pattern;
import jregex.PatternSyntaxException;
import jregex.Replacer;
import jregex.Substitution;
import jregex.TextBuffer;

public class PerlSubstitution
implements Substitution {
    private static Pattern refPtn;
    private static int NAME_ID;
    private static int ESC_ID;
    private static final String groupRef = "\\$(?:\\{({=name}\\w+)\\}|({=name}\\d+|&))|\\\\({esc}.)";
    private Element queueEntry;

    public PerlSubstitution(String string) {
        Matcher matcher = new Matcher(refPtn);
        matcher.setTarget(string);
        this.queueEntry = PerlSubstitution.makeQueue(matcher);
    }

    public String value(MatchResult matchResult) {
        TextBuffer textBuffer = Replacer.wrap(new StringBuffer(matchResult.length()));
        this.appendSubstitution(matchResult, textBuffer);
        return textBuffer.toString();
    }

    private static Element makeQueue(Matcher matcher) {
        if (matcher.find()) {
            char c;
            Element element = matcher.isCaptured(NAME_ID) ? ((c = matcher.charAt(0, NAME_ID)) == '&' ? new IntRefHandler(matcher.prefix(), new Integer(0)) : (Character.isDigit(c) ? new IntRefHandler(matcher.prefix(), new Integer(matcher.group(NAME_ID))) : new StringRefHandler(matcher.prefix(), matcher.group(NAME_ID)))) : new PlainElement(matcher.prefix(), matcher.group(ESC_ID));
            matcher.setTarget(matcher, -2);
            element.next = PerlSubstitution.makeQueue(matcher);
            return element;
        }
        return new PlainElement(matcher.target());
    }

    public void appendSubstitution(MatchResult matchResult, TextBuffer textBuffer) {
        Element element = this.queueEntry;
        while (element != null) {
            element.append(matchResult, textBuffer);
            element = element.next;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Element element = this.queueEntry;
        while (element != null) {
            stringBuffer.append(element.toString());
            element = element.next;
        }
        return stringBuffer.toString();
    }

    static {
        try {
            refPtn = new Pattern(groupRef);
            NAME_ID = refPtn.groupId("name");
            ESC_ID = refPtn.groupId("esc");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            patternSyntaxException.printStackTrace();
        }
    }

    private static class StringRefHandler
    extends Element {
        private String index;

        StringRefHandler(String string, String string2) {
            this.prefix = string;
            this.index = string2;
        }

        void append(MatchResult matchResult, TextBuffer textBuffer) {
            if (this.prefix != null) {
                textBuffer.append(this.prefix);
            }
            if (this.index == null) {
                return;
            }
            Integer n = matchResult.pattern().groupId(this.index);
            int n2 = n;
            if (matchResult.isCaptured(n2)) {
                matchResult.getGroup(n2, textBuffer);
            }
        }
    }

    private static class IntRefHandler
    extends Element {
        private Integer index;

        IntRefHandler(String string, Integer n) {
            this.prefix = string;
            this.index = n;
        }

        void append(MatchResult matchResult, TextBuffer textBuffer) {
            if (this.prefix != null) {
                textBuffer.append(this.prefix);
            }
            if (this.index == null) {
                return;
            }
            int n = this.index;
            if (n >= matchResult.pattern().groupCount()) {
                return;
            }
            if (matchResult.isCaptured(n)) {
                matchResult.getGroup(n, textBuffer);
            }
        }
    }

    private static class PlainElement
    extends Element {
        private String str;

        PlainElement(String string) {
            this.str = string;
        }

        PlainElement(String string, String string2) {
            this.prefix = string;
            this.str = string2;
        }

        void append(MatchResult matchResult, TextBuffer textBuffer) {
            if (this.prefix != null) {
                textBuffer.append(this.prefix);
            }
            if (this.str != null) {
                textBuffer.append(this.str);
            }
        }
    }

    private static abstract class Element {
        protected String prefix;
        Element next;

        private Element() {
        }

        abstract void append(MatchResult var1, TextBuffer var2);
    }
}

