/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.RuleConstructionException;

public class DuplicateRuleNameException
extends RuleConstructionException {
    private static final long serialVersionUID = 7940684712885535254L;
    private Package pkg;
    private Rule originalRule;
    private Rule conflictingRule;

    public DuplicateRuleNameException(Package package_, Rule rule, Rule rule2) {
        super(DuplicateRuleNameException.createMessage(package_, rule2));
        this.pkg = package_;
        this.originalRule = rule;
        this.conflictingRule = rule2;
    }

    public DuplicateRuleNameException(Package package_, Rule rule, Rule rule2, Throwable throwable) {
        super(DuplicateRuleNameException.createMessage(package_, rule2), throwable);
        this.pkg = package_;
        this.originalRule = rule;
        this.conflictingRule = rule2;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public Rule getOriginalRule() {
        return this.originalRule;
    }

    public Rule getConflictingRule() {
        return this.conflictingRule;
    }

    private static String createMessage(Package package_, Rule rule) {
        return "Package " + (package_.getName() != null ? package_.getName() : "<no-name>") + " already contains rule with name " + rule.getName();
    }
}

