/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class StringFactory {
    public static Evaluator getStringEvaluator(int n) {
        switch (n) {
            case 1: {
                return StringEqualEvaluator.INSTANCE;
            }
            case 10: {
                return StringNotEqualEvaluator.INSTANCE;
            }
            case 70: {
                return StringMatchesEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + n + "' does not exist for StringEvaluator");
    }

    static class StringMatchesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 5934192092501066510L;
        public static final Evaluator INSTANCE = new StringMatchesEvaluator();

        private StringMatchesEvaluator() {
            super(180, 70);
        }

        public boolean evaluate(Object object, Object object2) {
            String string = (String)object2;
            String string2 = (String)object;
            if (object == null) {
                return false;
            }
            return string2.matches(string);
        }

        public String toString() {
            return "String !=";
        }
    }

    static class StringNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -3385245390840913608L;
        public static final Evaluator INSTANCE = new StringNotEqualEvaluator();

        private StringNotEqualEvaluator() {
            super(180, 10);
        }

        public boolean evaluate(Object object, Object object2) {
            if (object == null) {
                return object2 != null;
            }
            return !object.equals(object2);
        }

        public String toString() {
            return "String !=";
        }
    }

    static class StringEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 5282693491345148054L;
        public static final Evaluator INSTANCE = new StringEqualEvaluator();

        private StringEqualEvaluator() {
            super(180, 1);
        }

        public boolean evaluate(Object object, Object object2) {
            if (object == null) {
                return object2 == null;
            }
            return object.equals(object2);
        }

        public String toString() {
            return "String ==";
        }
    }
}

