/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends FilterInputStream {
    private int _pos;
    private int _markpos = -1;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    public int getPosition() {
        return this._pos;
    }

    @Override
    public int read() throws IOException {
        int r = super.read();
        if (r >= 0) {
            ++this._pos;
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = super.read(b);
        if (r > 0) {
            this._pos += r;
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = super.read(b, off, len);
        if (r > 0) {
            this._pos += r;
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        long r = super.skip(n);
        if (r > 0L) {
            this._pos = (int)((long)this._pos + r);
        }
        return r;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this._markpos = this._pos;
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this._pos = this._markpos;
    }
}

