/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.backend;

import de.taimos.gpsd4java.backend.AbstractResultParser;
import de.taimos.gpsd4java.backend.GPSdEndpoint;
import java.io.BufferedReader;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketThread
extends Thread {
    private static final Logger log = Logger.getLogger(SocketThread.class.getName());
    private final BufferedReader reader;
    private final GPSdEndpoint endpoint;
    private final AbstractResultParser resultParser;

    public SocketThread(BufferedReader reader, GPSdEndpoint endpoint, AbstractResultParser resultParser) {
        if (reader == null) {
            throw new IllegalArgumentException("reader can not be null!");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint can not be null!");
        }
        if (resultParser == null) {
            throw new IllegalArgumentException("resultParser can not be null!");
        }
        this.reader = reader;
        this.endpoint = endpoint;
        this.resultParser = resultParser;
        this.setDaemon(true);
        this.setName("GPS Socket Thread");
    }

    @Override
    public void run() {
        while (true) {
            try {
                String s;
                while ((s = this.reader.readLine()) != null) {
                    if (s.isEmpty()) continue;
                    this.endpoint.handle(this.resultParser.parse(s));
                }
            }
            catch (SocketException e) {
            }
            catch (Exception e) {
                log.log(Level.WARNING, null, e);
                continue;
            }
            break;
        }
    }
}

