/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.backend;

import de.taimos.gpsd4java.backend.AbstractResultParser;
import de.taimos.gpsd4java.types.ATTObject;
import de.taimos.gpsd4java.types.DeviceObject;
import de.taimos.gpsd4java.types.DevicesObject;
import de.taimos.gpsd4java.types.ENMEAMode;
import de.taimos.gpsd4java.types.EParity;
import de.taimos.gpsd4java.types.GSTObject;
import de.taimos.gpsd4java.types.IGPSObject;
import de.taimos.gpsd4java.types.ParseException;
import de.taimos.gpsd4java.types.PollObject;
import de.taimos.gpsd4java.types.SATObject;
import de.taimos.gpsd4java.types.SKYObject;
import de.taimos.gpsd4java.types.TPVObject;
import de.taimos.gpsd4java.types.VersionObject;
import de.taimos.gpsd4java.types.WatchObject;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class ResultParser
extends AbstractResultParser {
    private static final Logger log = Logger.getLogger(ResultParser.class.getName());
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public ResultParser() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public IGPSObject parse(JSONObject json) throws ParseException {
        IGPSObject gps = null;
        String clazz = json.optString("class");
        if ("TPV".equals(clazz)) {
            TPVObject tpv = new TPVObject();
            tpv.setTag(json.optString("tag", null));
            tpv.setDevice(json.optString("device", null));
            tpv.setTimestamp(this.parseTimestamp(json));
            tpv.setTimestampError(json.optDouble("ept", Double.NaN));
            tpv.setLatitude(json.optDouble("lat", Double.NaN));
            tpv.setLongitude(json.optDouble("lon", Double.NaN));
            tpv.setAltitude(json.optDouble("alt", Double.NaN));
            tpv.setLongitudeError(json.optDouble("epx", Double.NaN));
            tpv.setLatitudeError(json.optDouble("epy", Double.NaN));
            tpv.setAltitudeError(json.optDouble("epv", Double.NaN));
            tpv.setCourse(json.optDouble("track", Double.NaN));
            tpv.setSpeed(json.optDouble("speed", Double.NaN));
            tpv.setClimbRate(json.optDouble("climb", Double.NaN));
            tpv.setCourseError(json.optDouble("epd", Double.NaN));
            tpv.setSpeedError(json.optDouble("eps", Double.NaN));
            tpv.setClimbRateError(json.optDouble("epc", Double.NaN));
            tpv.setMode(ENMEAMode.fromInt(json.optInt("mode", 0)));
            gps = tpv;
        } else if ("SKY".equals(clazz)) {
            SKYObject sky = new SKYObject();
            sky.setTag(json.optString("tag", null));
            sky.setDevice(json.optString("device", null));
            sky.setTimestamp(this.parseTimestamp(json));
            sky.setLongitudeDOP(json.optDouble("xdop", Double.NaN));
            sky.setLatitudeDOP(json.optDouble("ydop", Double.NaN));
            sky.setAltitudeDOP(json.optDouble("vdop", Double.NaN));
            sky.setTimestampDOP(json.optDouble("tdop", Double.NaN));
            sky.setHorizontalDOP(json.optDouble("hdop", Double.NaN));
            sky.setSphericalDOP(json.optDouble("pdop", Double.NaN));
            sky.setHypersphericalDOP(json.optDouble("gdop", Double.NaN));
            sky.setSatellites(this.parseObjectArray(json.optJSONArray("satellites"), SATObject.class));
            gps = sky;
        } else if ("GST".equals(clazz)) {
            GSTObject gst = new GSTObject();
            gst.setTag(json.optString("tag", null));
            gst.setDevice(json.optString("device", null));
            gst.setTimestamp(this.parseTimestamp(json));
            gst.setRms(json.optDouble("rms", Double.NaN));
            gst.setMajor(json.optDouble("major", Double.NaN));
            gst.setMinor(json.optDouble("minor", Double.NaN));
            gst.setOrient(json.optDouble("orient", Double.NaN));
            gst.setLat(json.optDouble("lat", Double.NaN));
            gst.setLon(json.optDouble("lon", Double.NaN));
            gst.setAlt(json.optDouble("alt", Double.NaN));
            gps = gst;
        } else if ("ATT".equals(clazz)) {
            ATTObject att = new ATTObject();
            att.setTag(json.optString("tag", null));
            att.setDevice(json.optString("device", null));
            att.setTimestamp(this.parseTimestamp(json));
            att.setHeading(json.optDouble("heading", Double.NaN));
            att.setPitch(json.optDouble("pitch", Double.NaN));
            att.setYaw(json.optDouble("yaw", Double.NaN));
            att.setRoll(json.optDouble("roll", Double.NaN));
            att.setDip(json.optDouble("dip", Double.NaN));
            att.setMag_len(json.optDouble("mag_len", Double.NaN));
            att.setMag_x(json.optDouble("mag_x", Double.NaN));
            att.setMag_y(json.optDouble("mag_y", Double.NaN));
            att.setMag_z(json.optDouble("mag_z", Double.NaN));
            att.setAcc_len(json.optDouble("acc_len", Double.NaN));
            att.setAcc_x(json.optDouble("acc_x", Double.NaN));
            att.setAcc_y(json.optDouble("acc_y", Double.NaN));
            att.setAcc_z(json.optDouble("acc_z", Double.NaN));
            att.setGyro_x(json.optDouble("gyro_x", Double.NaN));
            att.setGyro_y(json.optDouble("gyro_y", Double.NaN));
            att.setDepth(json.optDouble("depth", Double.NaN));
            att.setTemperature(json.optDouble("temperature", Double.NaN));
            att.setMagState(json.optString("mag_st", null));
            att.setRollState(json.optString("roll_st", null));
            att.setPitchState(json.optString("pitch_st", null));
            att.setYawState(json.optString("yaw_st", null));
            gps = att;
        } else if ("VERSION".equals(clazz)) {
            VersionObject ver = new VersionObject();
            ver.setRelease(json.optString("release", null));
            ver.setRev(json.optString("rev", null));
            ver.setProtocolMajor(json.optDouble("proto_major", 0.0));
            ver.setProtocolMinor(json.optDouble("proto_minor", 0.0));
            gps = ver;
        } else if ("DEVICES".equals(clazz)) {
            DevicesObject devs = new DevicesObject();
            devs.setDevices(this.parseObjectArray(json.optJSONArray("devices"), DeviceObject.class));
            gps = devs;
        } else if ("DEVICE".equals(clazz)) {
            DeviceObject dev = new DeviceObject();
            dev.setPath(json.optString("path", null));
            dev.setActivated(json.optDouble("activated", Double.NaN));
            dev.setDriver(json.optString("driver", null));
            dev.setBps(json.optInt("bps", 0));
            dev.setParity(EParity.fromString(json.optString("parity")));
            dev.setStopbit(json.optInt("stopbit"));
            dev.setNativeMode(json.optInt("native", 0) == 1);
            dev.setCycle(json.optInt("cycle"));
            dev.setMincycle(json.optInt("mincycle"));
            gps = dev;
        } else if ("WATCH".equals(clazz)) {
            WatchObject watch = new WatchObject();
            watch.setEnable(json.optBoolean("enable", true));
            watch.setDump(json.optBoolean("json", false));
            gps = watch;
        } else if ("POLL".equals(clazz)) {
            PollObject poll = new PollObject();
            poll.setTimestamp(this.parseTimestamp(json));
            poll.setActive(json.optInt("active", 0));
            poll.setFixes(this.parseObjectArray(json.optJSONArray("fixes"), TPVObject.class));
            poll.setSkyviews(this.parseObjectArray(json.optJSONArray("skyviews"), SKYObject.class));
            gps = poll;
        } else if (json.has("PRN")) {
            SATObject sat = new SATObject();
            sat.setPRN(json.optInt("PRN", -1));
            sat.setAzimuth(json.optInt("az", -1));
            sat.setElevation(json.optInt("el", -1));
            sat.setSignalStrength(json.optInt("ss", -1));
            sat.setUsed(json.optBoolean("used", false));
            gps = sat;
        } else {
            throw new ParseException("Invalid object class: " + clazz);
        }
        return gps;
    }

    private double parseTimestamp(JSONObject json) {
        try {
            String text = json.optString("time", null);
            log.log(Level.FINE, "time: {0}", text);
            if (text != null) {
                Date date = this.dateFormat.parse(text);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Date: {0}", DateFormat.getDateTimeInstance(0, 0).format(date));
                }
                return (double)date.getTime() / 1000.0;
            }
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Failed to parse time", ex);
        }
        return Double.NaN;
    }
}

