/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.doctorjim.javaparser;

import de.plushnikov.doctorjim.ElementPosition;
import de.plushnikov.doctorjim.javaparser.Token;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaParser {
    private ElementPosition mPackage;
    private Collection<ElementPosition> mImports = new HashSet<ElementPosition>();
    private Collection<String> mLocalTypes = new HashSet<String>();
    private Collection<String> mTypes = new TreeSet<String>();

    public void setPackage(String pPackage, Token pStart, Token pEnd) {
        this.mPackage = new ElementPosition(pPackage, pStart, pEnd);
    }

    protected void addImport(String pImport, boolean pStatic, boolean pImportAll, Token pStart, Token pEnd) {
        StringBuilder lImport = new StringBuilder(50);
        if (pStatic) {
            lImport.append("static ");
        }
        lImport.append(pImport);
        if (pImportAll) {
            lImport.append(".*");
        }
        this.mImports.add(new ElementPosition(lImport.toString(), pStart, pEnd));
    }

    protected void addType(String pType) {
        this.mTypes.add(pType);
    }

    protected void addAnnotation(Token pToken) {
        this.addType(pToken.image);
    }

    protected void addThrows(Token pToken) {
        this.addType(pToken.image);
    }

    protected void addInternType(Token pToken) {
        String lNameValue = pToken.image;
        String[] lParts = lNameValue.split("\\.");
        if (lParts.length > 1) {
            StringBuilder lTypeValue = new StringBuilder(lNameValue.length());
            boolean lFound = false;
            for (String lPart : lParts) {
                lTypeValue.append(lPart);
                if (lPart.matches("\\p{Lu}.*")) {
                    lFound = true;
                    break;
                }
                lTypeValue.append('.');
            }
            if (lFound && lTypeValue.indexOf(".") > -1) {
                this.addType(lTypeValue.toString());
            }
        }
    }

    protected void addClassOrInterfaceName(Token pToken) {
        this.mLocalTypes.add(pToken.image);
    }

    protected void addEnumName(Token pToken) {
        this.mLocalTypes.add(pToken.image);
    }

    protected void addAnnotationName(Token pToken) {
        this.mLocalTypes.add(pToken.image);
    }

    public ElementPosition getPackage() {
        return this.mPackage;
    }

    public Collection<ElementPosition> getImports() {
        return this.mImports;
    }

    public Collection<String> getLocalTypes() {
        return this.mLocalTypes;
    }

    public Collection<String> getTypes() {
        return this.mTypes;
    }
}

