/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.doctorjim;

import de.plushnikov.doctorjim.ElementPosition;
import de.plushnikov.doctorjim.javaparser.JavaParser;
import de.plushnikov.doctorjim.javaparser.ParseException;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportProcessor {
    private final Log sLogger = LogFactory.getLog(ImportProcessor.class);
    private static final String NEW_LINE = "\r\n";
    private static final String DEFAULT_PACKAGE = "";
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    private static final String IMPORT_STATEMENT = "import ";
    private static final String STAR_IMPORT = ".*";
    private boolean mStrict = true;
    private String mEncoding = null;

    private void initializeJavaLang(Collection<String> pTypes) {
        pTypes.add("java.lang.*");
        pTypes.add("java.lang.Object");
        pTypes.add("java.lang.Short");
        pTypes.add("java.lang.Integer");
        pTypes.add("java.lang.Long");
        pTypes.add("java.lang.Float");
        pTypes.add("java.lang.Double");
        pTypes.add("java.lang.String");
        pTypes.add("java.lang.System");
        pTypes.add("java.lang.Character");
        pTypes.add("java.lang.Boolean");
        pTypes.add("java.lang.Byte");
        pTypes.add("java.lang.Number");
        pTypes.add("java.lang.Exeption");
        pTypes.add("java.lang.StringBuilder");
        pTypes.add("java.lang.StringBuffer");
    }

    private String changeReplacementWorkaround(String pImport2Replace) {
        String result = pImport2Replace;
        if (pImport2Replace.equals("java.util.Map.Entry")) {
            result = "java.util.Map";
        }
        return result;
    }

    public ImportProcessor() {
        this.sLogger.debug((Object)"Doctor JIM created");
    }

    public boolean isStrict() {
        return this.mStrict;
    }

    public void setStrict(boolean pStrict) {
        this.mStrict = pStrict;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void setEncoding(String pEncoding) {
        this.mEncoding = pEncoding;
    }

    public void organizeImports(File pInputFile, File pOutputFile) throws ParseException, IOException {
        String lInput = FileUtils.readFileToString((File)pInputFile, (String)this.getEncoding());
        String lOutput = this.organizeImports(lInput);
        FileUtils.writeStringToFile((File)pOutputFile, (String)lOutput, (String)this.getEncoding());
    }

    public String organizeImports(String pInput) throws ParseException {
        String lMainPackage;
        this.sLogger.debug((Object)"Started initialization of the parser");
        JavaParser lParser = new JavaParser(new StringReader(pInput));
        lParser.setTabSize(1);
        lParser.CompilationUnit();
        this.sLogger.debug((Object)"Parser successfully finished");
        ElementPosition lPackage = lParser.getPackage();
        String string = lMainPackage = null == lPackage ? DEFAULT_PACKAGE : lPackage.getValue();
        if (StringUtils.isNotBlank((String)lMainPackage)) {
            this.sLogger.debug((Object)("Found package declaration: " + lMainPackage));
        } else {
            this.sLogger.debug((Object)"Found no package declaration");
        }
        Collection<ElementPosition> lImports = lParser.getImports();
        HashSet<String> lOriginalImports = new HashSet<String>(lImports.size());
        HashSet<String> lStarImports = new HashSet<String>(lImports.size());
        for (ElementPosition lImport : lImports) {
            String lImportValue = lImport.getValue();
            lOriginalImports.add(lImportValue);
            if (!lImportValue.endsWith(STAR_IMPORT)) continue;
            lStarImports.add(lImportValue);
        }
        this.initializeJavaLang(lOriginalImports);
        if (this.isStrict() && !lStarImports.isEmpty()) {
            this.sLogger.debug((Object)"Doctor JIM is in strict modus and file contains star imports -> exiting");
            return pInput;
        }
        String lHeadSection = this.extractHeadSection(pInput, lPackage, lImports);
        String lImportsSection = this.extractImportsSection(pInput, lImports);
        boolean lImportsAreSafe = this.verifyInputSection(lImportsSection);
        HashSet<String> lGeneratedImports = new HashSet<String>();
        Collection<String> lLocalTypes = lParser.getLocalTypes();
        if (!StringUtils.isBlank((String)lMainPackage)) {
            for (String localType : lLocalTypes) {
                lGeneratedImports.add(lMainPackage + '.' + localType);
            }
        } else {
            lGeneratedImports.addAll(lLocalTypes);
        }
        String lBody = this.extractBodySection(pInput, lPackage, lImports);
        Collection<String> lTypes = lParser.getTypes();
        for (String lType : lTypes) {
            int lCurrentScanToken;
            String[] lParts = lType.split("\\.");
            for (lCurrentScanToken = lParts.length - 1; lCurrentScanToken >= 0 && !lParts[lCurrentScanToken].matches("\\p{Lu}.*"); --lCurrentScanToken) {
            }
            if (lCurrentScanToken < 0) continue;
            String lLastTypePart = lParts[lCurrentScanToken];
            String lImport2Replace = lType.substring(0, lType.lastIndexOf(lLastTypePart) + lLastTypePart.length());
            if (!(lImport2Replace = this.changeReplacementWorkaround(lImport2Replace)).matches("[\\p{L}&&[^\\p{Lu}]].*\\..*") || this.isConflict(lImport2Replace, lOriginalImports, lGeneratedImports)) continue;
            String lImport2ReplaceWith = lImport2Replace.substring(lImport2Replace.lastIndexOf(46) + 1);
            String lReplaceSource = "([^\\w\\p{L}\\.\"])" + lImport2Replace.replaceAll("\\.", "\\\\s*\\.\\\\s*") + "([^\\p{L}\"])";
            String lReplaceTarget = "$1" + lImport2ReplaceWith + "$2";
            String lBodyNew = lBody.replaceAll(lReplaceSource, lReplaceTarget);
            String lHeadSectionNew = lHeadSection.replaceAll(lReplaceSource, lReplaceTarget);
            if (lBodyNew.equals(lBody) && lHeadSectionNew.equals(lHeadSection)) continue;
            lGeneratedImports.add(lImport2Replace);
            lBody = lBodyNew;
            lHeadSection = lHeadSectionNew;
        }
        StringBuilder lBuffer = new StringBuilder(pInput.length());
        if (lHeadSection.length() > 0) {
            lBuffer.append(lHeadSection);
            lBuffer.append(NEW_LINE);
            lBuffer.append(NEW_LINE);
        }
        TreeSet<String> lAllImports = new TreeSet<String>();
        lAllImports.addAll(lGeneratedImports);
        if (!lImportsAreSafe) {
            if (lImportsSection.length() > 0) {
                lBuffer.append(lImportsSection);
                lBuffer.append(NEW_LINE);
                lBuffer.append(NEW_LINE);
            }
            lGeneratedImports.removeAll(lOriginalImports);
        } else {
            lAllImports.addAll(lOriginalImports);
        }
        String lGeneratedImportsSection = this.generateImportSection(lAllImports, lMainPackage, lStarImports);
        if (lGeneratedImportsSection.length() > 0) {
            lBuffer.append(lGeneratedImportsSection);
            lBuffer.append(NEW_LINE);
        }
        lBuffer.append(lBody);
        return lBuffer.toString();
    }

    protected String extractHeadSection(String pInput, ElementPosition pPackage, Collection<ElementPosition> pImports) {
        ElementPosition lFirstImport = null;
        if (!pImports.isEmpty()) {
            lFirstImport = Collections.min(pImports);
        }
        int lInputPosition = 0;
        if (null != pPackage || null != lFirstImport) {
            int lColumn = null == lFirstImport ? pPackage.getEndColumn() : lFirstImport.getStartColumn() - 1;
            int lLine = null == lFirstImport ? pPackage.getEndLine() : lFirstImport.getStartLine();
            lInputPosition = this.locatePosition(pInput, lLine, lColumn + 1);
        }
        if (this.sLogger.isDebugEnabled()) {
            this.sLogger.debug((Object)("Extract Headsection from positions [0," + lInputPosition + "]"));
        }
        return StringUtils.stripToEmpty((String)pInput.substring(0, lInputPosition));
    }

    protected String extractImportsSection(String pInput, Collection<ElementPosition> pImports) {
        String result = DEFAULT_PACKAGE;
        if (!pImports.isEmpty()) {
            ElementPosition lFirstImport = Collections.min(pImports);
            ElementPosition lLastImport = Collections.max(pImports);
            int lStart = this.locatePosition(pInput, lFirstImport.getStartLine(), lFirstImport.getStartColumn());
            int lEnd = this.locatePosition(pInput, lLastImport.getEndLine(), lLastImport.getEndColumn());
            if (this.sLogger.isDebugEnabled()) {
                this.sLogger.debug((Object)("Extract Importssection from positions [" + lStart + "," + (lEnd + 1) + "]"));
            }
            result = StringUtils.stripToEmpty((String)pInput.substring(lStart, lEnd + 1));
        } else {
            this.sLogger.debug((Object)"No Importsection to extract");
        }
        return result;
    }

    protected String extractBodySection(String pInput, ElementPosition pPackage, Collection<ElementPosition> pImports) {
        ElementPosition lClassBodyStartsAfterObject = pPackage;
        if (!pImports.isEmpty()) {
            lClassBodyStartsAfterObject = Collections.max(pImports);
        }
        int lClassBodyStartPosition = 0;
        if (null != lClassBodyStartsAfterObject) {
            lClassBodyStartPosition = this.locatePosition(pInput, lClassBodyStartsAfterObject.getEndLine(), lClassBodyStartsAfterObject.getEndColumn() + 1);
        }
        if (this.sLogger.isDebugEnabled()) {
            this.sLogger.debug((Object)("Extract Bodyssection from positions [" + lClassBodyStartPosition + "," + pInput.length() + "]"));
        }
        return StringUtils.stripToEmpty((String)pInput.substring(lClassBodyStartPosition));
    }

    protected boolean verifyInputSection(String pImportSection) {
        return !pImportSection.contains("//") && !pImportSection.contains("/*") && !pImportSection.contains("*/");
    }

    protected boolean isConflict(String type, Collection<String> importList, Collection<String> replacedSet) {
        return !JAVA_LANG_PACKAGE.equals(this.extractPackage(type)) && (this.isConflict(type, replacedSet) || this.isConflict(type, importList));
    }

    protected boolean isConflict(String pType, Collection<String> pTestSet) {
        if (pTestSet.contains(pType)) {
            return false;
        }
        for (String importType : pTestSet) {
            if (importType.endsWith(STAR_IMPORT) || importType.startsWith("static ") || pType.equals(importType)) continue;
            String lClassName = importType;
            int lPosition = importType.lastIndexOf(46);
            if (lPosition > 0) {
                lClassName = importType.substring(lPosition);
            }
            if (!pType.endsWith(lClassName)) continue;
            return true;
        }
        return false;
    }

    protected String generateImportSection(Set<String> pAllImports, String pMainPackage, Collection<String> pStarImports) {
        StringBuilder lBuffer = new StringBuilder(256);
        for (String lImport : pAllImports) {
            String lImportPackage = this.extractPackage(lImport);
            if (JAVA_LANG_PACKAGE.equals(lImportPackage) || pMainPackage.equals(lImportPackage) || !lImport.endsWith(STAR_IMPORT) && pStarImports.contains(lImportPackage + STAR_IMPORT)) continue;
            lBuffer.append(IMPORT_STATEMENT).append(lImport).append(';').append(NEW_LINE);
        }
        return lBuffer.toString();
    }

    protected int locatePosition(String pInput, int pLine, int pColumn) {
        int result = pColumn;
        if (pLine > 0) {
            result += StringUtils.ordinalIndexOf((String)pInput, (String)"\n", (int)(pLine - 1));
        }
        return result;
    }

    protected String extractPackage(String pImportType) {
        int index = pImportType.lastIndexOf(46);
        String typePackage = DEFAULT_PACKAGE;
        if (-1 < index) {
            typePackage = pImportType.substring(0, index);
        }
        return typePackage;
    }
}

