/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font.freetype;

import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.freetype.CharMap;
import de.intarsys.cwt.freetype.Face;
import de.intarsys.cwt.freetype.Freetype;
import de.intarsys.cwt.freetype.Library;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.PDFontType0;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.font.PDFontType3;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformFontFactory;
import de.intarsys.pdf.platform.cwt.font.NullPlatformFontFactory;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.PlatformFontTools;
import de.intarsys.pdf.platform.cwt.font.freetype.FreetypeFont;
import de.intarsys.pdf.platform.cwt.font.freetype.PACKAGE;
import de.intarsys.pdf.platform.cwt.font.type3.Type3FontFactory;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.resourcetracker.ResourceTracker;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FreetypeFontFactory
implements IPlatformFontFactory {
    private static ResourceTracker tracker = new ResourceTracker(100){

        protected void basicDispose(Object object) {
            ((Face)object).doneFace();
        }
    };
    private static final Logger Log = PACKAGE.Log;
    private static Library library;
    private static final Attribute ATTR_PLATFORMFONT;
    private Type3FontFactory type3FontFactory = new Type3FontFactory();
    private NullPlatformFontFactory nullFontFactory = new NullPlatformFontFactory();

    static {
        ATTR_PLATFORMFONT = new Attribute("platformFont");
    }

    protected static synchronized Library getLibrary() {
        if (library == null) {
            library = Freetype.initFreeType();
        }
        return library;
    }

    protected static Face loadFace(byte[] byArray, int n) {
        return FreetypeFontFactory.getLibrary().newMemoryFace(byArray, n);
    }

    protected static void registerPlatformFont(IAttributeSupport iAttributeSupport, IPlatformFont iPlatformFont) {
        iAttributeSupport.setAttribute((Object)ATTR_PLATFORMFONT, (Object)iPlatformFont);
    }

    protected IPlatformFont basicCreate(PDFont pDFont) throws PlatformFontException {
        Object object;
        if (pDFont instanceof PDFontType3) {
            return this.type3FontFactory.createPlatformFont(pDFont);
        }
        Face face = null;
        PDFontDescriptor pDFontDescriptor = null;
        try {
            pDFontDescriptor = pDFont.getFontDescriptor();
        }
        catch (COSRuntimeException cOSRuntimeException) {
            // empty catch block
        }
        if (pDFontDescriptor != null) {
            object = null;
            object = pDFontDescriptor.getFontFile();
            if (object == null) {
                object = pDFontDescriptor.getFontFile2();
            }
            if (object == null) {
                object = pDFontDescriptor.getFontFile3();
            }
            if (object != null) {
                face = FreetypeFontFactory.loadFace(object, 0);
            }
        }
        if (face == null) {
            face = this.getExternalFont(pDFont);
        }
        if (face == null) {
            Log.log(Level.WARNING, "can't load font '" + pDFont.getBaseFont() + "'");
            return this.nullFontFactory.createPlatformFont(pDFont);
        }
        this.selectCharacterMap(pDFont, face);
        object = new FreetypeFont(pDFont, face);
        tracker.trackPhantom((Object)pDFont, (Object)face);
        return object;
    }

    @Override
    public synchronized IPlatformFont createPlatformFont(PDFont pDFont) throws PlatformFontException {
        FreetypeFontFactory.getLibrary();
        IPlatformFont iPlatformFont = (IPlatformFont)pDFont.getAttribute((Object)ATTR_PLATFORMFONT);
        if (iPlatformFont == null) {
            iPlatformFont = this.basicCreate(pDFont);
            FreetypeFontFactory.registerPlatformFont((IAttributeSupport)pDFont, iPlatformFont);
        }
        return iPlatformFont;
    }

    protected Face getExternalFont(PDFont pDFont) throws CSException {
        IFont iFont = PlatformFontTools.getCWTFont(pDFont);
        if (iFont != null) {
            return this.loadFace(iFont);
        }
        return null;
    }

    protected Face loadFace(IFont iFont) {
        InputStream inputStream = null;
        try {
            inputStream = iFont.getFontProgram().getLocator().getInputStream();
            byte[] byArray = StreamTools.toByteArray((InputStream)inputStream);
            return FreetypeFontFactory.loadFace(byArray, 0);
        }
        catch (IOException iOException) {
            StreamTools.close(inputStream);
            return null;
        }
    }

    protected boolean selectCharacterMap(Face face, int n, int n2) {
        int n3 = face.getNumCharMaps();
        if (n3 == 0) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            CharMap charMap = face.getCharMap(n4);
            if (charMap.getPlatformID() == n && (n2 == -1 || charMap.getEncodingID() == n2)) {
                face.setCharMap(charMap);
                return true;
            }
            ++n4;
        }
        return false;
    }

    protected void selectCharacterMap(PDFont pDFont, Face face) {
        PDFontDescriptor pDFontDescriptor = null;
        try {
            pDFontDescriptor = pDFont.getFontDescriptor();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (pDFontDescriptor == null) {
            if (!this.selectCharacterMap(face, 3, 1)) {
                this.selectCharacterMap(face, 1, 0);
            }
        } else if (pDFontDescriptor.isSymbolic()) {
            if (pDFont instanceof PDFontType1) {
                this.selectCharacterMap(face, 7, -1);
            } else if (pDFont instanceof PDFontTrueType) {
                boolean bl = this.selectCharacterMap(face, 3, 0);
                if (!bl) {
                    this.selectCharacterMap(face, 1, 0);
                }
            } else if (!(pDFont instanceof PDFontType0)) {
                this.selectCharacterMap(face, 1, 0);
            }
        } else if (pDFont instanceof PDFontType1) {
            this.selectCharacterMap(face, 3, 1);
        } else if (pDFont instanceof PDFontTrueType) {
            if (!this.selectCharacterMap(face, 3, 1)) {
                this.selectCharacterMap(face, 1, 0);
            }
        } else if (!(pDFont instanceof PDFontType0)) {
            this.selectCharacterMap(face, 3, 1);
        }
    }
}

