/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.cwt.font.FontQuery;
import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontProgram;
import de.intarsys.cwt.font.IFontQuery;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontAny;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.platform.cwt.font.PACKAGE;
import de.intarsys.pdf.platform.cwt.font.PDFontTrueTypeTools;
import de.intarsys.pdf.platform.cwt.font.PDFontType1Tools;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlatformFontTools {
    private static final Attribute ATTR_CWTFONT = new Attribute("cwtfont");
    private static final Logger Log = PACKAGE.Log;

    public static boolean embedFontFile(PDFont pDFont) throws IOException {
        ILocator iLocator;
        if (pDFont.isEmbedded()) {
            return true;
        }
        IFont iFont = PlatformFontTools.getCWTFont(pDFont);
        if (iFont == null) {
            return false;
        }
        if (pDFont instanceof PDFontTrueType) {
            if (!"TrueType".equals(iFont.getFontType())) {
                return false;
            }
        } else if (pDFont instanceof PDFontType1) {
            if (!"Type1".equals(iFont.getFontType())) {
                return false;
            }
        } else {
            return false;
        }
        if ((iLocator = iFont.getFontProgram().getLocator()) == null) {
            return false;
        }
        return PlatformFontTools.embedFontFile(pDFont, iLocator);
    }

    public static boolean embedFontFile(PDFont pDFont, ILocator iLocator) throws IOException {
        if (pDFont instanceof PDFontTrueType) {
            PDFontTrueTypeTools.embedFontFile(pDFont, iLocator);
            return true;
        }
        if (pDFont instanceof PDFontType1) {
            PDFontType1Tools.embedFontFile(pDFont, iLocator);
            return true;
        }
        return false;
    }

    public static IFont getCWTFont(PDFont pDFont) {
        if (pDFont == null) {
            return null;
        }
        if (pDFont instanceof PDFontAny) {
            return null;
        }
        IFont iFont = (IFont)pDFont.getAttribute((Object)ATTR_CWTFONT);
        if (iFont != null) {
            return iFont;
        }
        Log.log(Level.FINEST, "load font program for " + pDFont.toString());
        FontQuery fontQuery = new FontQuery();
        fontQuery.setFontType(pDFont.getFontType());
        fontQuery.setFontName(pDFont.getLookupFontName());
        fontQuery.setFontFamilyName(pDFont.getLookupFontFamilyName());
        PDFontStyle pDFontStyle = pDFont.getLookupFontStyle();
        FontStyle fontStyle = FontStyle.getFontStyle((String)pDFontStyle.getLabel());
        fontQuery.setFontStyle(fontStyle);
        iFont = FontTools.lookupFont((IFontQuery)fontQuery);
        if (iFont != null) {
            PlatformFontTools.setCWTFont(pDFont, iFont);
            return iFont;
        }
        if (fontStyle != FontStyle.REGULAR) {
            fontQuery.setFontStyle(FontStyle.REGULAR);
            iFont = FontTools.lookupFont((IFontQuery)fontQuery);
            if (iFont != null) {
                PlatformFontTools.setCWTFont(pDFont, iFont);
                return iFont;
            }
        }
        fontQuery.setFontType("Any");
        fontQuery.setFontStyle(fontStyle);
        iFont = FontTools.lookupFont((IFontQuery)fontQuery);
        if (iFont != null) {
            PlatformFontTools.setCWTFont(pDFont, iFont);
            return iFont;
        }
        if (fontStyle != FontStyle.REGULAR) {
            fontQuery.setFontStyle(FontStyle.REGULAR);
            iFont = FontTools.lookupFont((IFontQuery)fontQuery);
            if (iFont != null) {
                PlatformFontTools.setCWTFont(pDFont, iFont);
                return iFont;
            }
        }
        if (pDFont instanceof PDFontTrueType) {
            fontQuery = new FontQuery();
            fontQuery.setFontType("TrueType");
            fontQuery.setFontName("Arial");
            fontQuery.setFontFamilyName("Arial");
            fontQuery.setFontStyle(fontStyle);
            iFont = FontTools.lookupFont((IFontQuery)fontQuery);
            if (iFont != null) {
                PlatformFontTools.setCWTFont(pDFont, iFont);
                return iFont;
            }
        }
        fontQuery = new FontQuery();
        fontQuery.setFontType("Type1");
        fontQuery.setFontName("Helvetica");
        fontQuery.setFontFamilyName("Helvetica");
        fontQuery.setFontStyle(fontStyle);
        iFont = FontTools.lookupFont((IFontQuery)fontQuery);
        PlatformFontTools.setCWTFont(pDFont, iFont);
        return iFont;
    }

    public static ILocator getFontFile(PDFont pDFont) {
        Object object;
        PDFontDescriptor pDFontDescriptor = pDFont.getFontDescriptor();
        if (pDFontDescriptor != null) {
            object = null;
            object = pDFontDescriptor.getFontFile();
            if (object == null) {
                object = pDFontDescriptor.getFontFile2();
            }
            if (object == null) {
                object = pDFontDescriptor.getFontFile3();
            }
            if (object != null) {
                return new ByteArrayLocator(object, pDFont.getFontName(), "dat");
            }
        }
        if ((object = (Object)PlatformFontTools.getCWTFont(pDFont)) != null) {
            IFontProgram iFontProgram = object.getFontProgram();
            return iFontProgram.getLocator();
        }
        return null;
    }

    public static void setCWTFont(PDFont pDFont, IFont iFont) {
        pDFont.setAttribute((Object)ATTR_CWTFONT, (Object)iFont);
    }
}

