/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.cwt.font.IFont;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.SymbolEncoding;
import de.intarsys.pdf.encoding.WinAnsiEncoding;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorEmbedded;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.pdf.platform.cwt.font.CommonFontConverter;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.PlatformFontFactory;
import de.intarsys.pdf.platform.cwt.font.PlatformFontTools;
import de.intarsys.tools.locator.ILocator;
import java.awt.geom.Rectangle2D;

public abstract class FontConverterPlatform2Pdf
extends CommonFontConverter {
    private PDFont pdFont;
    private IPlatformFont pfFont;

    public FontConverterPlatform2Pdf(IFont iFont) {
        super(iFont);
    }

    protected abstract PDFont basicCreatePdFont() throws FontFactoryException;

    protected IPlatformFont basicCreatePfFont() throws FontFactoryException {
        try {
            return PlatformFontFactory.get().createPlatformFont(this.pdFont);
        }
        catch (PlatformFontException platformFontException) {
            throw new FontFactoryException((Throwable)platformFontException);
        }
    }

    protected void createPdFont() throws FontFactoryException {
        this.pdFont = this.basicCreatePdFont();
        this.pdFont.setBaseFont(this.getCwtFont().getFontNamePostScript());
        PlatformFontTools.setCWTFont(this.pdFont, this.getCwtFont());
        this.pdFont.setLookupFontName(this.getCwtFont().getFontName());
        this.pdFont.setLookupFontFamilyName(this.getCwtFont().getFontFamilyName());
        this.pdFont.setLookupFontStyle(PDFontStyle.getFontStyle((String)this.getCwtFont().getFontStyle().getId()));
        PDFontDescriptorEmbedded pDFontDescriptorEmbedded = (PDFontDescriptorEmbedded)PDFontDescriptorEmbedded.META.createNew();
        this.pdFont.setFontDescriptor((PDFontDescriptor)pDFontDescriptorEmbedded);
        this.pfFont = this.basicCreatePfFont();
        this.fillPdFont();
        if (this.isEmbed()) {
            this.embedFontFile(this.getCwtFont().getFontProgram().getLocator());
        }
    }

    protected void embedFontFile(ILocator iLocator) throws FontFactoryException {
    }

    protected void fillFontDescriptor() throws FontFactoryException {
        PDFontDescriptorEmbedded pDFontDescriptorEmbedded = (PDFontDescriptorEmbedded)this.getPdFont().getFontDescriptor();
        pDFontDescriptorEmbedded.setAscent(this.pfFont.getAscent());
        pDFontDescriptorEmbedded.setDescent(this.pfFont.getDescent());
        pDFontDescriptorEmbedded.setCapHeight(this.pfFont.getHeight());
        Rectangle2D rectangle2D = this.pfFont.getBBox();
        CDSRectangle cDSRectangle = new CDSRectangle(rectangle2D);
        pDFontDescriptorEmbedded.setFontBB(cDSRectangle);
        pDFontDescriptorEmbedded.setFontName(this.pdFont.getBaseFont().stringValue());
        pDFontDescriptorEmbedded.getFlags().setSymbolic(this.pfFont.isSymbolFont());
        pDFontDescriptorEmbedded.getFlags().setItalic(this.pfFont.isItalicStyle());
        pDFontDescriptorEmbedded.getFlags().setForceBold(this.pfFont.isBoldStyle());
        pDFontDescriptorEmbedded.getFlags().setFixedPitch(this.pfFont.isMonospaced());
    }

    protected void fillPdFont() throws FontFactoryException {
        if (this.pfFont.isSymbolFont()) {
            this.pdFont.setEncoding((Encoding)SymbolEncoding.UNIQUE);
        } else {
            this.pdFont.setEncoding((Encoding)WinAnsiEncoding.UNIQUE);
        }
        this.fillFontDescriptor();
        this.fillWidths();
    }

    protected void fillWidths() throws FontFactoryException {
        int n = 255;
        int n2 = 0;
        try {
            COSArray cOSArray = COSArray.create((int)(n - n2 + 1));
            int n3 = n2;
            while (n3 <= n) {
                PDGlyphs pDGlyphs = this.pdFont.getGlyphsEncoded(n3);
                IPlatformGlyphs iPlatformGlyphs = this.pfFont.createPlatformGlyphs(pDGlyphs);
                cOSArray.add((COSObject)COSInteger.create((int)iPlatformGlyphs.getWidth()));
                ++n3;
            }
            this.pdFont.cosSetField(PDFont.DK_FirstChar, (COSObject)COSInteger.create((int)n2));
            this.pdFont.cosSetField(PDFont.DK_LastChar, (COSObject)COSInteger.create((int)n));
            this.pdFont.cosSetField(PDFont.DK_Widths, (COSObject)cOSArray);
        }
        catch (PlatformFontException platformFontException) {
            throw new FontFactoryException((Throwable)platformFontException);
        }
    }

    @Override
    public PDFont getPdFont() throws FontFactoryException {
        if (this.pdFont == null) {
            this.createPdFont();
        }
        return this.pdFont;
    }
}

