/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.image.awt;

import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;

import org.w3c.dom.Node;

import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;

public class PDImageMetadata extends IIOMetadata {
	public static final String NativeMetadataFormatName = "de_intarsys_pdf_platform_swtawt_image_1.0"; //$NON-NLS-1$

	private PDImage pdImage;

	public PDImageMetadata(PDImage paramPDImage) {
		super(false, NativeMetadataFormatName, null, null, null);
		pdImage = paramPDImage;
	}

	@Override
	public Node getAsTree(String formatName) {
		if (!NativeMetadataFormatName.equals(formatName)) {
			throw new IllegalArgumentException();
		}
		return getNativeTree();
	}

	private Node getNativeTree() {
		IIOMetadataNode root;
		IIOMetadataNode node;
		PDColorSpace colorSpace;
		String colorSpaceString;

		root = new IIOMetadataNode(nativeMetadataFormatName);

		node = new IIOMetadataNode("BitsPerComponent"); //$NON-NLS-1$
		node.setNodeValue(String.valueOf(pdImage.getBitsPerComponent()));
		root.appendChild(node);
		node = new IIOMetadataNode("ColorSpace"); //$NON-NLS-1$
		colorSpace = pdImage.getColorSpace();
		/*
		 * take advantage of the fact that many color space definitions consist
		 * of arrays with their type in the first slot; this should cover the
		 * color spaces that are actually used for images
		 */
		if (colorSpace.cosGetArray() != null) {
			colorSpaceString = colorSpace.cosGetArray().get(0).toString();
		} else {
			colorSpaceString = colorSpace.toString();
		}
		node.setNodeValue(colorSpaceString);
		root.appendChild(node);
		node = new IIOMetadataNode("Height"); //$NON-NLS-1$
		node.setNodeValue(String.valueOf(pdImage.getHeight()));
		root.appendChild(node);
		node = new IIOMetadataNode("Width"); //$NON-NLS-1$
		node.setNodeValue(String.valueOf(pdImage.getWidth()));
		root.appendChild(node);

		return root;
	}

	@Override
	public boolean isReadOnly() {
		return true;
	}

	@Override
	public void mergeTree(String formatName, Node root) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void reset() {
		throw new UnsupportedOperationException();
	}

}
