/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.image;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.cwt.image.IImage;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.adapter.GraphicsEnvironmentAdapterRegistry;
import de.intarsys.pdf.platform.cwt.adapter.IGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;

/**
 * The {@link IImage} implementation for an PDF {@link PDImage} object.
 * <p>
 * To render a {@link PDImage}, an implementation of
 * {@link IGraphicsEnvironmentAdapter} is looked up, that now knows both about
 * the {@link IGraphicsEnvironment} and the {@link PDImage} implementation.
 */
public class CwtPlatformImage implements IPlatformImage, IImage {

	private PDImage pdImage;

	public CwtPlatformImage(PDImage baseImage) {
		this.pdImage = baseImage;
	}

	public void doImage(ICSPlatformDevice device) {
		IGraphicsContext graphicsContext = (device).getGraphicsContext();
		graphicsContext.drawImage(this, 0, 0);
	}

	public void drawFromGraphicsContext(IGraphicsContext graphicsContext,
			float x, float y) {
		IGraphicsEnvironmentAdapter adapter = GraphicsEnvironmentAdapterRegistry
				.get().lookupGraphicsEnvironmentAdapter(
						graphicsContext.getGraphicsEnvironment());
		adapter.drawImage(graphicsContext, pdImage, x, y);
	}

	public int getHeight() {
		return pdImage.getHeight();
	}

	public PDImage getPDImage() {
		return pdImage;
	}

	public int getWidth() {
		return pdImage.getWidth();
	}
}
