/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;

public class NullPlatformGlyphs implements IPlatformGlyphs {

	final private IPlatformFont pfFont;

	final private PDGlyphs glyphs;

	protected NullPlatformGlyphs(IPlatformFont font, PDGlyphs glyphs) {
		this.pfFont = font;
		this.glyphs = glyphs;
	}

	public PDGlyphs getGlyphs() {
		return glyphs;
	}

	public IPlatformFont getPlatformFont() {
		return pfFont;
	}

	public int getWidth() {
		return 0;
	}

	public void render(ICSPlatformDevice device) {
		// 
	}

}
