/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.cwt.font.IFont;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.outlet.FontFactoryException;

/**
 * A common implementation to convert fonts from their platform representation
 * to PDF.
 * 
 */
abstract public class CommonFontConverter {

	private boolean embed = true;

	final private IFont cwtFont;

	public CommonFontConverter(IFont font) {
		this.cwtFont = font;
	}

	public IFont getCwtFont() {
		return cwtFont;
	}

	abstract public PDFont getPdFont() throws FontFactoryException;

	public boolean isEmbed() {
		return embed;
	}

	public void setEmbed(boolean embed) {
		this.embed = embed;
	}

}
