/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.pdf.pd.PDCSCalGray;
import de.intarsys.pdf.pd.PDCSCalRGB;
import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDCSDeviceN;
import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDCSICCBased;
import de.intarsys.pdf.pd.PDCSIndexed;
import de.intarsys.pdf.pd.PDCSLab;
import de.intarsys.pdf.pd.PDCSPattern;
import de.intarsys.pdf.pd.PDCSSeparation;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.tools.attribute.Attribute;

/**
 * 
 */
public class AwtColorSpaceFactory {

	private static final Attribute ATTR_COLORSPACE = new Attribute(
			"awtColorspace");

	private static AwtColorSpaceFactory Unique = new AwtColorSpaceFactory();

	synchronized static public AwtColorSpaceFactory get() {
		return Unique;
	}

	public AwtColorSpace createColorSpace(PDColorSpace pdColorSpace) {
		AwtColorSpace result = (AwtColorSpace) pdColorSpace
				.getAttribute(ATTR_COLORSPACE);
		if (result != null) {
			return result;
		}
		if (pdColorSpace instanceof PDCSCalGray) {
			result = new AwtCSCalGray(pdColorSpace);
		} else if (pdColorSpace instanceof PDCSCalRGB) {
			result = new AwtCSCalRGB(pdColorSpace);
		} else if (pdColorSpace instanceof PDCSICCBased) {
			result = new AwtCSICCBased(pdColorSpace);
		} else if (pdColorSpace instanceof PDCSLab) {
			result = new AwtCSLab(pdColorSpace);
		} else if (pdColorSpace instanceof PDCSDeviceCMYK) {
			result = new AwtCSDeviceCMYK(pdColorSpace);
		} else if (pdColorSpace instanceof PDCSDeviceGray) {
			result = new AwtCSDeviceGray(pdColorSpace);
		} else if (pdColorSpace instanceof PDCSDeviceRGB) {
			result = new AwtCSDeviceRGB(pdColorSpace);
		} else if (pdColorSpace instanceof PDCSDeviceN) {
			result = new AwtCSDeviceN(pdColorSpace);
		} else if (pdColorSpace instanceof PDCSIndexed) {
			result = new AwtCSIndexed(pdColorSpace);
		} else if (pdColorSpace instanceof PDCSPattern) {
			result = new AwtCSPattern(pdColorSpace);
		} else if (pdColorSpace instanceof PDCSSeparation) {
			result = new AwtCSSeparation(pdColorSpace);
		} else {
			result = new AwtCSDeviceRGB(pdColorSpace);
		}
		pdColorSpace.setAttribute(ATTR_COLORSPACE, result);
		return result;
	}
}
