/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;

import de.intarsys.pdf.pd.PDCSSeparation;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;

/**
 * 
 */
public class AwtCSSeparation extends AwtCSSpecial {
	class SeparationColorSpace extends ColorSpace {
		private ColorSpace alternateColorSpace;

		SeparationColorSpace() {
			super(ColorSpace.TYPE_GRAY, 1);
			alternateColorSpace = getColorSpace(myPDColorSpace().getAlternate())
					.getColorSpace();
		}

		public float[] fromCIEXYZ(float[] colorvalue) {
			throw new UnsupportedOperationException();
		}

		public float[] fromRGB(float[] rgbvalue) {
			throw new UnsupportedOperationException();
		}

		public float[] toCIEXYZ(float[] colorvalue) {
			return alternateColorSpace.toCIEXYZ(myPDColorSpace()
					.getTintTransform().evaluate(colorvalue));
		}

		public float[] toRGB(float[] colorvalue) {
			return alternateColorSpace.toRGB(myPDColorSpace()
					.getTintTransform().evaluate(colorvalue));
		}
	}

	public AwtCSSeparation(PDColorSpace pdColorSpace) {
		super(pdColorSpace);
	}

	@Override
	protected ColorSpace createColorSpace() {
		return new SeparationColorSpace();
	}

	@Override
	public ColorModel getColorModel(PDImage pdImage) {
		return new ComponentColorModel(getColorSpace(), false, false,
				Transparency.OPAQUE, DataBuffer.TYPE_BYTE);
	}

	@Override
	public int getNumComponents() {
		return 1;
	}

	protected PDCSSeparation myPDColorSpace() {
		return (PDCSSeparation) getPDColorSpace();
	}

}
