/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.adapter;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.paint.ColorPaint;
import de.intarsys.pdf.platform.cwt.paint.PatternPaint;
import de.intarsys.pdf.platform.cwt.paint.ShadingPaint;

/**
 * The adapter bridges between the concrete PDF image and the windowing toolkit.
 * <p>
 * The {@link IGraphicsEnvironment} abstracts from the windowing toolkit, for
 * example AWT or SWT. For each such execution environment an
 * {@link IGraphicsEnvironmentAdapter} can be registered, that knows how to
 * render the PDF primitives in that environment.
 * <p>
 * For every operation requested upon a complex PDF implementation object such
 * as a {@link PDImage}, the implementation is delegated to an instance of
 * {@link IGraphicsEnvironmentAdapter} that knows both about the PDF semantics
 * and the concrete window toolkit active.
 * <p>
 * While one could design {@link IGraphicsContext} in a way that the PDF
 * semantics are already supported, we feel that this would create a hard
 * dependency on CWT, rendering it unusable in non PDF contexts to act as a
 * platform independent environment.
 * 
 */
public interface IGraphicsEnvironmentAdapter {

	public void drawImage(IGraphicsContext graphicsContext, PDImage image,
			float x, float y);

	public IGraphicsEnvironment getGraphicsEnvironment();

	public void setBackgroundColorPaint(IGraphicsContext graphicsContext,
			ColorPaint paint);

	public void setBackgroundPatternPaint(IGraphicsContext graphicsContext,
			PatternPaint paint);

	public void setBackgroundShadingPaint(IGraphicsContext graphicsContext,
			ShadingPaint paint);

	public void setForegroundColorPaint(IGraphicsContext graphicsContext,
			ColorPaint paint);

	public void setForegroundPatternPaint(IGraphicsContext graphicsContext,
			PatternPaint paint);

	public void setForegroundShadingPaint(IGraphicsContext graphicsContext,
			ShadingPaint paint);

}
