/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.tools.attribute.IAttributeSupport;
import java.util.ArrayList;
import java.util.List;

public class PDAppearance
extends PDObject {
    public static final COSName DK_D = COSName.constant("D");
    public static final COSName DK_N = COSName.constant("N");
    public static final COSName DK_R = COSName.constant("R");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());

    protected PDAppearance(COSObject cOSObject) {
        super(cOSObject);
    }

    protected void collectAppearances(COSDictionary cOSDictionary, List<PDForm> list) {
        for (COSObject cOSObject : cOSDictionary.values()) {
            IAttributeSupport iAttributeSupport;
            if (cOSObject.isNull()) continue;
            if (cOSObject instanceof COSStream && (iAttributeSupport = (PDForm)PDForm.META.createFromCos(cOSObject)) != null) {
                list.add((PDForm)iAttributeSupport);
            }
            if (!(cOSObject instanceof COSDictionary)) continue;
            iAttributeSupport = (COSDictionary)cOSObject;
            this.collectAppearances((COSDictionary)iAttributeSupport, list);
        }
    }

    public PDForm getAppearance(COSName cOSName, COSName cOSName2) {
        PDForm pDForm = this.getForm(cOSName, cOSName2);
        if (pDForm == null) {
            pDForm = this.getNormalAppearance(cOSName2);
        }
        return pDForm;
    }

    public PDForm getDownAppearance(COSName cOSName) {
        return this.getForm(DK_D, cOSName);
    }

    protected PDForm getForm(COSName cOSName, COSName cOSName2) {
        COSObject cOSObject = this.cosGetField(cOSName);
        if (cOSObject.isNull()) {
            return null;
        }
        if (cOSObject instanceof COSStream) {
            return (PDForm)PDForm.META.createFromCos(cOSObject);
        }
        if (cOSObject instanceof COSDictionary && cOSName2 != null) {
            COSDictionary cOSDictionary = (COSDictionary)cOSObject;
            COSStream cOSStream = cOSDictionary.get(cOSName2).asStream();
            return (PDForm)PDForm.META.createFromCos(cOSStream);
        }
        return null;
    }

    public List<PDForm> getForms() {
        ArrayList<PDForm> arrayList = new ArrayList<PDForm>();
        this.collectAppearances(this.cosGetDict(), arrayList);
        return arrayList;
    }

    public PDForm getNormalAppearance(COSName cOSName) {
        return this.getForm(DK_N, cOSName);
    }

    public PDForm getRolloverAppearance(COSName cOSName) {
        return this.getForm(DK_R, cOSName);
    }

    public boolean isDefined() {
        return this.getNormalAppearance(null) != null;
    }

    public boolean isDefined(COSName cOSName, COSName cOSName2) {
        PDForm pDForm = this.getForm(cOSName, cOSName2);
        if (pDForm == null) {
            pDForm = this.getNormalAppearance(cOSName2);
        }
        return pDForm != null;
    }

    public void setDownAppearance(COSName cOSName, PDForm pDForm) {
        this.setForm(DK_D, cOSName, pDForm);
    }

    protected void setForm(COSName cOSName, COSName cOSName2, PDForm pDForm) {
        COSObject cOSObject = this.cosGetField(cOSName);
        if (cOSName2 == null) {
            if (pDForm != null) {
                this.cosSetField(cOSName, pDForm.cosGetStream());
            } else {
                this.cosRemoveField(cOSName);
            }
        } else {
            if (!(cOSObject instanceof COSDictionary)) {
                cOSObject = COSDictionary.create();
                this.cosSetField(cOSName, cOSObject);
            }
            COSDictionary cOSDictionary = (COSDictionary)cOSObject;
            if (pDForm != null) {
                cOSDictionary.put(cOSName2, pDForm.cosGetStream());
            } else {
                cOSDictionary.remove(cOSName2);
            }
        }
    }

    public void setNormalAppearance(COSName cOSName, PDForm pDForm) {
        this.setForm(DK_N, cOSName, pDForm);
    }

    public void setRolloverAppearance(COSName cOSName, PDForm pDForm) {
        this.setForm(DK_R, cOSName, pDForm);
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDAppearance(cOSObject);
        }

        @Override
        protected boolean isIndirect() {
            return false;
        }
    }
}

