/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.parser;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.COSLoadWarning;
import de.intarsys.pdf.parser.PDFParser;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class COSDocumentParser
extends PDFParser {
    public static final int SEARCH_BUFFER_SIZE = 2048;
    private STDocument doc;

    public COSDocumentParser(STDocument sTDocument) {
        this.doc = sTDocument;
    }

    @Override
    protected COSIndirectObject createObjectReference(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        COSObject cOSObject = this.lookaheadPop();
        COSObject cOSObject2 = this.lookaheadPop();
        if (!(cOSObject instanceof COSInteger) || !(cOSObject2 instanceof COSInteger)) {
            COSLoadError cOSLoadError = new COSLoadError("illegal reference at character index " + iRandomAccess.getOffset());
            this.handleError(cOSLoadError);
        }
        int n = ((COSInteger)cOSObject).intValue();
        int n2 = ((COSInteger)cOSObject2).intValue();
        return this.getDoc().getObjectReference(n, n2);
    }

    public STDocument getDoc() {
        return this.doc;
    }

    public boolean isTokenXRefAt(IRandomAccess iRandomAccess, int n) throws IOException {
        iRandomAccess.seek((long)n);
        this.readSpaces(iRandomAccess);
        byte[] byArray = new byte[4];
        iRandomAccess.read(byArray);
        return Arrays.equals(byArray, PDFParser.TOKEN_xref);
    }

    public COSObject parseIndirectObject(IRandomAccess iRandomAccess, ISystemSecurityHandler iSystemSecurityHandler) throws IOException, COSLoadException {
        COSObjectKey cOSObjectKey = this.parseIndirectObjectKey(iRandomAccess);
        COSObjectKey cOSObjectKey2 = this.getObjectKey();
        ISystemSecurityHandler iSystemSecurityHandler2 = this.getSecurityHandler();
        try {
            this.setObjectKey(cOSObjectKey);
            this.setSecurityHandler(iSystemSecurityHandler);
            COSObject cOSObject = this.parseIndirectObjectBody(iRandomAccess);
            if (cOSObject == null) {
                cOSObject = COSNull.NULL;
            }
            COSObject cOSObject2 = cOSObject;
            return cOSObject2;
        }
        finally {
            this.setObjectKey(cOSObjectKey2);
            this.setSecurityHandler(iSystemSecurityHandler2);
        }
    }

    protected COSObject parseIndirectObjectBody(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        COSDocumentElement cOSDocumentElement = this.parseObject(iRandomAccess);
        if (cOSDocumentElement == null) {
            COSLoadError cOSLoadError = new COSLoadError("object expected at character index " + iRandomAccess.getOffset());
            this.handleError(cOSLoadError);
        } else {
            byte[] byArray;
            Serializable serializable;
            if (cOSDocumentElement.isReference()) {
                serializable = new COSLoadError("object reference not allowed in a indirect object at character index " + iRandomAccess.getOffset());
                this.handleError((COSLoadError)serializable);
            }
            if (this.check) {
                serializable = new ArrayList();
                byArray = this.readToken(iRandomAccess, (List)((Object)serializable), false);
                if (!(serializable.size() <= 0 || serializable.size() == 1 && serializable.contains("additional whitespace before") || serializable.size() == 1 && serializable.contains("second add whitespace after"))) {
                    COSLoadWarning cOSLoadWarning = new COSLoadWarning("618b");
                    cOSLoadWarning.setHint(new Long(iRandomAccess.getOffset()));
                    this.handleWarning(cOSLoadWarning);
                }
            } else {
                byArray = this.readToken(iRandomAccess);
            }
            if (byArray == null) {
                serializable = new COSLoadError("unexpected end of file");
                this.handleError((COSLoadError)serializable);
            }
            if (!Arrays.equals(byArray, TOKEN_endobj)) {
                iRandomAccess.seekBy((long)(-byArray.length));
                serializable = new COSLoadWarning("618c");
                this.handleWarning((COSLoadWarning)serializable);
            }
        }
        return (COSObject)cOSDocumentElement;
    }

    protected COSObjectKey parseIndirectObjectKey(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        COSLoadException cOSLoadException;
        COSLoadException cOSLoadException2;
        ArrayList arrayList = new ArrayList();
        byte[] byArray = this.check ? this.readToken(iRandomAccess, arrayList, true) : this.readToken(iRandomAccess);
        if (byArray == null) {
            COSLoadError cOSLoadError = new COSLoadError("unexpected end of file");
            this.handleError(cOSLoadError);
        }
        int n = 0;
        try {
            n = Integer.parseInt(new String(byArray));
            if (arrayList.size() > 1) {
                cOSLoadException2 = new COSLoadWarning("618a");
                cOSLoadException2.setHint(new Long(iRandomAccess.getOffset()));
                this.handleWarning((COSLoadWarning)cOSLoadException2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            cOSLoadException = new COSLoadError("invalid object number at character index " + iRandomAccess.getOffset());
            this.handleError((COSLoadError)cOSLoadException);
        }
        arrayList.clear();
        byArray = this.check ? this.readToken(iRandomAccess, arrayList, true) : this.readToken(iRandomAccess);
        if (byArray == null) {
            cOSLoadException2 = new COSLoadError("unexpected end of file");
            this.handleError((COSLoadError)cOSLoadException2);
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(new String(byArray));
            if (arrayList.size() > 1) {
                cOSLoadException = new COSLoadWarning("618a");
                cOSLoadException.setHint(new Long(iRandomAccess.getOffset()));
                this.handleWarning((COSLoadWarning)cOSLoadException);
            }
        }
        catch (NumberFormatException numberFormatException) {
            COSLoadError cOSLoadError = new COSLoadError("invalid generation number at character index " + iRandomAccess.getOffset());
            this.handleError(cOSLoadError);
        }
        arrayList.clear();
        byArray = this.check ? this.readToken(iRandomAccess, arrayList, true) : this.readToken(iRandomAccess);
        if (byArray == null) {
            cOSLoadException = new COSLoadError("unexpected end of file");
            this.handleError((COSLoadError)cOSLoadException);
        }
        if (!Arrays.equals(byArray, TOKEN_obj)) {
            iRandomAccess.seekBy((long)(-byArray.length));
            cOSLoadException = new COSLoadError("file format error, obj expected at character index " + iRandomAccess.getOffset());
            this.handleError((COSLoadError)cOSLoadException);
        }
        if (this.check) {
            if (arrayList.size() > 0) {
                cOSLoadException = new COSLoadWarning("618a");
                cOSLoadException.setHint(new Long(iRandomAccess.getOffset()));
                this.handleWarning((COSLoadWarning)cOSLoadException);
            }
            if (this.readEOL(iRandomAccess) > 1) {
                cOSLoadException = new COSLoadWarning("618b");
                cOSLoadException.setHint(new Long(iRandomAccess.getOffset()));
                this.handleWarning((COSLoadWarning)cOSLoadException);
            }
        } else {
            this.readSpaces(iRandomAccess);
        }
        return new COSObjectKey(n, n2);
    }

    public int parseStartXRef(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        this.readSpaces(iRandomAccess);
        byte[] byArray = new byte[9];
        iRandomAccess.read(byArray);
        if (!Arrays.equals(byArray, PDFParser.TOKEN_startxref)) {
            COSLoadError cOSLoadError = new COSLoadError("file format error. 'startxref' expected at offset:" + (iRandomAccess.getOffset() - 9L));
            this.handleError(cOSLoadError);
        }
        return this.readInteger(iRandomAccess, true);
    }

    public COSDictionary parseTrailer(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        Object object;
        byte[] byArray = new byte[7];
        int n = iRandomAccess.read(byArray);
        if (!Arrays.equals(byArray, TOKEN_trailer)) {
            if (n > 0) {
                iRandomAccess.seekBy((long)(-n));
            }
            object = new COSLoadError("file format error. 'trailer' expected at character index " + iRandomAccess.getOffset());
            this.handleError((COSLoadError)object);
        }
        this.readSpaces(iRandomAccess);
        object = (COSDictionary)this.parseObjectDictionary(iRandomAccess);
        this.readSpaces(iRandomAccess);
        return object;
    }

    public int searchLastStartXRef(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        long l = iRandomAccess.getLength() - 2048L;
        if (l < 0L) {
            l = 0L;
        }
        iRandomAccess.seek(l);
        byte[] byArray = new byte[2048];
        int n = iRandomAccess.read(byArray);
        boolean bl = false;
        int n2 = n - TOKEN_startxref.length;
        while (n2 > 0) {
            int n3 = 0;
            while (n3 < TOKEN_startxref.length) {
                if (byArray[n2 + n3] != TOKEN_startxref[n3]) {
                    bl = false;
                    break;
                }
                bl = true;
                ++n3;
            }
            if (bl) break;
            --n2;
        }
        if (bl) {
            long l2 = l + (long)n2;
            iRandomAccess.seek(l2);
            return this.parseStartXRef(iRandomAccess);
        }
        COSLoadError cOSLoadError = new COSLoadError("no startxref found in the last 2048 bytes of the document");
        this.handleError(cOSLoadError);
        return -1;
    }

    @Deprecated
    public int searchLinearized(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        long l = iRandomAccess.getOffset();
        int n = -1;
        iRandomAccess.seek(0L);
        this.parseComment(iRandomAccess);
        int n2 = iRandomAccess.read();
        while (n2 != -1) {
            if (n2 == 32 || COSDocumentParser.isWhitespace(n2)) {
                n2 = iRandomAccess.read();
                continue;
            }
            iRandomAccess.seekBy(-1L);
            if (COSDocumentParser.isDigit(n2)) {
                n = (int)iRandomAccess.getOffset();
                COSObject cOSObject = this.parseIndirectObject(iRandomAccess, null);
                COSName cOSName = COSName.constant("Linearized");
                if (cOSObject instanceof COSDictionary && ((COSDictionary)cOSObject).containsKey(cOSName)) {
                    return n;
                }
                n = -1;
                break;
            }
            if (n2 != 37) break;
            this.parseComment(iRandomAccess);
            n2 = iRandomAccess.read();
        }
        iRandomAccess.seek(l);
        return n;
    }
}

